/*
 * Decompiled with CFR 0.152.
 */
package alpvax.mc.goprone;

import alpvax.mc.goprone.ClientProxy;
import alpvax.mc.goprone.PacketHandler;
import alpvax.mc.goprone.config.ConfigOptions;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="goprone")
public class GoProne {
    public static final String MODID = "goprone";
    private static final Logger LOGGER = LogManager.getLogger();
    static final Map<UUID, Boolean> entityProneStates = Maps.newConcurrentMap();

    public GoProne() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientProxy::init);
        PacketHandler.register();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, ConfigOptions.SPEC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ConfigOptions::onModConfigEvent);
    }

    public static void setProne(UUID playerID, boolean prone) {
        entityProneStates.put(playerID, prone);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (event.player.field_70170_p.field_72995_K) {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientProxy.updateProneState(event.player));
            }
            if (entityProneStates.getOrDefault(event.player.func_110124_au(), false).booleanValue() && ConfigOptions.test(event.player)) {
                event.player.func_213301_b(Pose.SWIMMING);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerJump(LivingEvent.LivingJumpEvent event) {
        PlayerEntity player;
        if (event.getEntity() instanceof PlayerEntity && (player = (PlayerEntity)event.getEntityLiving()).func_233570_aj_() && player.func_213283_Z() == Pose.SWIMMING && !ConfigOptions.isJumpingAllowed()) {
            Vector3d motion = player.func_213322_ci();
            player.func_213317_d(motion.func_72441_c(0.0, -motion.field_72448_b, 0.0));
        }
    }
}

