/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone;

import de.maxhenkel.gravestone.corelib.config.ConfigBase;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class ClientConfig
extends ConfigBase {
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> dimensionNamesSpec;
    private final ForgeConfigSpec.ConfigValue<String> dateFormatSpec;
    public final ForgeConfigSpec.BooleanValue renderSkull;
    private final ForgeConfigSpec.ConfigValue<String> graveTextColorSpec;
    public Map<String, String> dimensionNames = new HashMap<String, String>();
    public int graveTextColor = 0xFFFFFF;
    public SimpleDateFormat dateFormat;

    public ClientConfig(ForgeConfigSpec.Builder builder) {
        super(builder);
        this.dimensionNamesSpec = builder.comment("The names of the Dimensions for the Death Note").translation("dimension_names").defineList("dimension_names", Arrays.asList("minecraft:overworld=Overworld", "minecraft:the_nether=Nether", "minecraft:the_end=The End"), e -> e instanceof String);
        this.dateFormatSpec = builder.comment("The date format outputted by clicking the gravestone or displayed in the death note").translation("grave_date_format").define("grave_date_format", (Object)"yyyy/MM/dd HH:mm:ss");
        this.renderSkull = builder.comment("If this is set to true the players head will be rendered on the gravestone when there is a full block under it").translation("render_skull").define("render_skull", true);
        this.graveTextColorSpec = builder.comment("The color of the text at the gravestone (Hex RGB)").translation("grave_text_color").define("grave_text_color", (Object)"FFFFFF");
    }

    @Override
    public void onReload(ModConfig.ModConfigEvent event) {
        super.onReload(event);
        this.dimensionNames = ((List)this.dimensionNamesSpec.get()).stream().collect(Collectors.toMap(s -> s.split("=")[0], s -> s.split("=")[1]));
        this.graveTextColor = Integer.parseInt((String)this.graveTextColorSpec.get(), 16);
        this.dateFormat = new SimpleDateFormat((String)this.dateFormatSpec.get());
    }
}

