/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone;

import de.maxhenkel.gravestone.DeathInfo;
import de.maxhenkel.gravestone.Main;
import de.maxhenkel.gravestone.blocks.GraveStoneBlock;
import de.maxhenkel.gravestone.tileentity.GraveStoneTileEntity;
import de.maxhenkel.gravestone.util.NoSpaceException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GraveProcessor {
    private LivingEntity entity;
    private World world;
    private BlockPos deathPosition;
    private BlockPos gravePosition;
    private List<ItemStack> drops;
    private long time;

    public GraveProcessor(LivingEntity entity) {
        this.entity = entity;
        this.world = entity.func_130014_f_();
        this.gravePosition = this.deathPosition = entity.func_233580_cy_();
        this.drops = new ArrayList<ItemStack>();
        this.time = System.currentTimeMillis();
    }

    public boolean placeGraveStone(Collection<ItemEntity> drops) {
        this.drops = drops.stream().map(itemEntity -> itemEntity.func_92059_d()).collect(Collectors.toList());
        try {
            this.gravePosition = this.getGraveStoneLocation();
        }
        catch (NoSpaceException e) {
            this.gravePosition = this.deathPosition;
            Main.LOGGER.info("Grave of '{}' cant be created (No space)", (Object)this.entity.func_200200_C_().getString());
            return false;
        }
        try {
            this.world.func_175656_a(this.gravePosition, (BlockState)Main.GRAVESTONE.func_176223_P().func_206870_a((Property)GraveStoneBlock.FACING, (Comparable)this.entity.func_174811_aO().func_176734_d()));
            if (this.isReplaceable(this.gravePosition.func_177977_b())) {
                this.world.func_175656_a(this.gravePosition.func_177977_b(), Blocks.field_150346_d.func_176223_P());
            }
        }
        catch (Exception e) {
            return false;
        }
        TileEntity tileentity = this.world.func_175625_s(this.gravePosition);
        if (!(tileentity instanceof GraveStoneTileEntity)) {
            return false;
        }
        try {
            GraveStoneTileEntity graveTileEntity = (GraveStoneTileEntity)tileentity;
            graveTileEntity.setPlayerName(this.entity.func_200200_C_().getString());
            graveTileEntity.setPlayerUUID(this.entity.func_110124_au().toString());
            graveTileEntity.setDeathTime(this.time);
            graveTileEntity.setRenderHead(this.entity instanceof PlayerEntity);
            this.addItems(graveTileEntity, drops);
        }
        catch (Exception e) {
            Main.LOGGER.warn("Failed to fill gravestone with data");
        }
        return true;
    }

    private void addItems(GraveStoneTileEntity graveStone, Collection<ItemEntity> items) {
        try {
            int i = 0;
            for (ItemEntity item : items) {
                try {
                    ItemStack stack = item.func_92059_d();
                    if (graveStone.getInventory().func_70302_i_() > i) {
                        graveStone.getInventory().func_70299_a(i, stack);
                    } else {
                        InventoryHelper.func_180173_a((World)this.world, (double)graveStone.func_174877_v().func_177958_n(), (double)graveStone.func_174877_v().func_177956_o(), (double)graveStone.func_174877_v().func_177952_p(), (ItemStack)stack);
                    }
                }
                catch (Exception e) {
                    Main.LOGGER.warn("Failed to add Item '{}' to gravestone", (Object)item.func_92059_d().func_77973_b().func_77658_a());
                }
                ++i;
            }
        }
        catch (Exception e) {
            Main.LOGGER.warn("Failed to add Ites to gravestone");
        }
    }

    public BlockPos getGraveStoneLocation() throws NoSpaceException {
        BlockPos location = new BlockPos(this.deathPosition.func_177958_n(), this.deathPosition.func_177956_o(), this.deathPosition.func_177952_p());
        if (World.func_189509_E((BlockPos)location) && location.func_177956_o() <= 0) {
            location = new BlockPos(location.func_177958_n(), 1, location.func_177952_p());
        }
        while (!World.func_189509_E((BlockPos)location)) {
            if (this.isReplaceable(location)) {
                return location;
            }
            location = location.func_177982_a(0, 1, 0);
        }
        throw new NoSpaceException("No free Block above death Location");
    }

    private boolean isReplaceable(BlockPos pos) {
        Block b = this.world.func_180495_p(pos).func_177230_c();
        if (this.world.func_175623_d(pos)) {
            return true;
        }
        return Main.SERVER_CONFIG.replaceableBlocks.stream().anyMatch(replaceableBlock -> b.getRegistryName().equals((Object)replaceableBlock.getRegistryName()));
    }

    public void givePlayerNote() {
        if (!(this.entity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)this.entity;
        List<ItemStack> deathNoteItems = this.drops.stream().map(itemStack -> {
            if (itemStack.equals((Object)Main.DEATHINFO)) {
                ItemStack stack = itemStack.func_77946_l();
                stack.func_77982_d(null);
                return stack;
            }
            return itemStack;
        }).collect(Collectors.toList());
        DeathInfo info = new DeathInfo(this.gravePosition, player.field_70170_p.func_234923_W_().func_240901_a_().toString(), deathNoteItems, player.func_200200_C_().getString(), this.time, player.func_110124_au());
        ItemStack stack = new ItemStack((IItemProvider)Main.DEATHINFO);
        info.addToItemStack(stack);
        player.field_71071_by.func_70441_a(stack);
    }

    public LivingEntity getEntity() {
        return this.entity;
    }
}

