/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.entity;

import de.maxhenkel.gravestone.Main;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class GhostPlayerEntity
extends MonsterEntity {
    private static final DataParameter<String> PLAYER_UUID = EntityDataManager.func_187226_a(GhostPlayerEntity.class, (IDataSerializer)DataSerializers.field_187194_d);

    public GhostPlayerEntity(EntityType type, World world) {
        super(type, world);
    }

    public GhostPlayerEntity(World world, UUID playerUUID, String playerName) {
        this(Main.GHOST, world);
        this.setPlayerUUID(playerUUID);
        this.func_200203_b((ITextComponent)new StringTextComponent(playerName));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(PLAYER_UUID, (Object)new UUID(0L, 0L).toString());
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233823_f_, 3.0).func_233815_a_(Attributes.field_233826_i_, 2.0).func_233815_a_(Attributes.field_233821_d_, (double)0.23f).func_233815_a_(Attributes.field_233819_b_, 35.0);
    }

    public boolean func_94059_bO() {
        return false;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookRandomlyGoal((MobEntity)this));
        if (((Boolean)Main.SERVER_CONFIG.friendlyGhost.get()).booleanValue()) {
            this.field_70715_bh.func_75776_a(10, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, 10, false, true, entityLiving -> entityLiving != null && !entityLiving.func_82150_aj() && entityLiving instanceof MonsterEntity && !(entityLiving instanceof CreeperEntity) && !(entityLiving instanceof GhostPlayerEntity)));
        } else {
            this.field_70715_bh.func_75776_a(10, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        }
    }

    public boolean func_70662_br() {
        return true;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    public void setPlayerUUID(UUID uuid) {
        this.func_184212_Q().func_187227_b(PLAYER_UUID, (Object)uuid.toString());
        if (uuid.toString().equals("af3bd5f4-8634-4700-8281-e4cc851be180")) {
            this.setOverpowered();
        }
    }

    private void setOverpowered() {
        this.func_110148_a(Attributes.field_233819_b_).func_111128_a(35.0);
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.4);
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a(20.0);
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        if (name != null && name.getString().equals("henkelmax")) {
            this.setOverpowered();
        }
    }

    public UUID getPlayerUUID() {
        String uuidStr = (String)this.func_184212_Q().func_187225_a(PLAYER_UUID);
        UUID uuid = new UUID(0L, 0L);
        try {
            uuid = UUID.fromString(uuidStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uuid;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74778_a("player_uuid", this.getPlayerUUID().toString());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("player_uuid")) {
            String uuidStr = compound.func_74779_i("player_uuid");
            try {
                UUID uuid = UUID.fromString(uuidStr);
                this.setPlayerUUID(uuid);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        if (entityIn.func_200200_C_().getString().equals("henkelmax") || entityIn.func_110124_au().toString().equals("af3bd5f4-8634-4700-8281-e4cc851be180")) {
            return true;
        }
        return super.func_70652_k(entityIn);
    }
}

