/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.events;

import de.maxhenkel.gravestone.DeathInfo;
import de.maxhenkel.gravestone.GraveProcessor;
import de.maxhenkel.gravestone.Main;
import de.maxhenkel.gravestone.util.Tools;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class DeathEvents {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerCloneLast(PlayerEvent.Clone event) {
        if (!((Boolean)Main.SERVER_CONFIG.giveDeathNotes.get()).booleanValue()) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        if (!event.isWasDeath()) {
            return;
        }
        if (Tools.keepInventory(event.getPlayer())) {
            return;
        }
        for (ItemStack stack : event.getOriginal().field_71071_by.field_70462_a) {
            if (!DeathInfo.isDeathInfoItem(stack)) continue;
            event.getPlayer().field_71071_by.func_70441_a(stack);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void playerDeath(LivingDropsEvent event) {
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (!(event.getEntity() instanceof PlayerEntity) && !((Boolean)Main.SERVER_CONFIG.livingGraves.get()).booleanValue()) {
            return;
        }
        if (event.getEntity().func_130014_f_().field_72995_K) {
            return;
        }
        try {
            LivingEntity entity = (LivingEntity)event.getEntity();
            GraveProcessor graveProcessor = new GraveProcessor(entity);
            Collection drops = event.getDrops();
            if (graveProcessor.placeGraveStone(drops)) {
                drops.clear();
            } else if (entity instanceof ServerPlayerEntity) {
                String modname = new TranslationTextComponent("message.gravestone.name").getString();
                String message = new TranslationTextComponent("message.gravestone.create_grave_failed").getString();
                ServerPlayerEntity player = (ServerPlayerEntity)entity;
                player.func_145747_a((ITextComponent)new StringTextComponent("[" + modname + "] " + message), player.func_110124_au());
            }
            if (((Boolean)Main.SERVER_CONFIG.giveDeathNotes.get()).booleanValue()) {
                graveProcessor.givePlayerNote();
            }
        }
        catch (Exception e) {
            Main.LOGGER.warn("Failed to process death of '{}'", (Object)event.getEntity().func_200200_C_().getString());
            e.printStackTrace();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void playerDeath(LivingDeathEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (!((Boolean)Main.SERVER_CONFIG.giveDeathNotes.get()).booleanValue()) {
            return;
        }
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        if (event.getEntity().func_130014_f_().field_72995_K) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntity();
        if (!Tools.keepInventory(player)) {
            return;
        }
        try {
            DeathInfo info = new DeathInfo(player.func_233580_cy_(), player.field_70170_p.func_234923_W_().func_240901_a_().toString(), new ArrayList<ItemStack>(), player.func_200200_C_().getString(), System.currentTimeMillis(), player.func_110124_au());
            ItemStack stack = new ItemStack((IItemProvider)Main.DEATHINFO);
            info.addToItemStack(stack);
            player.field_71071_by.func_70441_a(stack);
        }
        catch (Exception e) {
            Main.LOGGER.warn("Failed to give player '{}' death note", (Object)player.func_200200_C_().getString());
        }
    }
}

