/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.blocks;

import com.google.common.collect.ImmutableList;
import de.maxhenkel.gravestone.GraveUtils;
import de.maxhenkel.gravestone.Main;
import de.maxhenkel.gravestone.corelib.block.DirectionalVoxelShape;
import de.maxhenkel.gravestone.corelib.block.IItemBlock;
import de.maxhenkel.gravestone.corelib.death.Death;
import de.maxhenkel.gravestone.entity.GhostPlayerEntity;
import de.maxhenkel.gravestone.tileentity.GraveStoneTileEntity;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class GraveStoneBlock
extends Block
implements ITileEntityProvider,
IItemBlock,
IBucketPickupHandler,
ILiquidContainer {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final VoxelShape BASE1 = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final VoxelShape BASE2 = Block.func_208617_a((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);
    private static final DirectionalVoxelShape SHAPE = new DirectionalVoxelShape.Builder().direction(Direction.NORTH, BASE1, BASE2, Block.func_208617_a((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)12.0, (double)2.0), Block.func_208617_a((double)2.0, (double)12.0, (double)1.0, (double)14.0, (double)14.0, (double)2.0), Block.func_208617_a((double)3.0, (double)14.0, (double)1.0, (double)13.0, (double)15.0, (double)2.0)).direction(Direction.SOUTH, BASE1, BASE2, Block.func_208617_a((double)1.0, (double)2.0, (double)15.0, (double)15.0, (double)12.0, (double)14.0), Block.func_208617_a((double)2.0, (double)12.0, (double)15.0, (double)14.0, (double)14.0, (double)14.0), Block.func_208617_a((double)3.0, (double)14.0, (double)15.0, (double)13.0, (double)15.0, (double)14.0)).direction(Direction.EAST, BASE1, BASE2, Block.func_208617_a((double)15.0, (double)2.0, (double)1.0, (double)14.0, (double)12.0, (double)15.0), Block.func_208617_a((double)15.0, (double)12.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0), Block.func_208617_a((double)15.0, (double)14.0, (double)3.0, (double)14.0, (double)15.0, (double)13.0)).direction(Direction.WEST, BASE1, BASE2, Block.func_208617_a((double)1.0, (double)2.0, (double)1.0, (double)2.0, (double)12.0, (double)15.0), Block.func_208617_a((double)1.0, (double)12.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0), Block.func_208617_a((double)1.0, (double)14.0, (double)3.0, (double)2.0, (double)15.0, (double)13.0)).build();
    public static final Material GRAVESTONE_MATERIAL = new Material(MaterialColor.field_151664_l, false, true, true, false, false, false, PushReaction.BLOCK);

    public GraveStoneBlock() {
        super(AbstractBlock.Properties.func_200949_a((Material)GRAVESTONE_MATERIAL, (MaterialColor)MaterialColor.field_151664_l).func_200948_a(0.3f, Float.MAX_VALUE));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.setRegistryName("gravestone", "gravestone");
    }

    @Override
    public Item toItem() {
        return (Item)new BlockItem((Block)this, new Item.Properties().func_200916_a(ItemGroup.field_78031_c)).setRegistryName(this.getRegistryName());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
        builder.func_206894_a(new Property[]{WATERLOGGED});
    }

    public Fluid func_204508_a(IWorld world, BlockPos pos, BlockState state) {
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 3);
            return Fluids.field_204546_a;
        }
        return Fluids.field_204541_a;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_204510_a(IBlockReader world, BlockPos pos, BlockState state, Fluid fluid) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) == false && fluid == Fluids.field_204546_a;
    }

    public boolean func_204509_a(IWorld world, BlockPos pos, BlockState state, FluidState fluidState) {
        if (!((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue() && fluidState.func_206886_c() == Fluids.field_204546_a) {
            if (!world.func_201670_d()) {
                world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
                world.func_205219_F_().func_205360_a(pos, (Object)fluidState.func_206886_c(), fluidState.func_206886_c().func_205569_a((IWorldReader)world));
            }
            return true;
        }
        return false;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity tileentity;
        if (stack.func_82837_s() && (tileentity = world.func_175625_s(pos)) instanceof GraveStoneTileEntity) {
            GraveStoneTileEntity grave = (GraveStoneTileEntity)tileentity;
            grave.setCustomName(stack.func_200301_q());
        }
        super.func_180633_a(world, pos, state, placer, stack);
    }

    public void func_180652_a(World world, BlockPos pos, Explosion explosion) {
    }

    public void onBlockExploded(BlockState state, World world, BlockPos pos, Explosion explosion) {
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f())).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a));
    }

    public boolean canEntityDestroy(BlockState state, IBlockReader world, BlockPos pos, Entity entity) {
        return false;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (!(tileentity instanceof GraveStoneTileEntity)) {
            return ActionResultType.FAIL;
        }
        GraveStoneTileEntity grave = (GraveStoneTileEntity)tileentity;
        ITextComponent name = grave.getGraveName();
        if (name == null) {
            return ActionResultType.FAIL;
        }
        if (world.field_72995_K) {
            IFormattableTextComponent time = GraveUtils.getDate(grave.getDeath().getTimestamp());
            if (time == null) {
                player.func_145747_a(name, Util.field_240973_b_);
            } else {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("message.gravestone.died", new Object[]{name, time}), Util.field_240973_b_);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = world.func_175625_s(pos);
            if (tileentity instanceof GraveStoneTileEntity) {
                this.dropItems(world, pos, ((GraveStoneTileEntity)tileentity).getDeath().getAllItems());
            }
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    public void dropItems(World world, BlockPos pos, NonNullList<ItemStack> items) {
        for (ItemStack item : items) {
            InventoryHelper.func_180173_a((World)world, (double)((double)pos.func_177958_n() + 0.5), (double)((double)pos.func_177956_o() + 0.5), (double)((double)pos.func_177952_p() + 0.5), (ItemStack)item);
        }
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        if (!GraveUtils.canBreakGrave((IWorld)world, player, pos)) {
            return false;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!world.field_72995_K && te instanceof GraveStoneTileEntity) {
            GraveStoneTileEntity grave = (GraveStoneTileEntity)te;
            this.removeObituary(player, grave);
            this.spawnGhost(world, pos, grave);
            if (!grave.getDeath().getId().equals(GraveUtils.EMPTY_UUID) && ((Boolean)Main.SERVER_CONFIG.breakPickup.get()).booleanValue()) {
                this.sortItems(world, pos, player, grave);
            }
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    protected void spawnGhost(World world, BlockPos pos, GraveStoneTileEntity grave) {
        if (!((Boolean)Main.SERVER_CONFIG.spawnGhost.get()).booleanValue()) {
            return;
        }
        if (!world.func_175623_d(pos.func_177984_a())) {
            return;
        }
        UUID uuid = grave.getDeath().getPlayerUUID();
        if (uuid.equals(GraveUtils.EMPTY_UUID)) {
            return;
        }
        GhostPlayerEntity ghost = new GhostPlayerEntity(world, uuid, (ITextComponent)new StringTextComponent(grave.getDeath().getPlayerName()), grave.getDeath().getEquipment(), grave.getDeath().getModel());
        ghost.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5);
        world.func_217376_c((Entity)ghost);
    }

    protected void removeObituary(PlayerEntity p, GraveStoneTileEntity grave) {
        if (!((Boolean)Main.SERVER_CONFIG.removeObituary.get()).booleanValue()) {
            return;
        }
        if (!(p instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)p;
        PlayerInventory inv = player.field_71071_by;
        ImmutableList invs = ImmutableList.of((Object)player.field_71071_by.field_70462_a, (Object)player.field_71071_by.field_70460_b, (Object)player.field_71071_by.field_184439_c);
        for (NonNullList i : invs) {
            for (ItemStack stack : i) {
                Death death;
                if (!stack.func_77973_b().equals((Object)Main.OBITUARY) || (death = Main.OBITUARY.fromStack(player, stack)) == null || grave.getDeath().getId().equals(GraveUtils.EMPTY_UUID) || !grave.getDeath().getId().equals(death.getId())) continue;
                inv.func_184437_d(stack);
            }
        }
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        super.func_196262_a(state, world, pos, entity);
        if (!(entity instanceof ServerPlayerEntity) || !((Boolean)Main.SERVER_CONFIG.sneakPickup.get()).booleanValue()) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)entity;
        if (!player.func_225608_bj_() || player.field_71075_bZ.field_75098_d || !GraveUtils.canBreakGrave((IWorld)world, (PlayerEntity)player, pos)) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof GraveStoneTileEntity)) {
            return;
        }
        GraveStoneTileEntity grave = (GraveStoneTileEntity)te;
        if (grave.getDeath().getId().equals(GraveUtils.EMPTY_UUID)) {
            return;
        }
        this.removeObituary((PlayerEntity)player, grave);
        this.spawnGhost(world, pos, grave);
        this.sortItems(world, pos, (PlayerEntity)player, grave);
        world.func_175655_b(pos, true);
    }

    protected void sortItems(World world, BlockPos pos, PlayerEntity player, GraveStoneTileEntity grave) {
        Death death = grave.getDeath();
        this.dropItems(world, pos, this.fillPlayerInventory(player, death));
        world.func_184133_a(null, pos, SoundEvents.field_187629_cO, SoundCategory.BLOCKS, 1.0f, 1.0f);
        grave.func_70296_d();
    }

    public NonNullList<ItemStack> fillPlayerInventory(PlayerEntity player, Death death) {
        NonNullList additionalItems = NonNullList.func_191196_a();
        this.fillInventory((List<ItemStack>)additionalItems, death.getMainInventory(), (NonNullList<ItemStack>)player.field_71071_by.field_70462_a);
        this.fillInventory((List<ItemStack>)additionalItems, death.getArmorInventory(), (NonNullList<ItemStack>)player.field_71071_by.field_70460_b);
        this.fillInventory((List<ItemStack>)additionalItems, death.getOffHandInventory(), (NonNullList<ItemStack>)player.field_71071_by.field_184439_c);
        additionalItems.addAll(death.getAdditionalItems());
        NonNullList restItems = NonNullList.func_191196_a();
        for (ItemStack stack : additionalItems) {
            if (player.field_71071_by.func_70441_a(stack)) continue;
            restItems.add((Object)stack);
        }
        death.getAdditionalItems().clear();
        return restItems;
    }

    public void fillInventory(List<ItemStack> additionalItems, NonNullList<ItemStack> inventory, NonNullList<ItemStack> playerInv) {
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack stack = (ItemStack)inventory.get(i);
            if (stack.func_190926_b()) continue;
            ItemStack playerStack = (ItemStack)playerInv.get(i);
            if (!playerStack.func_190926_b()) {
                additionalItems.add(playerStack);
            }
            inventory.set(i, (Object)ItemStack.field_190927_a);
            playerInv.set(i, (Object)stack);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return SHAPE.get((Direction)state.func_177229_b((Property)FACING));
    }

    public TileEntity func_196283_a_(IBlockReader reader) {
        return new GraveStoneTileEntity();
    }
}

