/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxhenkel.gravestone.corelib.client.PlayerSkins;
import de.maxhenkel.gravestone.entity.GhostPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HeadLayer;
import net.minecraft.client.renderer.entity.layers.HeldItemLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.util.ResourceLocation;

public class PlayerGhostRenderer
extends LivingRenderer<GhostPlayerEntity, PlayerModel<GhostPlayerEntity>> {
    private PlayerModel<GhostPlayerEntity> playerModel = new PlayerModel(0.0f, false);
    private PlayerModel<GhostPlayerEntity> playerModelSmallArms = new PlayerModel(0.0f, true);

    public PlayerGhostRenderer(EntityRendererManager renderManager) {
        super(renderManager, null, 0.5f);
        this.field_77045_g = this.playerModel;
        this.func_177094_a((LayerRenderer)new BipedArmorLayer((IEntityRenderer)this, new BipedModel(0.5f), new BipedModel(1.0f)));
        this.func_177094_a((LayerRenderer)new HeldItemLayer((IEntityRenderer)this));
        this.func_177094_a((LayerRenderer)new HeadLayer((IEntityRenderer)this));
        this.func_177094_a((LayerRenderer)new ElytraLayer((IEntityRenderer)this));
    }

    protected void preRenderCallback(GhostPlayerEntity ghost, MatrixStack matrixStack, float partialTickTime) {
        float scale = 0.9375f;
        matrixStack.func_227862_a_(scale, scale, scale);
    }

    public ResourceLocation getEntityTexture(GhostPlayerEntity entity) {
        return PlayerSkins.getSkin(entity.getPlayerUUID(), entity.func_200201_e().getString());
    }

    public void render(GhostPlayerEntity entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        packedLight = 0xFFFFFF;
        matrixStack.func_227860_a_();
        this.field_77045_g = PlayerSkins.isSlim(entity.getPlayerUUID()) ? this.playerModelSmallArms : this.playerModel;
        this.setModelVisibilities(entity);
        super.func_225623_a_((LivingEntity)entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
        matrixStack.func_227865_b_();
    }

    private void setModelVisibilities(GhostPlayerEntity playerEntity) {
        ((PlayerModel)this.field_77045_g).field_178720_f.field_78806_j = playerEntity.isWearing(PlayerModelPart.HAT);
        ((PlayerModel)this.field_77045_g).field_178730_v.field_78806_j = playerEntity.isWearing(PlayerModelPart.JACKET);
        ((PlayerModel)this.field_77045_g).field_178733_c.field_78806_j = playerEntity.isWearing(PlayerModelPart.LEFT_PANTS_LEG);
        ((PlayerModel)this.field_77045_g).field_178731_d.field_78806_j = playerEntity.isWearing(PlayerModelPart.RIGHT_PANTS_LEG);
        ((PlayerModel)this.field_77045_g).field_178734_a.field_78806_j = playerEntity.isWearing(PlayerModelPart.LEFT_SLEEVE);
        ((PlayerModel)this.field_77045_g).field_178732_b.field_78806_j = playerEntity.isWearing(PlayerModelPart.RIGHT_SLEEVE);
    }
}

