/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.gui;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.gravestone.GraveUtils;
import de.maxhenkel.gravestone.corelib.death.Death;
import de.maxhenkel.gravestone.entity.DummyPlayer;
import de.maxhenkel.gravestone.gui.PageList;
import java.util.Collections;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class ObituaryScreen
extends Screen {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("gravestone", "textures/gui/info.png");
    protected static final int TEXTURE_X = 163;
    protected static final int TEXTURE_Y = 165;
    protected static final int ITEM_OFFSET_LEFT = 40;
    protected static final int OFFSET_LEFT = 7;
    protected static final int OFFSET_RIGHT = 14;
    protected static final int ITEM_SIZE_OFFSET_LEFT = 15;
    private DummyPlayer player;
    private Death death;
    private Button buttonPrev;
    private Button buttonNext;
    private int page;
    private PageList pageList;
    private int guiLeft;
    private int guiTop;

    public ObituaryScreen(Death death) {
        super((ITextComponent)new TranslationTextComponent("gui.obituary.title"));
        this.death = death;
        this.page = 0;
        this.pageList = new PageList(death.getAllItems(), this);
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.guiLeft = (this.field_230708_k_ - 163) / 2;
        this.guiTop = (this.field_230709_l_ - 165) / 2;
        this.field_230710_m_.clear();
        int left = (this.field_230708_k_ - 163) / 2;
        this.buttonPrev = (Button)this.func_230480_a_((Widget)new Button(left, 190, 75, 20, (ITextComponent)new TranslationTextComponent("button.gravestone.prev"), button -> {
            --this.page;
            if (this.page < 0) {
                this.page = 0;
            }
            this.checkButtons();
        }));
        this.buttonNext = (Button)this.func_230480_a_((Widget)new Button(left + 163 - 75, 190, 75, 20, (ITextComponent)new TranslationTextComponent("button.gravestone.next"), button -> {
            ++this.page;
            if (this.page > this.pageList.getPages()) {
                this.page = this.pageList.getPages();
            }
            this.checkButtons();
        }));
        this.buttonPrev.field_230693_o_ = false;
        if (this.pageList.getPages() <= 0) {
            this.buttonNext.field_230693_o_ = false;
        }
    }

    protected void checkButtons() {
        this.buttonPrev.field_230693_o_ = this.page > 0;
        this.buttonNext.field_230693_o_ = this.page < this.pageList.getPages();
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float p_230430_4_) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, p_230430_4_);
        int left = (this.field_230708_k_ - 163) / 2;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(GUI_TEXTURE);
        this.func_238474_b_(matrixStack, left, 20, 0, 0, 163, 165);
        if (this.page == 0) {
            this.drawFirstPage(matrixStack, mouseX, mouseY);
        } else if (this.page > 0 && this.pageList.getPages() >= this.page - 1) {
            this.pageList.drawPage(matrixStack, this.page - 1, mouseX, mouseY);
        }
    }

    public void drawFirstPage(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.drawCentered(matrixStack, this.field_230712_o_, new TranslationTextComponent("gui.obituary.title").func_240699_a_(TextFormatting.UNDERLINE), this.field_230708_k_ / 2, 30, TextFormatting.BLACK.func_211163_e());
        int height = 50;
        if (this.field_230706_i_.field_71474_y.field_82882_x) {
            this.drawLeft(matrixStack, new TranslationTextComponent("gui.obituary.id").func_240702_b_(":").func_240699_a_(TextFormatting.BLACK), height);
            this.drawRight(matrixStack, new StringTextComponent(this.death.getId().toString()).func_240699_a_(TextFormatting.DARK_GRAY), height, 0.5f);
            height += 13;
        }
        this.drawLeft(matrixStack, new TranslationTextComponent("gui.obituary.name").func_240702_b_(":").func_240699_a_(TextFormatting.BLACK), height);
        this.drawRight(matrixStack, new StringTextComponent(this.death.getPlayerName()).func_240699_a_(TextFormatting.DARK_GRAY), height);
        this.drawLeft(matrixStack, new TranslationTextComponent("gui.obituary.dimension").func_240702_b_(":").func_240699_a_(TextFormatting.BLACK), height += 13);
        this.drawRight(matrixStack, new StringTextComponent(this.death.getDimension().split(":")[1]).func_240699_a_(TextFormatting.DARK_GRAY), height);
        this.drawLeft(matrixStack, new TranslationTextComponent("gui.obituary.time").func_240702_b_(":").func_240699_a_(TextFormatting.BLACK), height += 13);
        IFormattableTextComponent date = GraveUtils.getDate(this.death.getTimestamp());
        if (date != null) {
            this.drawRight(matrixStack, date.func_240699_a_(TextFormatting.DARK_GRAY), height);
        } else {
            this.drawRight(matrixStack, new StringTextComponent("N/A").func_240699_a_(TextFormatting.DARK_GRAY), height);
        }
        this.drawLeft(matrixStack, new TranslationTextComponent("gui.obituary.location").func_240702_b_(":").func_240699_a_(TextFormatting.BLACK), height += 13);
        BlockPos pos = this.death.getBlockPos();
        this.drawRight(matrixStack, new StringTextComponent("X: " + pos.func_177958_n()).func_240699_a_(TextFormatting.DARK_GRAY), height);
        this.drawRight(matrixStack, new StringTextComponent("Y: " + pos.func_177956_o()).func_240699_a_(TextFormatting.DARK_GRAY), height += 13);
        this.drawRight(matrixStack, new StringTextComponent("Z: " + pos.func_177952_p()).func_240699_a_(TextFormatting.DARK_GRAY), height += 13);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.player == null) {
            this.player = new DummyPlayer(this.field_230706_i_.field_71441_e, new GameProfile(this.death.getPlayerUUID(), this.death.getPlayerName()), this.death.getEquipment(), this.death.getModel());
        }
        InventoryScreen.func_228187_a_((int)(this.field_230708_k_ / 2), (int)170, (int)30, (float)(this.field_230708_k_ / 2 - mouseX), (float)(100 - mouseY), (LivingEntity)this.player);
        if (this.field_230706_i_.field_71474_y.field_82882_x && mouseX >= this.guiLeft + 7 && mouseX <= this.guiLeft + 163 - 7 && mouseY >= 50) {
            this.field_230712_o_.getClass();
            if (mouseY <= 50 + 9) {
                this.func_238654_b_(matrixStack, Collections.singletonList(new TranslationTextComponent("gui.obituary.copy_id").func_241878_f()), mouseX, mouseY);
            }
        }
    }

    public boolean func_231044_a_(double x, double y, int clickType) {
        if (this.field_230706_i_.field_71474_y.field_82882_x && this.page == 0 && x >= (double)(this.guiLeft + 7) && x <= (double)(this.guiLeft + 163 - 7) && y >= 50.0) {
            this.field_230712_o_.getClass();
            if (y <= (double)(50 + 9)) {
                this.field_230706_i_.field_195559_v.func_197960_a(this.death.getId().toString());
                IFormattableTextComponent deathID = TextComponentUtils.func_240647_a_((ITextComponent)new TranslationTextComponent("message.gravestone.death_id")).func_240700_a_(style -> style.func_240723_c_(TextFormatting.GREEN).func_240715_a_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/restore @s " + this.death.getId().toString() + " replace")).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent(this.death.getId().toString()))));
                this.field_230706_i_.field_71439_g.func_145747_a((ITextComponent)new TranslationTextComponent("message.gravestone.copied", new Object[]{deathID}), Util.field_240973_b_);
                this.field_230706_i_.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                this.field_230706_i_.func_147108_a(null);
            }
        }
        return super.func_231044_a_(x, y, clickType);
    }

    public void drawCentered(MatrixStack matrixStack, FontRenderer fontRenderer, IFormattableTextComponent text, int x, int y, int color) {
        fontRenderer.func_238422_b_(matrixStack, text.func_241878_f(), (float)(x - fontRenderer.func_238414_a_((ITextProperties)text) / 2), (float)y, color);
    }

    public void drawItem(MatrixStack matrixStack, IFormattableTextComponent string, int height) {
        this.field_230712_o_.func_238422_b_(matrixStack, string.func_241878_f(), (float)(this.guiLeft + 40), (float)height, TextFormatting.BLACK.func_211163_e().intValue());
    }

    public void drawItemSize(MatrixStack matrixStack, IFormattableTextComponent string, int height) {
        this.field_230712_o_.func_238422_b_(matrixStack, string.func_241878_f(), (float)(this.guiLeft + 15), (float)height, TextFormatting.BLACK.func_211163_e().intValue());
    }

    public void drawLeft(MatrixStack matrixStack, IFormattableTextComponent string, int height) {
        this.field_230712_o_.func_238422_b_(matrixStack, string.func_241878_f(), (float)(this.guiLeft + 7), (float)height, TextFormatting.BLACK.func_211163_e().intValue());
    }

    public void drawRight(MatrixStack matrixStack, IFormattableTextComponent string, int height) {
        this.drawRight(matrixStack, string, height, 1.0f);
    }

    public void drawRight(MatrixStack matrixStack, IFormattableTextComponent string, int height, float scale) {
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(scale, scale, 1.0f);
        float f = 1.0f / scale;
        int strWidth = this.field_230712_o_.func_238414_a_((ITextProperties)string);
        this.field_230712_o_.getClass();
        this.field_230712_o_.getClass();
        float spacing = (9.0f * f - 9.0f) / 2.0f;
        this.field_230712_o_.func_238422_b_(matrixStack, string.func_241878_f(), ((float)(this.guiLeft + 163) - (float)strWidth * scale - 14.0f) * f, (float)height * f + spacing, TextFormatting.BLACK.func_211163_e().intValue());
        matrixStack.func_227865_b_();
    }

    protected void func_230457_a_(MatrixStack matrixStack, ItemStack stack, int x, int y) {
        super.func_230457_a_(matrixStack, stack, x, y);
    }

    public FontRenderer getFontRenderer() {
        return this.field_230712_o_;
    }

    public int getGuiLeft() {
        return this.guiLeft;
    }

    public int getGuiTop() {
        return this.guiTop;
    }
}

