/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelEvent;

public enum SpecialModels {
    ASSAULT_RIFLE("gun/assault_rifle"),
    BAZOOKA("gun/bazooka"),
    HEAVY_RIFLE("gun/heavy_rifle"),
    MACHINE_PISTOL("gun/machine_pistol"),
    PISTOL("gun/pistol"),
    RIFLE("gun/rifle"),
    SHOTGUN("gun/shotgun"),
    FLAME("flame"),
    MINI_GUN_BASE("mini_gun_base"),
    MINI_GUN_BARRELS("mini_gun_barrels"),
    GRENADE_LAUNCHER_BASE("grenade_launcher_base"),
    GRENADE_LAUNCHER_CYLINDER("grenade_launcher_cylinder");

    private ResourceLocation modelLocation;
    private boolean specialModel;
    @OnlyIn(value=Dist.CLIENT)
    private BakedModel cachedModel;

    private SpecialModels(String modelName) {
        this(new ResourceLocation("cgm", "special/" + modelName), true);
    }

    private SpecialModels(ResourceLocation resource, boolean specialModel) {
        this.modelLocation = resource;
        this.specialModel = specialModel;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BakedModel getModel() {
        if (this.cachedModel == null) {
            BakedModel model = Minecraft.m_91087_().m_91304_().getModel(this.modelLocation);
            if (model == Minecraft.m_91087_().m_91304_().m_119409_()) {
                return model;
            }
            this.cachedModel = model;
        }
        return this.cachedModel;
    }

    public static void registerAdditional(ModelEvent.RegisterAdditional event) {
        for (SpecialModels model : SpecialModels.values()) {
            if (!model.specialModel) continue;
            event.register(model.modelLocation);
        }
    }

    public static void clearCache() {
        for (SpecialModels model : SpecialModels.values()) {
            if (!model.specialModel) continue;
            model.cachedModel = null;
        }
    }
}

