/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.network.message;

import com.mrcrayfish.framework.api.network.PlayMessage;
import com.mrcrayfish.guns.client.network.ClientPlayHandler;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class MessageProjectileHitBlock
extends PlayMessage<MessageProjectileHitBlock> {
    private double x;
    private double y;
    private double z;
    private BlockPos pos;
    private Direction face;

    public MessageProjectileHitBlock() {
    }

    public MessageProjectileHitBlock(double x, double y, double z, BlockPos pos, Direction face) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.pos = pos;
        this.face = face;
    }

    public void encode(MessageProjectileHitBlock message, FriendlyByteBuf buffer) {
        buffer.writeDouble(message.x);
        buffer.writeDouble(message.y);
        buffer.writeDouble(message.z);
        buffer.m_130064_(message.pos);
        buffer.m_130068_((Enum)message.face);
    }

    public MessageProjectileHitBlock decode(FriendlyByteBuf buffer) {
        double x = buffer.readDouble();
        double y = buffer.readDouble();
        double z = buffer.readDouble();
        BlockPos pos = buffer.m_130135_();
        Direction face = (Direction)buffer.m_130066_(Direction.class);
        return new MessageProjectileHitBlock(x, y, z, pos, face);
    }

    public void handle(MessageProjectileHitBlock message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> ClientPlayHandler.handleProjectileHitBlock(message));
        supplier.get().setPacketHandled(true);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Direction getFace() {
        return this.face;
    }
}

