/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.network.message;

import com.mrcrayfish.framework.api.network.PlayMessage;
import com.mrcrayfish.guns.common.network.ServerPlayHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class MessageShoot
extends PlayMessage<MessageShoot> {
    private float rotationYaw;
    private float rotationPitch;

    public MessageShoot() {
    }

    public MessageShoot(Player player) {
        this.rotationYaw = player.m_146908_();
        this.rotationPitch = player.m_146909_();
    }

    public MessageShoot(float rotationYaw, float rotationPitch) {
        this.rotationYaw = rotationYaw;
        this.rotationPitch = rotationPitch;
    }

    public void encode(MessageShoot message, FriendlyByteBuf buffer) {
        buffer.writeFloat(message.rotationYaw);
        buffer.writeFloat(message.rotationPitch);
    }

    public MessageShoot decode(FriendlyByteBuf buffer) {
        float rotationYaw = buffer.readFloat();
        float rotationPitch = buffer.readFloat();
        return new MessageShoot(rotationYaw, rotationPitch);
    }

    public void handle(MessageShoot message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null) {
                ServerPlayHandler.handleShoot(message, player);
            }
        });
        supplier.get().setPacketHandled(true);
    }

    public float getRotationYaw() {
        return this.rotationYaw;
    }

    public float getRotationPitch() {
        return this.rotationPitch;
    }
}

