/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.init;

import com.mrcrayfish.guns.entity.GrenadeEntity;
import com.mrcrayfish.guns.entity.MissileEntity;
import com.mrcrayfish.guns.entity.ProjectileEntity;
import com.mrcrayfish.guns.entity.ThrowableGrenadeEntity;
import com.mrcrayfish.guns.entity.ThrowableStunGrenadeEntity;
import java.util.function.BiFunction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"cgm");
    public static final RegistryObject<EntityType<ProjectileEntity>> PROJECTILE = ModEntities.registerProjectile("projectile", ProjectileEntity::new);
    public static final RegistryObject<EntityType<GrenadeEntity>> GRENADE = ModEntities.registerBasic("grenade", GrenadeEntity::new);
    public static final RegistryObject<EntityType<MissileEntity>> MISSILE = ModEntities.registerBasic("missile", MissileEntity::new);
    public static final RegistryObject<EntityType<ThrowableGrenadeEntity>> THROWABLE_GRENADE = ModEntities.registerBasic("throwable_grenade", ThrowableGrenadeEntity::new);
    public static final RegistryObject<EntityType<ThrowableStunGrenadeEntity>> THROWABLE_STUN_GRENADE = ModEntities.registerBasic("throwable_stun_grenade", ThrowableStunGrenadeEntity::new);

    private static <T extends Entity> RegistryObject<EntityType<T>> registerBasic(String id, BiFunction<EntityType<T>, Level, T> function) {
        return REGISTER.register(id, () -> EntityType.Builder.m_20704_(function::apply, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).setTrackingRange(100).setUpdateInterval(1).m_20698_().m_20719_().setShouldReceiveVelocityUpdates(true).m_20712_(id));
    }

    private static <T extends ProjectileEntity> RegistryObject<EntityType<T>> registerProjectile(String id, BiFunction<EntityType<T>, Level, T> function) {
        return REGISTER.register(id, () -> EntityType.Builder.m_20704_(function::apply, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).setTrackingRange(0).m_20698_().m_20719_().setShouldReceiveVelocityUpdates(false).setCustomClientFactory((spawnEntity, world) -> null).m_20712_(id));
    }
}

