/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.api.network;

import com.mrcrayfish.framework.api.network.HandshakeMessage;
import com.mrcrayfish.framework.api.network.PlayMessage;
import com.mrcrayfish.framework.network.message.handshake.LoginIndexHolder;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.HandshakeHandler;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.commons.lang3.tuple.Pair;

public class FrameworkChannelBuilder {
    private final ResourceLocation id;
    private final int version;
    private boolean requiresClient = true;
    private boolean requiresServer = true;
    private final AtomicInteger idCount = new AtomicInteger(1);
    private final List<Consumer<SimpleChannel>> playMessages = new ArrayList<Consumer<SimpleChannel>>();
    private final List<Consumer<SimpleChannel>> handshakeMessages = new ArrayList<Consumer<SimpleChannel>>();

    private FrameworkChannelBuilder(ResourceLocation id, int version) {
        this.id = id;
        this.version = version;
    }

    public FrameworkChannelBuilder ignoreClient() {
        this.requiresClient = false;
        return this;
    }

    public FrameworkChannelBuilder ignoreServer() {
        this.requiresServer = false;
        return this;
    }

    public <MSG extends PlayMessage<MSG>> FrameworkChannelBuilder registerPlayMessage(Class<MSG> messageClass) {
        return this.registerPlayMessage(messageClass, null);
    }

    public <MSG extends PlayMessage<MSG>> FrameworkChannelBuilder registerPlayMessage(Class<MSG> messageClass, @Nullable NetworkDirection direction) {
        try {
            Constructor<MSG> constructor = messageClass.getDeclaredConstructor(new Class[0]);
            PlayMessage message = (PlayMessage)constructor.newInstance(new Object[0]);
            this.playMessages.add(channel -> channel.registerMessage(this.idCount.getAndIncrement(), messageClass, message::encode, message::decode, message::handle, Optional.ofNullable(direction)));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("The message %s is missing an empty parameter constructor", messageClass.getName()), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(String.format("Unable to access the constructor of %s. Make sure the constructor is public.", messageClass.getName()), e);
        }
        catch (InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return this;
    }

    public <MSG extends HandshakeMessage<MSG>> FrameworkChannelBuilder registerHandshakeMessage(Class<MSG> messageClass) {
        return this.registerHandshakeMessage(messageClass, null);
    }

    public <MSG extends HandshakeMessage<MSG>> FrameworkChannelBuilder registerHandshakeMessage(Class<MSG> messageClass, @Nullable Function<Boolean, List<Pair<String, MSG>>> messages) {
        try {
            Constructor<MSG> constructor = messageClass.getDeclaredConstructor(new Class[0]);
            HandshakeMessage message = (HandshakeMessage)constructor.newInstance(new Object[0]);
            this.handshakeMessages.add(channel -> {
                SimpleChannel.MessageBuilder builder = channel.messageBuilder(messageClass, this.idCount.getAndIncrement());
                builder.loginIndex(LoginIndexHolder::getLoginIndex, LoginIndexHolder::setLoginIndex);
                builder.encoder(message::encode);
                builder.decoder(message::decode);
                builder.consumerNetworkThread(message::handle);
                if (messages != null) {
                    builder.buildLoginPacketList(messages);
                } else {
                    builder.markAsLoginPacket();
                }
                builder.add();
            });
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("The message %s is missing an empty parameter constructor", messageClass.getName()), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(String.format("Unable to access the constructor of %s. Make sure the constructor is public.", messageClass.getName()), e);
        }
        catch (InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return this;
    }

    private void registerAckMessage(SimpleChannel channel) {
        HandshakeMessage.Acknowledge acknowledge = new HandshakeMessage.Acknowledge();
        channel.messageBuilder(HandshakeMessage.Acknowledge.class, this.idCount.getAndIncrement()).loginIndex(LoginIndexHolder::getLoginIndex, LoginIndexHolder::setLoginIndex).decoder(acknowledge::decode).encoder(acknowledge::encode).consumerNetworkThread(HandshakeHandler.indexFirst((handler, msg, s) -> acknowledge.handle((HandshakeMessage.Acknowledge)msg, (Supplier<NetworkEvent.Context>)s))).add();
    }

    public SimpleChannel build() {
        this.idCount.set(1);
        boolean ignoreClient = !this.requiresClient;
        boolean ignoreServer = !this.requiresServer;
        String protocolVersion = Integer.toString(this.version);
        SimpleChannel channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)this.id).networkProtocolVersion(() -> protocolVersion).clientAcceptedVersions(s -> ignoreServer || protocolVersion.equals(s)).serverAcceptedVersions(s -> ignoreClient || protocolVersion.equals(s)).simpleChannel();
        this.playMessages.forEach(consumer -> consumer.accept(channel));
        if (this.handshakeMessages.size() > 0) {
            this.registerAckMessage(channel);
        }
        this.handshakeMessages.forEach(consumer -> consumer.accept(channel));
        return channel;
    }

    public static FrameworkChannelBuilder create(ResourceLocation id, int version) {
        return new FrameworkChannelBuilder(id, version);
    }

    public static FrameworkChannelBuilder create(String modId, String channelName, int version) {
        return new FrameworkChannelBuilder(new ResourceLocation(modId, channelName), version);
    }
}

