/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.client.model.geometry;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mrcrayfish.framework.api.serialize.DataObject;
import com.mrcrayfish.framework.client.model.BakedOpenModel;
import com.mrcrayfish.framework.util.GsonUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementRotation;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Vector3f;

public class OpenModelGeometry
implements IUnbakedGeometry<OpenModelGeometry> {
    private final BlockModel model;
    private final DataObject data;

    public OpenModelGeometry(BlockModel model, @Nullable DataObject data) {
        this.model = model;
        this.data = data;
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        return new BakedOpenModel(this.model.m_111449_(baker, this.model, spriteGetter, modelState, modelLocation, true), this.data);
    }

    public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
        this.model.m_5500_(modelGetter);
    }

    public static class Deserializer
    extends BlockModel.Deserializer {
        private static final BlockElement.Deserializer BLOCK_PART_DESERIALIZER = new BlockElement.Deserializer();
        private static final Deserializer INSTANCE = new Deserializer();

        protected List<BlockElement> m_111506_(JsonDeserializationContext context, JsonObject object) {
            try {
                ArrayList<BlockElement> list = new ArrayList<BlockElement>();
                for (JsonElement element : GsonHelper.m_13832_((JsonObject)object, (String)"components", (JsonArray)new JsonArray())) {
                    list.add(this.readBlockElement(element, context));
                }
                return list;
            }
            catch (Exception e) {
                throw new JsonParseException((Throwable)e);
            }
        }

        private BlockElement readBlockElement(JsonElement element, JsonDeserializationContext context) throws Exception {
            JsonObject object = element.getAsJsonObject();
            Vector3f from = GsonUtils.getVector3f(object, "from");
            Vector3f to = GsonUtils.getVector3f(object, "to");
            JsonObject rotation = GsonHelper.m_13841_((JsonObject)object, (String)"rotation", (JsonObject)new JsonObject());
            float angle = GsonHelper.m_13820_((JsonObject)rotation, (String)"angle", (float)0.0f);
            JsonArray zero = new JsonArray();
            zero.add((Number)Float.valueOf(0.0f));
            zero.add((Number)Float.valueOf(0.0f));
            zero.add((Number)Float.valueOf(0.0f));
            object.add("from", (JsonElement)zero);
            object.add("to", (JsonElement)zero);
            rotation.addProperty("angle", (Number)Float.valueOf(0.0f));
            BlockElement e = BLOCK_PART_DESERIALIZER.deserialize(element, BlockElement.class, context);
            BlockElementRotation r = e.f_111311_ != null ? new BlockElementRotation(e.f_111311_.f_111378_(), e.f_111311_.f_111379_(), angle, e.f_111311_.f_111381_()) : null;
            return new BlockElement(from, to, e.f_111310_, r, e.f_111312_);
        }
    }

    @Mod.EventBusSubscriber(modid="framework", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class Loader
    implements IGeometryLoader<OpenModelGeometry> {
        public OpenModelGeometry read(JsonObject object, JsonDeserializationContext context) throws JsonParseException {
            return new OpenModelGeometry(Deserializer.INSTANCE.deserialize((JsonElement)object, (Type)((Object)BlockModel.class), context), DataObject.convert(object.get("data")));
        }

        @SubscribeEvent
        public static void onModelRegister(ModelEvent.RegisterGeometryLoaders event) {
            event.register("open_model", (IGeometryLoader)new Loader());
        }
    }
}

