/*
 * Decompiled with CFR 0.152.
 */
package sora.holdyerbreath.init;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="holdyerbreath")
public class ConfigHandler {
    @Config.Name(value="Better Diving")
    public static final BetterDivingConfig betterDiving = new BetterDivingConfig();
    @Config.RangeInt(min=1, max=64)
    @Config.Comment(value={"Bottle Stacksize"})
    public static int maxStackSize = 64;
    @Config.Comment(value={"Does the bottle get used up after use"})
    public static boolean usesBottleUp = false;
    @Config.RangeInt(min=1, max=10)
    @Config.Comment(value={"How many bubbles of air's are restored per use"})
    public static int restoredAirBubbles = 5;

    @Mod.EventBusSubscriber(modid="holdyerbreath")
    public static class ReloadConfig {
        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent event) {
            if (event.getModID().equals("holdyerbreath")) {
                ConfigManager.sync((String)"holdyerbreath", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class BetterDivingConfig {
        @Config.Comment(value={"Allow Better Diving Integration"})
        public boolean allowBetterDivingIntegration = true;
        @Config.RangeInt(min=1, max=100)
        @Config.Comment(value={"Better Diving Air Percentage"})
        public int betterDivingAirPercentage = 20;
    }
}

