/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.head;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Random;
import java.util.function.BooleanSupplier;
import me.ichun.mods.ichunutil.common.iChunUtil;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.BlazeModel;
import net.minecraft.client.renderer.entity.model.BoarModel;
import net.minecraft.client.renderer.entity.model.ChickenModel;
import net.minecraft.client.renderer.entity.model.CodModel;
import net.minecraft.client.renderer.entity.model.CreeperModel;
import net.minecraft.client.renderer.entity.model.DolphinModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.FoxModel;
import net.minecraft.client.renderer.entity.model.IllagerModel;
import net.minecraft.client.renderer.entity.model.IronGolemModel;
import net.minecraft.client.renderer.entity.model.OcelotModel;
import net.minecraft.client.renderer.entity.model.QuadrupedModel;
import net.minecraft.client.renderer.entity.model.SalmonModel;
import net.minecraft.client.renderer.entity.model.SilverfishModel;
import net.minecraft.client.renderer.entity.model.SlimeModel;
import net.minecraft.client.renderer.entity.model.SquidModel;
import net.minecraft.client.renderer.entity.model.StriderModel;
import net.minecraft.client.renderer.entity.model.VillagerModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HeadBase<E extends LivingEntity>
implements Cloneable {
    public static BooleanSupplier acidEyesBooleanSupplier = () -> false;
    public ModelRenderer[] headModel = null;
    public float[] headJoint = new float[3];
    public float[] eyeOffset = new float[]{0.0f, 0.25f, 0.25f};
    public float[] irisColour = new float[]{0.9f, 0.9f, 0.9f};
    public float[] pupilColour = new float[]{0.0f, 0.0f, 0.0f};
    public float halfInterpupillaryDistance = 0.125f;
    public float eyeScale = 0.75f;
    public boolean sideEyed = false;
    public boolean topEyed = false;
    public float headTop = 0.5f;
    public float headFront = 0.25f;
    public Random livingRand = new Random();
    public int[] acidTime;

    public HeadBase setHeadJoint(float jointX, float jointY, float jointZ) {
        this.headJoint = new float[]{jointX, jointY, jointZ};
        return this;
    }

    public HeadBase setEyeOffset(float offsetX, float offsetY, float offsetZ) {
        this.eyeOffset = new float[]{offsetX, offsetY, offsetZ};
        return this;
    }

    public HeadBase setHalfInterpupillaryDistance(float dist) {
        this.halfInterpupillaryDistance = dist;
        return this;
    }

    public HeadBase setEyeScale(float scale) {
        this.eyeScale = scale;
        return this;
    }

    public HeadBase setIrisColour(float r, float g, float b) {
        this.irisColour = new float[]{r, g, b};
        return this;
    }

    public HeadBase setPupilColour(float r, float g, float b) {
        this.pupilColour = new float[]{r, g, b};
        return this;
    }

    public HeadBase setSideEyed() {
        this.sideEyed = true;
        return this;
    }

    public HeadBase setTopEyed() {
        this.topEyed = true;
        return this;
    }

    public float[] getHeadJointOffset(E living, MatrixStack stack, float partialTick, int eye) {
        this.headJoint[0] = -(this.headModel[0].field_78800_c / 16.0f);
        this.headJoint[1] = -(this.headModel[0].field_78797_d / 16.0f);
        this.headJoint[2] = -(this.headModel[0].field_78798_e / 16.0f);
        return this.headJoint;
    }

    public float[] getEyeOffsetFromJoint(E living, MatrixStack stack, float partialTick, int eye) {
        return this.eyeOffset;
    }

    public int getEyeCount(E living) {
        return 2;
    }

    public float maxEyeSizeGrowth(E living, int eye) {
        return 0.0f;
    }

    public float getEyeSideOffset(E living, MatrixStack stack, float partialTick, int eye) {
        return eye == 0 ? this.halfInterpupillaryDistance : -this.halfInterpupillaryDistance;
    }

    public float getEyeScale(E living, MatrixStack stack, float partialTick, int eye) {
        return this.eyeScale;
    }

    public float getEyeRotation(E living, MatrixStack stack, float partialTick, int eye) {
        return this.sideEyed ? (eye % 2 == 0 ? 90.0f : -90.0f) : 0.0f;
    }

    public float getEyeTopRotation(E living, MatrixStack stack, float partialTick, int eye) {
        return this.topEyed ? -90.0f : 0.0f;
    }

    public float getPupilScale(E living, MatrixStack stack, float partialTick, int eye) {
        if (acidEyesBooleanSupplier.getAsBoolean() || (Integer)living.func_184212_Q().func_187225_a(LivingEntity.field_184633_f) > 0) {
            this.livingRand.setSeed(Math.abs(living.hashCode()) * 1000);
            int eyeCount = this.getEyeCount(living);
            if (this.acidTime == null || this.acidTime.length < eyeCount) {
                this.acidTime = new int[eyeCount];
            }
            for (int i = 0; i < eyeCount; ++i) {
                this.acidTime[i] = 20 + this.livingRand.nextInt(20);
            }
            return 0.3f + ((float)Math.sin(Math.toRadians(((float)((LivingEntity)living).field_70173_aa + partialTick) / (float)this.acidTime[eye] * 360.0f)) + 1.0f) / 2.0f;
        }
        return 1.0f + 0.35f * ((float)((LivingEntity)living).field_70725_aQ + partialTick) / 20.0f;
    }

    public float[] getIrisColours(E living, MatrixStack stack, float partialTick, int eye) {
        return this.irisColour;
    }

    public float[] getPupilColours(E living, MatrixStack stack, float partialTick, int eye) {
        return this.pupilColour;
    }

    public float getHeadTopOffsetFromJoint(E living, MatrixStack stack, float partialTick, int eye) {
        return this.headTop;
    }

    public float getHeadFrontOffsetFromJoint(E living, MatrixStack stack, float partialTick, int eye) {
        return this.headFront;
    }

    public float getHeadYaw(E living, MatrixStack stack, float partialTick, int eye) {
        return (float)Math.toDegrees(this.headModel[0].field_78796_g);
    }

    public float getHeadPitch(E living, MatrixStack stack, float partialTick, int eye) {
        return (float)Math.toDegrees(this.headModel[0].field_78795_f);
    }

    public float getHeadRoll(E living, MatrixStack stack, float partialTick, int eye) {
        return (float)Math.toDegrees(this.headModel[0].field_78808_h);
    }

    public boolean affectedByInvisibility(E living, int eye) {
        return true;
    }

    public boolean doesEyeGlow(E living, int eye) {
        return false;
    }

    public void preChildEntHeadRenderCalls(E living, MatrixStack stack, LivingRenderer<E, ?> render) {
        if (living.func_70631_g_()) {
            float modelScale = 0.0625f;
            EntityModel model = render.func_217764_d();
            if (model instanceof BipedModel) {
                stack.func_227862_a_(0.75f, 0.75f, 0.75f);
                stack.func_227861_a_(0.0, (double)(16.0f * modelScale), 0.0);
            } else if (model instanceof AgeableModel) {
                AgeableModel ageableModel = (AgeableModel)model;
                if (ageableModel.field_228221_a_) {
                    float f = 1.5f / ageableModel.field_228224_g_;
                    stack.func_227862_a_(f, f, f);
                }
                stack.func_227861_a_(0.0, (double)(ageableModel.field_228222_b_ * modelScale), (double)(ageableModel.field_228223_f_ * modelScale));
            }
        }
    }

    public void translateRotateToChild(MatrixStack stack, ModelRenderer renderer) {
        stack.func_227861_a_((double)(renderer.field_78800_c / 16.0f), (double)(renderer.field_78797_d / 16.0f), (double)(renderer.field_78798_e / 16.0f));
        stack.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_(renderer.field_78808_h));
        stack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(renderer.field_78796_g));
        stack.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_(renderer.field_78795_f));
    }

    public HeadBase<?> clone() {
        try {
            HeadBase clone = (HeadBase)super.clone();
            clone.headModel = null;
            clone.livingRand = new Random();
            for (int i = 0; i < 3; ++i) {
                clone.headJoint[i] = this.headJoint[i];
                clone.eyeOffset[i] = this.eyeOffset[i];
                clone.irisColour[i] = this.irisColour[i];
                clone.pupilColour[i] = this.pupilColour[i];
            }
            clone.halfInterpupillaryDistance = this.halfInterpupillaryDistance;
            clone.eyeScale = this.eyeScale;
            clone.sideEyed = this.sideEyed;
            clone.headTop = this.headTop;
            clone.headFront = this.headFront;
            return clone;
        }
        catch (Exception e) {
            iChunUtil.LOGGER.error("Error cloning class: {}", this.getClass());
            e.printStackTrace();
            return null;
        }
    }

    public void setHeadModel(LivingRenderer renderer) {
        boolean flag;
        boolean bl = flag = this.headModel == null;
        if (flag) {
            this.headModel = new ModelRenderer[1];
        }
        if (flag || iChunUtil.configClient.aggressiveHeadTracking == 1 || iChunUtil.configClient.aggressiveHeadTracking == 2 && renderer instanceof PlayerRenderer) {
            this.setHeadModelFromRenderer(renderer);
            for (ModelRenderer head : this.headModel) {
                if (head != null) continue;
                this.headModel = null;
                break;
            }
        }
    }

    protected void setHeadModelFromRenderer(LivingRenderer renderer) {
        EntityModel model = renderer.func_217764_d();
        if (model instanceof BipedModel) {
            this.headModel[0] = ((BipedModel)model).field_78116_c;
        } else if (model instanceof QuadrupedModel) {
            this.headModel[0] = ((QuadrupedModel)model).field_78150_a;
        } else if (model instanceof BoarModel) {
            this.headModel[0] = ((BoarModel)model).field_239106_a_;
        } else if (model instanceof BlazeModel) {
            this.headModel[0] = ((BlazeModel)model).field_78105_b;
        } else if (model instanceof ChickenModel) {
            this.headModel[0] = ((ChickenModel)model).field_78142_a;
        } else if (model instanceof CodModel) {
            this.headModel[0] = ((CodModel)model).field_203725_c;
        } else if (model instanceof CreeperModel) {
            this.headModel[0] = ((CreeperModel)model).field_78135_a;
        } else if (model instanceof DolphinModel) {
            this.headModel[0] = ((DolphinModel)model).field_205082_b;
        } else if (model instanceof FoxModel) {
            this.headModel[0] = ((FoxModel)model).field_217115_a;
        } else if (model instanceof IllagerModel) {
            this.headModel[0] = ((IllagerModel)model).field_191217_a;
        } else if (model instanceof IronGolemModel) {
            this.headModel[0] = ((IronGolemModel)model).field_78178_a;
        } else if (model instanceof OcelotModel) {
            this.headModel[0] = ((OcelotModel)model).field_78156_g;
        } else if (model instanceof SalmonModel) {
            this.headModel[0] = ((SalmonModel)model).field_203763_c;
        } else if (model instanceof SilverfishModel) {
            this.headModel[0] = ((SilverfishModel)model).field_78171_a[0];
        } else if (model instanceof SlimeModel) {
            this.headModel[0] = ((SlimeModel)model).field_78200_a;
        } else if (model instanceof SquidModel) {
            this.headModel[0] = ((SquidModel)model).field_78202_a;
        } else if (model instanceof StriderModel) {
            this.headModel[0] = ((StriderModel)model).field_239120_f_;
        } else if (model instanceof VillagerModel) {
            this.headModel[0] = ((VillagerModel)model).field_78191_a;
        }
    }
}

