/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.model.util;

import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.ichunutil.common.module.tabula.project.Identifiable;
import me.ichun.mods.ichunutil.common.module.tabula.project.Project;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;

public class ModelHelper {
    public static final HashMap<Class<?>, ModelRenderers> RENDERERS_FOR_CLASS = new HashMap();

    public static Project convertModelToProject(Object o) {
        Project project = new Project();
        project.parts.clear();
        project.name = o.getClass().getSimpleName();
        project.author = "Either Mojang or a mod author (Taken From Memory)";
        if (o instanceof Model) {
            project.texWidth = ((Model)o).field_78090_t;
            project.texHeight = ((Model)o).field_78089_u;
        }
        ModelRenderers renderers = ModelHelper.digForModelRenderers(o);
        HashMap done = new HashMap();
        renderers.fields.forEach((s, modelRenderer) -> ModelHelper.createPartFor(s, modelRenderer, done, project));
        renderers.arrays.forEach((s, modelRenderers) -> {
            for (int i = 0; i < ((ModelRenderer[])modelRenderers).length; ++i) {
                ModelHelper.createPartFor(s + "_" + i, modelRenderers[i], done, project);
            }
        });
        renderers.lists.forEach((s, modelRenderers) -> {
            for (int i = 0; i < modelRenderers.size(); ++i) {
                ModelHelper.createPartFor(s + "_" + i, (ModelRenderer)modelRenderers.get(i), done, project);
            }
        });
        renderers.fields.forEach((s, modelRenderer) -> {
            if (done.containsKey(modelRenderer)) {
                ((Identifiable)done.get((Object)modelRenderer)).name = s;
            }
        });
        project.partCountProjectLife = done.size();
        return project;
    }

    private static ModelRenderers digForModelRenderers(Object o) {
        if (RENDERERS_FOR_CLASS.containsKey(o.getClass())) {
            return RENDERERS_FOR_CLASS.get(o.getClass());
        }
        ModelRenderers renderers = new ModelRenderers();
        for (Class<?> clz = o.getClass(); clz != Model.class && clz != Object.class; clz = clz.getSuperclass()) {
            try {
                Field[] clzFields;
                for (Field f : clzFields = clz.getDeclaredFields()) {
                    ModelRenderer[] rend;
                    f.setAccessible(true);
                    if (ModelRenderer.class.isAssignableFrom(f.getType())) {
                        rend = (ModelRenderer[])f.get(o);
                        if (rend == null) continue;
                        renderers.fields.put(f.getName(), rend);
                        continue;
                    }
                    if (ModelRenderer[].class.isAssignableFrom(f.getType())) {
                        rend = (ModelRenderer[])f.get(o);
                        if (rend == null || rend.length <= 0) continue;
                        renderers.arrays.put(f.getName(), rend);
                        continue;
                    }
                    if (!(f.get(o) instanceof List)) continue;
                    List list = (List)f.get(o);
                    ArrayList<ModelRenderer> catches = new ArrayList<ModelRenderer>();
                    for (Object o1 : list) {
                        if (o1 instanceof ModelRenderer) {
                            catches.add((ModelRenderer)o1);
                            continue;
                        }
                        if (!(o1 instanceof ModelRenderer[])) continue;
                        Collections.addAll(catches, (ModelRenderer[])o1);
                    }
                    if (catches.isEmpty()) continue;
                    renderers.lists.put(f.getName(), catches);
                }
                continue;
            }
            catch (Exception e) {
                iChunUtil.LOGGER.error("Something went wrong parsing {}", (Object)o.getClass().getSimpleName());
            }
        }
        RENDERERS_FOR_CLASS.put(o.getClass(), renderers);
        return renderers;
    }

    public static ArrayList<ModelRenderer> createModelPartsFromProject(@Nonnull Project project) {
        ArrayList<ModelRenderer> models = new ArrayList<ModelRenderer>();
        project.parts.forEach(part -> ModelHelper.populateModel(models, part));
        return models;
    }

    private static void populateModel(Collection<? super ModelRenderer> parts, Project.Part part) {
        int[] dims = part.getProjectTextureDims();
        if (!part.matchProject) {
            dims[0] = part.texWidth;
            dims[1] = part.texHeight;
        }
        ModelRenderer modelPart = new ModelRenderer(dims[0], dims[1], part.texOffX, part.texOffY);
        modelPart.field_78800_c = part.rotPX;
        modelPart.field_78797_d = part.rotPY;
        modelPart.field_78798_e = part.rotPZ;
        modelPart.field_78795_f = (float)Math.toRadians(part.rotAX);
        modelPart.field_78796_g = (float)Math.toRadians(part.rotAY);
        modelPart.field_78808_h = (float)Math.toRadians(part.rotAZ);
        modelPart.field_78809_i = part.mirror;
        modelPart.field_78806_j = part.showModel;
        part.boxes.forEach(box -> {
            int texOffX = modelPart.field_78803_o;
            int texOffY = modelPart.field_78813_p;
            modelPart.func_78784_a(modelPart.field_78803_o + box.texOffX, modelPart.field_78813_p + box.texOffY);
            modelPart.func_228302_a_(box.posX, box.posY, box.posZ, box.dimX, box.dimY, box.dimZ, box.expandX, box.expandY, box.expandZ);
            modelPart.func_78784_a(texOffX, texOffY);
        });
        part.children.forEach(part1 -> ModelHelper.populateModel((Collection<? super ModelRenderer>)modelPart.field_78805_m, part1));
        parts.add((ModelRenderer)modelPart);
    }

    public static ArrayList<ModelRenderer> explode(ArrayList<ModelRenderer> parts) {
        ArrayList<ModelRenderer> models = new ArrayList<ModelRenderer>();
        parts.forEach(part -> ModelHelper.explodeRecursive(models, part));
        return models;
    }

    private static void explodeRecursive(ArrayList<ModelRenderer> parts, ModelRenderer part) {
        parts.add(part);
        ObjectListIterator iterator = part.field_78805_m.iterator();
        while (iterator.hasNext()) {
            ModelRenderer next = (ModelRenderer)iterator.next();
            iterator.remove();
            next.field_78800_c += part.field_78800_c;
            next.field_78797_d += part.field_78797_d;
            next.field_78798_e += part.field_78798_e;
            next.field_78795_f += part.field_78795_f;
            next.field_78796_g += part.field_78796_g;
            next.field_78808_h += part.field_78808_h;
            ModelHelper.explodeRecursive(parts, next);
        }
    }

    private static void createPartFor(String name, ModelRenderer renderer, HashMap<ModelRenderer, Identifiable<?>> done, Identifiable<?> parent) {
        if (done.containsKey(renderer)) {
            if (!(parent instanceof Project)) {
                Identifiable<?> identifiable = done.get(renderer);
                identifiable.parent.disown(identifiable);
                parent.adopt(identifiable);
            }
            return;
        }
        Project.Part part = new Project.Part(parent, done.size());
        part.boxes.clear();
        part.name = name;
        part.texWidth = (int)renderer.field_78801_a;
        part.texHeight = (int)renderer.field_78799_b;
        if (done.isEmpty() && parent instanceof Project) {
            ((Project)parent).texWidth = part.texWidth;
            ((Project)parent).texHeight = part.texHeight;
        }
        part.matchProject = false;
        part.texOffX = renderer.field_78803_o;
        part.texOffY = renderer.field_78813_p;
        part.rotPX = renderer.field_78800_c;
        part.rotPY = renderer.field_78797_d;
        part.rotPZ = renderer.field_78798_e;
        part.rotAX = (float)Math.toDegrees(renderer.field_78795_f);
        part.rotAY = (float)Math.toDegrees(renderer.field_78796_g);
        part.rotAZ = (float)Math.toDegrees(renderer.field_78808_h);
        part.mirror = renderer.field_78809_i;
        part.showModel = renderer.field_78806_j;
        if (!renderer.field_78804_l.isEmpty()) {
            Project.Part.Box projBox;
            int lowTexX = part.texWidth;
            int lowTexY = part.texHeight;
            for (ModelRenderer.ModelBox box : renderer.field_78804_l) {
                projBox = new Project.Part.Box(part);
                projBox.posX = box.field_78252_a;
                projBox.posY = box.field_78250_b;
                projBox.posZ = box.field_78251_c;
                projBox.dimX = Math.abs(box.field_78248_d - box.field_78252_a);
                projBox.dimY = Math.abs(box.field_78249_e - box.field_78250_b);
                projBox.dimZ = Math.abs(box.field_78246_f - box.field_78251_c);
                if (box.field_78254_i != null) {
                    boolean mirrored = box.field_78254_i[1].field_78239_a[3].field_78243_a.func_195900_b() < box.field_78254_i[1].field_78239_a[1].field_78243_a.func_195900_b() || box.field_78254_i[2].field_78239_a[0].field_78243_a.func_195902_c() < box.field_78254_i[2].field_78239_a[3].field_78243_a.func_195902_c();
                    projBox.expandX = (box.field_78254_i[2].field_78239_a[mirrored ? 2 : 3].field_78243_a.func_195899_a() - box.field_78254_i[2].field_78239_a[mirrored ? 3 : 2].field_78243_a.func_195899_a() - projBox.dimX) / 2.0f;
                    projBox.expandY = (box.field_78254_i[4].field_78239_a[mirrored ? 0 : 3].field_78243_a.func_195900_b() - box.field_78254_i[2].field_78239_a[mirrored ? 1 : 2].field_78243_a.func_195900_b() - projBox.dimY) / 2.0f;
                    projBox.expandZ = (box.field_78254_i[1].field_78239_a[mirrored ? 1 : 2].field_78243_a.func_195902_c() - box.field_78254_i[1].field_78239_a[mirrored ? 0 : 3].field_78243_a.func_195902_c() - projBox.dimZ) / 2.0f;
                    int texOffX = (int)(box.field_78254_i[1].field_78239_a[mirrored ? 2 : 1].field_78241_b * renderer.field_78801_a);
                    int texOffY = (int)(Math.min(box.field_78254_i[2].field_78239_a[1].field_78242_c, box.field_78254_i[2].field_78239_a[2].field_78242_c) * renderer.field_78799_b);
                    if (texOffX < lowTexX) {
                        lowTexX = texOffX;
                    }
                    if (texOffY < lowTexY) {
                        lowTexY = texOffY;
                    }
                    projBox.texOffX = texOffX;
                    projBox.texOffY = texOffY;
                }
                part.boxes.add(projBox);
            }
            part.texOffX = lowTexX;
            part.texOffY = lowTexY;
            for (int i = renderer.field_78804_l.size() - 1; i >= 0; --i) {
                ModelRenderer.ModelBox box;
                box = (ModelRenderer.ModelBox)renderer.field_78804_l.get(i);
                projBox = part.boxes.get(i);
                projBox.texOffX -= lowTexX;
                projBox.texOffY -= lowTexY;
                if (i != 0) continue;
                part.mirror = box.field_78254_i[1].field_78239_a[3].field_78243_a.func_195900_b() < box.field_78254_i[1].field_78239_a[1].field_78243_a.func_195900_b();
            }
        }
        ObjectList childModels = renderer.field_78805_m;
        for (int i = 0; i < childModels.size(); ++i) {
            ModelRenderer childModel = (ModelRenderer)childModels.get(i);
            ModelHelper.createPartFor(name + "_" + i, childModel, done, part);
        }
        if (parent instanceof Project) {
            ((Project)parent).parts.add(part);
        } else if (parent instanceof Project.Part) {
            ((Project.Part)parent).children.add(part);
        }
        done.put(renderer, part);
    }

    private static class ModelRenderers {
        private final HashMap<String, ModelRenderer> fields = new HashMap();
        private final HashMap<String, ModelRenderer[]> arrays = new HashMap();
        private final HashMap<String, ArrayList<ModelRenderer>> lists = new HashMap();

        private ModelRenderers() {
        }
    }
}

