/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.tracker;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import me.ichun.mods.ichunutil.client.tracker.entity.EntityTracker;
import me.ichun.mods.ichunutil.client.tracker.render.RenderTracker;
import me.ichun.mods.ichunutil.common.iChunUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@OnlyIn(value=Dist.CLIENT)
public final class ClientEntityTracker {
    private static boolean hasInit;
    private static final AtomicInteger NEXT_ENTITY_ID;
    private static final IdentityHashMap<Entity, EntityTracker> TRACKERS;

    public static void init(IEventBus bus) {
        if (!hasInit) {
            hasInit = true;
            bus.addGenericListener(EntityType.class, EntityTypes::onEntityTypeRegistry);
            bus.addListener(ClientEntityTracker::onClientSetup);
            MinecraftForge.EVENT_BUS.addListener(ClientEntityTracker::onWorldTick);
            MinecraftForge.EVENT_BUS.addListener(ClientEntityTracker::onWorldUnload);
        }
    }

    private static void onClientSetup(FMLClientSetupEvent event) {
        iChunUtil.LOGGER.info("That was an intended override. Nothing to worry about. No broken mod here. Not a Dangerous alternative prefix at all. Nope. Nossirree.");
        RenderingRegistry.registerEntityRenderingHandler(EntityTypes.TRACKER, (IRenderFactory)new RenderTracker.RenderFactory());
    }

    public static int getNextEntId() {
        return NEXT_ENTITY_ID.getAndDecrement();
    }

    public static EntityTracker getOrCreate(Entity ent) {
        EntityTracker tracker = null;
        for (Map.Entry<Entity, EntityTracker> e : TRACKERS.entrySet()) {
            if (e.getKey() != ent) continue;
            tracker = e.getValue();
            break;
        }
        if (tracker == null) {
            tracker = new EntityTracker(EntityTypes.TRACKER, ent.field_70170_p);
            TRACKERS.put(ent, tracker);
        }
        if (!tracker.func_70089_S()) {
            tracker = new EntityTracker(EntityTypes.TRACKER, ent.field_70170_p);
            TRACKERS.put(ent, tracker);
        }
        tracker.setParent(ent);
        if (!tracker.isAddedToWorld()) {
            tracker.func_145769_d(ClientEntityTracker.getNextEntId());
            tracker.func_70012_b(ent.func_226277_ct_(), ent.func_226278_cu_(), ent.func_226281_cx_(), ent.field_70177_z, ent.field_70125_A);
            ((ClientWorld)ent.field_70170_p).func_217411_a(tracker.func_145782_y(), (Entity)tracker);
        }
        return tracker;
    }

    private static void onWorldTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && Minecraft.func_71410_x().field_71439_g != null && !Minecraft.func_71410_x().func_147113_T()) {
            EntityTracker playerTracker = null;
            Iterator<Map.Entry<Entity, EntityTracker>> ite = TRACKERS.entrySet().iterator();
            while (ite.hasNext()) {
                Map.Entry<Entity, EntityTracker> e = ite.next();
                EntityTracker tracker = e.getValue();
                if (tracker.func_70089_S() && Minecraft.func_71410_x().field_71439_g.field_70173_aa - tracker.lastUpdate <= 10) continue;
                if (e.getKey() == Minecraft.func_71410_x().field_71439_g && tracker.lastUpdate == -1) {
                    playerTracker = tracker;
                }
                ite.remove();
            }
            if (playerTracker != null) {
                EntityTracker tracker = ClientEntityTracker.getOrCreate(playerTracker.parent);
                tracker.field_184236_aF = playerTracker.field_184236_aF;
                tracker.updateBounds();
            }
        }
    }

    private static void onWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld().func_201670_d()) {
            Iterator<Map.Entry<Entity, EntityTracker>> ite = TRACKERS.entrySet().iterator();
            while (ite.hasNext()) {
                Map.Entry<Entity, EntityTracker> e = ite.next();
                EntityTracker tracker = e.getValue();
                if (tracker.parent.func_130014_f_() != event.getWorld()) continue;
                ite.remove();
            }
        }
    }

    static {
        NEXT_ENTITY_ID = new AtomicInteger(-70000000);
        TRACKERS = new IdentityHashMap();
    }

    private static class EntityTypes {
        public static EntityType<EntityTracker> TRACKER;

        private EntityTypes() {
        }

        public static void onEntityTypeRegistry(RegistryEvent.Register<EntityType<?>> entityTypeRegistryEvent) {
            TRACKER = EntityType.Builder.func_220322_a(EntityTracker::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.1f, 0.1f).func_200706_c().func_200705_b().func_220320_c().func_206830_a("from iChunUtil. Ignore this.");
        }
    }
}

