/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api;

import blusunrize.immersiveengineering.common.blocks.EnumMetals;
import blusunrize.immersiveengineering.common.data.DataGenUtils;
import blusunrize.immersiveengineering.common.data.IEDataGenerator;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;

public class IETags {
    private static final Map<ITag.INamedTag<Block>, ITag.INamedTag<Item>> toItemTag = new HashMap<ITag.INamedTag<Block>, ITag.INamedTag<Item>>();
    private static final Map<EnumMetals, MetalTags> metals = new HashMap<EnumMetals, MetalTags>();
    public static final ITag.INamedTag<Item> clay = DataGenUtils.createItemWrapper(IETags.forgeLoc("clay"));
    public static final ITag.INamedTag<Block> clayBlock = IETags.createBlockTag(IETags.getStorageBlock("clay"));
    public static final ITag.INamedTag<Item> charCoal = DataGenUtils.createItemWrapper(IETags.forgeLoc("charcoal"));
    public static final ITag.INamedTag<Block> glowstoneBlock = IETags.createBlockTag(IETags.getStorageBlock("glowstone"));
    public static final ITag.INamedTag<Block> treatedWood = IETags.createBlockTag(IETags.forgeLoc("treated_wood"));
    public static final ITag.INamedTag<Block> treatedWoodSlab = IETags.createBlockTag(IETags.forgeLoc("treated_wood_slab"));
    public static final ITag.INamedTag<Block> coalCokeBlock = IETags.createBlockTag(IETags.getStorageBlock("coal_coke"));
    public static final ITag.INamedTag<Block> scaffoldingSteel = IETags.createBlockTag(IEDataGenerator.rl("scaffoldings/steel"));
    public static final ITag.INamedTag<Block> scaffoldingAlu = IETags.createBlockTag(IEDataGenerator.rl("scaffoldings/aluminum"));
    public static final ITag.INamedTag<Block> sheetmetals = IETags.createBlockTag(IETags.forgeLoc("sheetmetals"));
    public static final ITag.INamedTag<Item> treatedStick = DataGenUtils.createItemWrapper(IETags.getRod("treated_wood"));
    public static final ITag.INamedTag<Item> ironRod = DataGenUtils.createItemWrapper(IETags.getRod("iron"));
    public static final ITag.INamedTag<Item> steelRod = DataGenUtils.createItemWrapper(IETags.getRod("steel"));
    public static final ITag.INamedTag<Item> metalRods = DataGenUtils.createItemWrapper(IETags.getRod("all_metal"));
    public static final ITag.INamedTag<Item> aluminumRod = DataGenUtils.createItemWrapper(IETags.getRod("aluminum"));
    public static final ITag.INamedTag<Item> fiberHemp = DataGenUtils.createItemWrapper(IETags.forgeLoc("fiber_hemp"));
    public static final ITag.INamedTag<Item> fabricHemp = DataGenUtils.createItemWrapper(IETags.forgeLoc("fabric_hemp"));
    public static final ITag.INamedTag<Item> coalCoke = DataGenUtils.createItemWrapper(IETags.forgeLoc("coal_coke"));
    public static final ITag.INamedTag<Item> slag = DataGenUtils.createItemWrapper(IETags.forgeLoc("slag"));
    public static final ITag.INamedTag<Item> coalCokeDust = DataGenUtils.createItemWrapper(IETags.getDust("coal_coke"));
    public static final ITag.INamedTag<Item> hopGraphiteDust = DataGenUtils.createItemWrapper(IETags.getDust("hop_graphite"));
    public static final ITag.INamedTag<Item> hopGraphiteIngot = DataGenUtils.createItemWrapper(IETags.getIngot("hop_graphite"));
    public static final ITag.INamedTag<Item> copperWire = DataGenUtils.createItemWrapper(IETags.getWire("copper"));
    public static final ITag.INamedTag<Item> electrumWire = DataGenUtils.createItemWrapper(IETags.getWire("electrum"));
    public static final ITag.INamedTag<Item> aluminumWire = DataGenUtils.createItemWrapper(IETags.getWire("aluminum"));
    public static final ITag.INamedTag<Item> steelWire = DataGenUtils.createItemWrapper(IETags.getWire("steel"));
    public static final ITag.INamedTag<Item> saltpeterDust = DataGenUtils.createItemWrapper(IETags.getDust("saltpeter"));
    public static final ITag.INamedTag<Item> sulfurDust = DataGenUtils.createItemWrapper(IETags.getDust("sulfur"));
    public static final ITag.INamedTag<Item> plates = DataGenUtils.createItemWrapper(IETags.forgeLoc("plates"));
    public static final ITag.INamedTag<Fluid> fluidCreosote = DataGenUtils.createFluidWrapper(IETags.forgeLoc("creosote"));
    public static final ITag.INamedTag<Fluid> fluidPlantoil = DataGenUtils.createFluidWrapper(IETags.forgeLoc("plantoil"));
    public static final ITag.INamedTag<Fluid> fluidEthanol = DataGenUtils.createFluidWrapper(IETags.forgeLoc("ethanol"));
    public static final ITag.INamedTag<Fluid> fluidBiodiesel = DataGenUtils.createFluidWrapper(IETags.forgeLoc("biodiesel"));
    public static final ITag.INamedTag<Fluid> fluidConcrete = DataGenUtils.createFluidWrapper(IETags.forgeLoc("concrete"));
    public static final ITag.INamedTag<Fluid> fluidHerbicide = DataGenUtils.createFluidWrapper(IETags.forgeLoc("herbicide"));
    public static final ITag.INamedTag<Fluid> fluidPotion = DataGenUtils.createFluidWrapper(IETags.forgeLoc("potion"));

    public static ITag.INamedTag<Item> getItemTag(ITag.INamedTag<Block> blockTag) {
        Preconditions.checkArgument((boolean)toItemTag.containsKey(blockTag));
        return toItemTag.get(blockTag);
    }

    public static MetalTags getTagsFor(EnumMetals metal) {
        return metals.get((Object)metal);
    }

    private static ITag.INamedTag<Block> createBlockTag(ResourceLocation name) {
        ITag.INamedTag<Block> blockTag = DataGenUtils.createBlockWrapper(name);
        toItemTag.put(blockTag, DataGenUtils.createItemWrapper(name));
        return blockTag;
    }

    public static void forAllBlocktags(BiConsumer<ITag.INamedTag<Block>, ITag.INamedTag<Item>> out) {
        for (Map.Entry<ITag.INamedTag<Block>, ITag.INamedTag<Item>> entry : toItemTag.entrySet()) {
            out.accept(entry.getKey(), entry.getValue());
        }
    }

    private static ResourceLocation forgeLoc(String path) {
        return new ResourceLocation("forge", path);
    }

    public static ResourceLocation getOre(String type) {
        return IETags.forgeLoc("ores/" + type);
    }

    public static ResourceLocation getNugget(String type) {
        return IETags.forgeLoc("nuggets/" + type);
    }

    public static ResourceLocation getIngot(String type) {
        return IETags.forgeLoc("ingots/" + type);
    }

    public static ResourceLocation getGem(String type) {
        return IETags.forgeLoc("gems/" + type);
    }

    public static ResourceLocation getStorageBlock(String type) {
        return IETags.forgeLoc("storage_blocks/" + type);
    }

    public static ResourceLocation getDust(String type) {
        return IETags.forgeLoc("dusts/" + type);
    }

    public static ResourceLocation getPlate(String type) {
        return IETags.forgeLoc("plates/" + type);
    }

    public static ResourceLocation getRod(String type) {
        return IETags.forgeLoc("rods/" + type);
    }

    public static ResourceLocation getGear(String type) {
        return IETags.forgeLoc("gears/" + type);
    }

    public static ResourceLocation getWire(String type) {
        return IETags.forgeLoc("wires/" + type);
    }

    public static ResourceLocation getSheetmetalBlock(String type) {
        return IETags.forgeLoc("sheetmetals/" + type);
    }

    static {
        for (EnumMetals m : EnumMetals.values()) {
            metals.put(m, new MetalTags(m));
        }
    }

    public static class MetalTags {
        public final ITag.INamedTag<Item> ingot;
        public final ITag.INamedTag<Item> nugget;
        public final ITag.INamedTag<Item> plate;
        public final ITag.INamedTag<Item> dust;
        public final ITag.INamedTag<Block> storage;
        public final ITag.INamedTag<Block> sheetmetal;
        @Nullable
        public final ITag.INamedTag<Block> ore;

        private MetalTags(EnumMetals m) {
            String name = m.tagName();
            ITag.INamedTag ore = null;
            if (m.shouldAddOre()) {
                ore = IETags.createBlockTag(IETags.getOre(name));
            }
            if (!m.isVanillaMetal()) {
                this.storage = IETags.createBlockTag(IETags.getStorageBlock(name));
            } else if (m == EnumMetals.IRON) {
                this.storage = Tags.Blocks.STORAGE_BLOCKS_IRON;
                ore = Tags.Blocks.ORES_IRON;
            } else if (m == EnumMetals.GOLD) {
                this.storage = Tags.Blocks.STORAGE_BLOCKS_GOLD;
                ore = Tags.Blocks.ORES_GOLD;
            } else {
                throw new RuntimeException("Unkown vanilla metal: " + m.name());
            }
            this.sheetmetal = IETags.createBlockTag(IETags.getSheetmetalBlock(name));
            this.nugget = DataGenUtils.createItemWrapper(IETags.getNugget(name));
            this.ingot = DataGenUtils.createItemWrapper(IETags.getIngot(name));
            this.plate = DataGenUtils.createItemWrapper(IETags.getPlate(name));
            this.dust = DataGenUtils.createItemWrapper(IETags.getDust(name));
            this.ore = ore;
        }
    }
}

