/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.utils.ItemUtils;
import blusunrize.immersiveengineering.common.items.IEItems;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.ListUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlueprintCraftingRecipe
extends MultiblockRecipe {
    public static IRecipeType<BlueprintCraftingRecipe> TYPE = IRecipeType.func_222147_a((String)"immersiveengineering:blueprint");
    public static RegistryObject<IERecipeSerializer<BlueprintCraftingRecipe>> SERIALIZER;
    @Nonnull
    public static Set<String> recipeCategories;
    public static Map<ResourceLocation, BlueprintCraftingRecipe> recipeList;
    private static Map<String, List<BlueprintCraftingRecipe>> recipesByCategory;
    public String blueprintCategory;
    public ItemStack output;
    public IngredientWithSize[] inputs;

    public BlueprintCraftingRecipe(ResourceLocation id, String blueprintCategory, ItemStack output, IngredientWithSize[] inputs) {
        super(output, TYPE, id);
        this.blueprintCategory = blueprintCategory;
        this.output = output;
        this.inputs = inputs;
        this.setInputListWithSizes(Lists.newArrayList((Object[])this.inputs));
        this.outputList = ListUtils.fromItem(this.output);
        this.totalProcessEnergy = 23040;
        this.totalProcessTime = 180;
    }

    @Override
    protected IERecipeSerializer<BlueprintCraftingRecipe> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public static ItemStack getTypedBlueprint(String type) {
        ItemStack stack = new ItemStack((IItemProvider)IEItems.Misc.blueprint);
        ItemNBTHelper.putString(stack, "blueprint", type);
        return stack;
    }

    public boolean matchesRecipe(NonNullList<ItemStack> query) {
        return this.getMaxCrafted(query) > 0;
    }

    public int getMaxCrafted(NonNullList<ItemStack> query) {
        HashMap<ItemStack, Integer> queryAmount = new HashMap<ItemStack, Integer>();
        for (ItemStack q : query) {
            if (q.func_190926_b()) continue;
            boolean inc = false;
            for (ItemStack key : queryAmount.keySet()) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)q, (ItemStack)key)) continue;
                queryAmount.put(key, (Integer)queryAmount.get(key) + q.func_190916_E());
                inc = true;
            }
            if (inc) continue;
            queryAmount.put(q, q.func_190916_E());
        }
        OptionalInt maxCrafted = OptionalInt.empty();
        for (IngredientWithSize ingr : this.inputs) {
            int maxCraftedWithIngredient = 0;
            int req = ingr.getCount();
            Iterator queryIt = queryAmount.entrySet().iterator();
            while (queryIt.hasNext()) {
                int taken;
                Map.Entry e = queryIt.next();
                ItemStack compStack = (ItemStack)e.getKey();
                if (!ingr.test(compStack) || (taken = (Integer)e.getValue() / req) <= 0) continue;
                e.setValue((Integer)e.getValue() - taken * req);
                if ((Integer)e.getValue() <= 0) {
                    queryIt.remove();
                }
                maxCraftedWithIngredient += taken;
            }
            if (maxCraftedWithIngredient <= 0) {
                return 0;
            }
            maxCrafted = maxCrafted.isPresent() ? OptionalInt.of(Math.min(maxCrafted.getAsInt(), maxCraftedWithIngredient)) : OptionalInt.of(maxCraftedWithIngredient);
        }
        return maxCrafted.orElse(0);
    }

    public NonNullList<ItemStack> consumeInputs(NonNullList<ItemStack> query, int crafted) {
        ArrayList<IngredientWithSize> inputList = new ArrayList<IngredientWithSize>(this.inputs.length);
        for (IngredientWithSize i : this.inputs) {
            if (i == null) continue;
            inputList.add(i);
        }
        NonNullList consumed = NonNullList.func_191196_a();
        Iterator inputIt = inputList.iterator();
        block1: while (inputIt.hasNext()) {
            IngredientWithSize ingr = (IngredientWithSize)inputIt.next();
            int inputSize = ingr.getCount() * crafted;
            for (int i = 0; i < query.size(); ++i) {
                ItemStack queryStack = (ItemStack)query.get(i);
                if (queryStack.func_190926_b() || !ingr.test(queryStack)) continue;
                int taken = Math.min(queryStack.func_190916_E(), inputSize);
                consumed.add((Object)ItemUtils.copyStackWithAmount(queryStack, taken));
                if (taken >= queryStack.func_190916_E() && queryStack.func_77973_b().hasContainerItem(queryStack)) {
                    query.set(i, (Object)queryStack.func_77973_b().getContainerItem(queryStack));
                } else {
                    queryStack.func_190918_g(taken);
                }
                if ((inputSize -= taken) > 0) continue;
                inputIt.remove();
                continue block1;
            }
        }
        return consumed;
    }

    public static BlueprintCraftingRecipe[] findRecipes(String blueprintCategory) {
        return recipesByCategory.getOrDefault(blueprintCategory, (List<BlueprintCraftingRecipe>)ImmutableList.of()).toArray(new BlueprintCraftingRecipe[0]);
    }

    public static void updateRecipeCategories() {
        recipesByCategory = recipeList.values().stream().collect(Collectors.groupingBy(r -> r.blueprintCategory));
        for (Map.Entry<String, List<BlueprintCraftingRecipe>> e : recipesByCategory.entrySet()) {
            if (!recipeCategories.contains(e.getKey())) {
                throw new RuntimeException("Recipe category " + e.getKey() + " was not registered during startup or in the IE config, but has recipes " + e.getValue().stream().map(r -> r.func_199560_c().toString()).collect(Collectors.joining(", ")));
            }
            e.getValue().sort(Comparator.comparing(IESerializableRecipe::func_199560_c));
        }
    }

    @Override
    public int getMultipleProcessTicks() {
        return 0;
    }

    public static void registerDefaultCategories() {
        recipeCategories.add("components");
        recipeCategories.add("molds");
        recipeCategories.add("bullet");
        recipeCategories.add("specialBullet");
        recipeCategories.add("electrode");
        recipeCategories.add("bannerpatterns");
    }

    static {
        recipeCategories = new TreeSet<String>();
        recipeList = Collections.emptyMap();
        recipesByCategory = Collections.emptyMap();
    }
}

