/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.utils.ItemUtils;
import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;

public class FluidTagInput
implements Predicate<FluidStack> {
    protected final Either<ITag.INamedTag<Fluid>, List<ResourceLocation>> fluidTag;
    protected final int amount;
    protected final CompoundNBT nbtTag;

    public FluidTagInput(Either<ITag.INamedTag<Fluid>, List<ResourceLocation>> matching, int amount, CompoundNBT nbtTag) {
        this.fluidTag = matching;
        this.amount = amount;
        this.nbtTag = nbtTag;
    }

    public FluidTagInput(ITag.INamedTag<Fluid> fluidTag, int amount, CompoundNBT nbtTag) {
        this((Either<ITag.INamedTag<Fluid>, List<ResourceLocation>>)Either.left(fluidTag), amount, nbtTag);
    }

    public FluidTagInput(ResourceLocation resourceLocation, int amount, CompoundNBT nbtTag) {
        this((ITag.INamedTag<Fluid>)FluidTags.func_206956_a((String)resourceLocation.toString()), amount, nbtTag);
    }

    public FluidTagInput(ResourceLocation resourceLocation, int amount) {
        this(resourceLocation, amount, null);
    }

    public static FluidTagInput deserialize(JsonElement input) {
        Preconditions.checkArgument((boolean)(input instanceof JsonObject), (Object)"FluidTagWithSize can only be deserialized from a JsonObject");
        JsonObject jsonObject = input.getAsJsonObject();
        ResourceLocation resourceLocation = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"tag"));
        if (!JSONUtils.func_151204_g((JsonObject)jsonObject, (String)"nbt")) {
            return new FluidTagInput(resourceLocation, JSONUtils.func_151203_m((JsonObject)jsonObject, (String)"amount"));
        }
        try {
            CompoundNBT nbt = ItemUtils.parseNbtFromJson(jsonObject.get("nbt"));
            return new FluidTagInput(resourceLocation, JSONUtils.func_151203_m((JsonObject)jsonObject, (String)"amount"), nbt);
        }
        catch (CommandSyntaxException e) {
            throw new JsonParseException((Throwable)e);
        }
    }

    public FluidTagInput withAmount(int amount) {
        return new FluidTagInput(this.fluidTag, amount, this.nbtTag);
    }

    @Override
    public boolean test(@Nullable FluidStack fluidStack) {
        return this.testIgnoringAmount(fluidStack) && fluidStack.getAmount() >= this.amount;
    }

    public boolean testIgnoringAmount(@Nullable FluidStack fluidStack) {
        if (fluidStack == null) {
            return false;
        }
        if (!((Boolean)this.fluidTag.map(t -> t.func_230235_a_((Object)fluidStack.getFluid()), l -> l.contains(fluidStack.getFluid().getRegistryName()))).booleanValue()) {
            return false;
        }
        if (this.nbtTag != null) {
            return fluidStack.hasTag() && fluidStack.getTag().equals((Object)this.nbtTag);
        }
        return true;
    }

    @Nonnull
    public List<FluidStack> getMatchingFluidStacks() {
        return ((Stream)this.fluidTag.map(t -> t.func_230236_b_().stream(), l -> l.stream().map(arg_0 -> ((IForgeRegistry)ForgeRegistries.FLUIDS).getValue(arg_0)))).map(fluid -> new FluidStack(fluid, this.amount, this.nbtTag)).collect(Collectors.toList());
    }

    @Nonnull
    public JsonElement serialize() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("tag", ((ITag.INamedTag)this.fluidTag.orThrow()).func_230234_a_().toString());
        jsonObject.addProperty("amount", (Number)this.amount);
        if (this.nbtTag != null) {
            jsonObject.addProperty("nbt", this.nbtTag.toString());
        }
        return jsonObject;
    }

    public int getAmount() {
        return this.amount;
    }

    public FluidStack getRandomizedExampleStack(int rand) {
        List<FluidStack> all = this.getMatchingFluidStacks();
        return all.get(rand / 20 % all.size());
    }

    public static FluidTagInput read(PacketBuffer input) {
        int numMatching = input.func_150792_a();
        ArrayList<ResourceLocation> matching = new ArrayList<ResourceLocation>(numMatching);
        for (int i = 0; i < numMatching; ++i) {
            matching.add(input.func_192575_l());
        }
        int amount = input.readInt();
        CompoundNBT nbt = input.readBoolean() ? input.func_150793_b() : null;
        return new FluidTagInput((Either<ITag.INamedTag<Fluid>, List<ResourceLocation>>)Either.right(matching), amount, nbt);
    }

    public void write(PacketBuffer out) {
        List matching = (List)this.fluidTag.map(f -> f.func_230236_b_().stream().map(ForgeRegistryEntry::getRegistryName).collect(Collectors.toList()), l -> l);
        out.func_150787_b(matching.size());
        for (ResourceLocation rl : matching) {
            out.func_192572_a(rl);
        }
        out.writeInt(this.amount);
        out.writeBoolean(this.nbtTag != null);
        if (this.nbtTag != null) {
            out.func_150786_a(this.nbtTag);
        }
    }
}

