/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.tool;

import blusunrize.immersiveengineering.api.utils.CapabilityUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.blocks.metal.ConveyorBeltTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.ConveyorBlock;
import blusunrize.immersiveengineering.common.util.SafeChunkUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.entity.Entity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.mutable.MutableLong;

public class ConveyorHandler {
    public static final Map<ResourceLocation, Class<? extends IConveyorBelt>> classRegistry = new LinkedHashMap<ResourceLocation, Class<? extends IConveyorBelt>>();
    public static final Map<ResourceLocation, Set<ResourceLocation>> substituteRegistry = new HashMap<ResourceLocation, Set<ResourceLocation>>();
    public static final Map<ResourceLocation, Function<TileEntity, ? extends IConveyorBelt>> functionRegistry = new LinkedHashMap<ResourceLocation, Function<TileEntity, ? extends IConveyorBelt>>();
    public static final Map<ResourceLocation, TileEntityType<? extends TileEntity>> tileEntities = new LinkedHashMap<ResourceLocation, TileEntityType<? extends TileEntity>>();
    public static final Map<Class<? extends IConveyorBelt>, ResourceLocation> reverseClassRegistry = new LinkedHashMap<Class<? extends IConveyorBelt>, ResourceLocation>();
    public static final Set<BiConsumer<Entity, IConveyorTile>> magnetSupressionFunctions = new HashSet<BiConsumer<Entity, IConveyorTile>>();
    public static final Set<BiConsumer<Entity, IConveyorTile>> magnetSupressionReverse = new HashSet<BiConsumer<Entity, IConveyorTile>>();
    public static final Map<ResourceLocation, Block> conveyorBlocks = IEBlocks.MetalDevices.CONVEYORS;
    public static final ResourceLocation textureConveyorColour = new ResourceLocation("immersiveengineering:block/conveyor/colour");
    private static final IntSet entitiesHandledInCurrentTickClient = new IntOpenHashSet();
    private static final MutableLong currentTickClient = new MutableLong();
    private static final IntSet entitiesHandledInCurrentTickServer = new IntOpenHashSet();
    private static final MutableLong currentTickServer = new MutableLong();

    public static boolean markEntityAsHandled(Entity e) {
        IntSet entitiesHandledInCurrentTick;
        MutableLong currentTick;
        if (e.field_70170_p.field_72995_K) {
            currentTick = currentTickClient;
            entitiesHandledInCurrentTick = entitiesHandledInCurrentTickClient;
        } else {
            currentTick = currentTickServer;
            entitiesHandledInCurrentTick = entitiesHandledInCurrentTickServer;
        }
        long now = e.field_70170_p.func_82737_E();
        if (now != currentTick.getValue()) {
            currentTick.setValue(now);
            entitiesHandledInCurrentTick.clear();
        }
        return entitiesHandledInCurrentTick.add(e.func_145782_y());
    }

    public static <T extends IConveyorBelt> boolean registerConveyorHandler(ResourceLocation key, Class<T> conveyorClass, Function<TileEntity, T> function) {
        if (classRegistry.containsKey(key)) {
            return false;
        }
        classRegistry.put(key, conveyorClass);
        reverseClassRegistry.put(conveyorClass, key);
        functionRegistry.put(key, function);
        return true;
    }

    public static void registerSubstitute(ResourceLocation key, ResourceLocation substitute) {
        Set registeredSubstitutes = substituteRegistry.computeIfAbsent(key, k -> new HashSet());
        registeredSubstitutes.add(substitute);
    }

    public static IConveyorBelt getConveyor(ResourceLocation key, @Nullable TileEntity tile) {
        IConveyorBelt fromTile;
        if (tile instanceof ConveyorBeltTileEntity && (fromTile = ((ConveyorBeltTileEntity)tile).getConveyorSubtype()) != null) {
            return fromTile;
        }
        Function<TileEntity, ? extends IConveyorBelt> func = functionRegistry.get(key);
        if (func != null) {
            return func.apply(tile);
        }
        return null;
    }

    public static void registerConveyorTEs(RegistryEvent.Register<TileEntityType<?>> evt) {
        for (ResourceLocation rl : classRegistry.keySet()) {
            TileEntityType te = new TileEntityType(() -> new ConveyorBeltTileEntity(rl), (Set)ImmutableSet.of((Object)conveyorBlocks.get(rl)), null);
            te.setRegistryName(ConveyorHandler.getRegistryNameFor(rl));
            tileEntities.put(rl, (TileEntityType<? extends TileEntity>)te);
            evt.getRegistry().register((IForgeRegistryEntry)te);
        }
    }

    public static TileEntityType<? extends TileEntity> getTEType(ResourceLocation typeName) {
        return tileEntities.get(typeName);
    }

    public static ResourceLocation getRegistryNameFor(ResourceLocation conveyorLoc) {
        String path = "immersiveengineering".equals(conveyorLoc.func_110624_b()) ? conveyorLoc.func_110623_a() : conveyorLoc.func_110624_b() + "_" + conveyorLoc.func_110623_a();
        return new ResourceLocation("immersiveengineering", "conveyor_" + path);
    }

    public static void createConveyorBlocks() {
        for (ResourceLocation rl : classRegistry.keySet()) {
            ConveyorBlock b = new ConveyorBlock(rl);
            conveyorBlocks.put(rl, b);
        }
    }

    public static ResourceLocation getType(Block b) {
        if (b instanceof ConveyorBlock) {
            return ((ConveyorBlock)b).getTypeName();
        }
        return null;
    }

    public static Block getBlock(ResourceLocation typeName) {
        return conveyorBlocks.get(typeName);
    }

    public static boolean isConveyor(World world, BlockPos pos, @Nonnull String key, @Nullable Direction facing) {
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof IConveyorTile)) {
            return false;
        }
        if (facing != null && !facing.equals((Object)((IConveyorTile)tile).getFacing())) {
            return false;
        }
        IConveyorBelt conveyor = ((IConveyorTile)tile).getConveyorSubtype();
        if (conveyor == null) {
            return false;
        }
        ResourceLocation rl = reverseClassRegistry.get(conveyor.getClass());
        if (rl == null) {
            return false;
        }
        ResourceLocation rlKey = new ResourceLocation(key);
        if (key.equalsIgnoreCase(rl.toString())) {
            return true;
        }
        if (substituteRegistry.containsKey(rlKey)) {
            return substituteRegistry.get(rlKey).contains(rl);
        }
        return false;
    }

    public static void registerMagnetSupression(BiConsumer<Entity, IConveyorTile> function, @Nullable BiConsumer<Entity, IConveyorTile> revert) {
        magnetSupressionFunctions.add(function);
        if (revert != null) {
            magnetSupressionReverse.add(revert);
        }
    }

    public static void applyMagnetSupression(Entity entity, IConveyorTile tile) {
        if (entity != null) {
            for (BiConsumer<Entity, IConveyorTile> func : magnetSupressionFunctions) {
                func.accept(entity, tile);
            }
        }
    }

    public static void revertMagnetSupression(Entity entity, IConveyorTile tile) {
        if (entity != null) {
            for (BiConsumer<Entity, IConveyorTile> func : magnetSupressionReverse) {
                func.accept(entity, tile);
            }
        }
    }

    public static interface IConveyorTile
    extends IConveyorAttachable {
        public IConveyorBelt getConveyorSubtype();

        @Override
        default public Direction[] sigOutputDirections() {
            IConveyorBelt subtype = this.getConveyorSubtype();
            if (subtype != null) {
                return subtype.sigTransportDirections();
            }
            return new Direction[0];
        }
    }

    public static interface IConveyorAttachable {
        public Direction getFacing();

        public Direction[] sigOutputDirections();
    }

    public static enum ConveyorDirection {
        HORIZONTAL,
        UP,
        DOWN;

    }

    public static interface IConveyorBelt {
        public static final VoxelShape conveyorBounds = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)1.0);
        public static final VoxelShape highConveyorBounds = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.125, (double)1.0);
        public static final VoxelShape FULL_BLOCK = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);

        default public String getModelCacheKey() {
            String key = reverseClassRegistry.get(this.getClass()).toString();
            key = key + "f" + this.getFacing().ordinal();
            key = key + "d" + this.getConveyorDirection().ordinal();
            key = key + "a" + (this.isActive() ? 1 : 0);
            key = key + "w0" + (this.renderWall(this.getFacing(), 0) ? 1 : 0);
            key = key + "w1" + (this.renderWall(this.getFacing(), 1) ? 1 : 0);
            key = key + "c" + this.getDyeColour();
            return key;
        }

        public TileEntity getTile();

        default public Direction getFacing() {
            TileEntity te = this.getTile();
            if (te instanceof IEBlockInterfaces.IDirectionalTile) {
                return ((IEBlockInterfaces.IDirectionalTile)te).getFacing();
            }
            return Direction.NORTH;
        }

        default public ConveyorDirection getConveyorDirection() {
            return ConveyorDirection.HORIZONTAL;
        }

        public boolean changeConveyorDirection();

        public boolean setConveyorDirection(ConveyorDirection var1);

        default public void afterRotation(Direction oldDir, Direction newDir) {
        }

        public boolean isActive();

        public boolean canBeDyed();

        public boolean setDyeColour(DyeColor var1);

        @Nullable
        public DyeColor getDyeColour();

        default public boolean playerInteraction(PlayerEntity player, Hand hand, ItemStack heldItem, float hitX, float hitY, float hitZ, Direction side) {
            return false;
        }

        default public boolean renderWall(Direction facing, int wall) {
            if (this.getConveyorDirection() != ConveyorDirection.HORIZONTAL) {
                return true;
            }
            Direction side = wall == 0 ? facing.func_176735_f() : facing.func_176746_e();
            BlockPos pos = this.getTile().func_174877_v().func_177972_a(side);
            TileEntity te = Utils.getExistingTileEntity(this.getTile().func_145831_w(), pos);
            if (te instanceof IConveyorAttachable) {
                boolean b = false;
                for (Direction f : ((IConveyorAttachable)te).sigOutputDirections()) {
                    if (f == side.func_176734_d()) {
                        b = true;
                        continue;
                    }
                    if (f != Direction.UP) continue;
                    b = false;
                }
                return !b;
            }
            te = Utils.getExistingTileEntity(this.getTile().func_145831_w(), pos.func_177982_a(0, -1, 0));
            if (te instanceof IConveyorAttachable) {
                int b = 0;
                for (Direction f : ((IConveyorAttachable)te).sigOutputDirections()) {
                    if (f == side.func_176734_d()) {
                        ++b;
                        continue;
                    }
                    if (f != Direction.UP) continue;
                    ++b;
                }
                return b < 2;
            }
            return true;
        }

        default public Direction[] sigTransportDirections() {
            if (this.getConveyorDirection() == ConveyorDirection.UP) {
                return new Direction[]{this.getFacing(), Direction.UP};
            }
            if (this.getConveyorDirection() == ConveyorDirection.DOWN) {
                return new Direction[]{this.getFacing(), Direction.DOWN};
            }
            return new Direction[]{this.getFacing()};
        }

        @Deprecated
        default public Vector3d getDirection(Entity entity) {
            return this.getDirection(entity, false);
        }

        default public Vector3d getDirection(Entity entity, boolean outputBlocked) {
            ConveyorDirection conveyorDirection = this.getConveyorDirection();
            BlockPos pos = this.getTile().func_174877_v();
            Direction facing = this.getFacing();
            double vBase = 1.15;
            double vX = 0.1 * vBase * (double)facing.func_82601_c();
            double vY = entity.func_213322_ci().field_72448_b;
            double vZ = 0.1 * vBase * (double)facing.func_82599_e();
            if (facing == Direction.WEST || facing == Direction.EAST) {
                if (entity.func_226281_cx_() > (double)pos.func_177952_p() + 0.55) {
                    vZ = -0.1 * vBase;
                } else if (entity.func_226281_cx_() < (double)pos.func_177952_p() + 0.45) {
                    vZ = 0.1 * vBase;
                }
            } else if (facing == Direction.NORTH || facing == Direction.SOUTH) {
                if (entity.func_226277_ct_() > (double)pos.func_177958_n() + 0.55) {
                    vX = -0.1 * vBase;
                } else if (entity.func_226277_ct_() < (double)pos.func_177958_n() + 0.45) {
                    vX = 0.1 * vBase;
                }
            }
            if (conveyorDirection != ConveyorDirection.HORIZONTAL) {
                Vector3d centerRelative = entity.func_213303_ch().func_178788_d(new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p())).func_178786_a(0.5 + vX, 0.5, 0.5 + vZ);
                double conveyorHeight = 0.125;
                Vector3i directionVector = facing.func_176730_m();
                double centerOffsetInDirection = centerRelative.func_72430_b(new Vector3d((double)directionVector.func_177958_n(), (double)directionVector.func_177956_o(), (double)directionVector.func_177952_p()));
                double radius = entity.func_213305_a((Pose)entity.func_213283_Z()).field_220315_a / 2.0f;
                double maxEntityPos = centerOffsetInDirection + radius;
                double maxCenterHeightUnderEntity = maxEntityPos + 0.125;
                if (conveyorDirection == ConveyorDirection.DOWN) {
                    maxCenterHeightUnderEntity = -maxCenterHeightUnderEntity;
                }
                if (conveyorDirection == ConveyorDirection.UP) {
                    if (maxCenterHeightUnderEntity > centerRelative.field_72448_b || !outputBlocked) {
                        vY = 0.17 * vBase;
                    }
                } else {
                    vY = Math.signum(maxCenterHeightUnderEntity - centerRelative.field_72448_b) * 0.07 * vBase;
                }
                entity.func_230245_c_(false);
            }
            return new Vector3d(vX, vY, vZ);
        }

        default public void onEntityCollision(@Nonnull Entity entity) {
            if (!this.isActive() || !entity.func_70089_S()) {
                return;
            }
            if (entity instanceof PlayerEntity && entity.func_225608_bj_()) {
                return;
            }
            ConveyorDirection conveyorDirection = this.getConveyorDirection();
            float heightLimit = conveyorDirection == ConveyorDirection.HORIZONTAL ? 0.25f : 1.0f;
            BlockPos pos = this.getTile().func_174877_v();
            double relativeHeight = entity.func_226278_cu_() - (double)pos.func_177956_o();
            if (relativeHeight >= 0.0 && relativeHeight < (double)heightLimit) {
                boolean hasBeenHandled = !ConveyorHandler.markEntityAsHandled(entity);
                boolean outputBlocked = this.isOutputBlocked();
                Vector3d vec = this.getDirection(entity, outputBlocked);
                if (entity.field_70143_R < 3.0f) {
                    entity.field_70143_R = 0.0f;
                }
                if (outputBlocked) {
                    double replacementZ;
                    double replacementX;
                    if (hasBeenHandled) {
                        replacementX = entity.func_213322_ci().field_72450_a;
                        replacementZ = entity.func_213322_ci().field_72449_c;
                    } else {
                        replacementX = 0.0;
                        replacementZ = 0.0;
                    }
                    vec = new Vector3d(replacementX, vec.field_72448_b, replacementZ);
                }
                entity.func_213317_d(vec);
                double distX = Math.abs((double)pos.func_177972_a(this.getFacing()).func_177958_n() + 0.5 - entity.func_226277_ct_());
                double distZ = Math.abs((double)pos.func_177972_a(this.getFacing()).func_177952_p() + 0.5 - entity.func_226281_cx_());
                double threshold = 0.9;
                boolean contact = this.getFacing().func_176740_k() == Direction.Axis.Z ? distZ < threshold : distX < threshold;
                World w = this.getTile().func_145831_w();
                BlockPos upPos = pos.func_177972_a(this.getFacing()).func_177984_a();
                if (contact && conveyorDirection == ConveyorDirection.UP && !Block.func_208061_a((VoxelShape)w.func_180495_p(upPos).func_196954_c((IBlockReader)w, upPos), (Direction)Direction.DOWN)) {
                    double move = 0.4;
                    entity.func_70107_b(entity.func_226277_ct_() + move * (double)this.getFacing().func_82601_c(), entity.func_226278_cu_() + 1.0 * move, entity.func_226281_cx_() + move * (double)this.getFacing().func_82599_e());
                }
                if (!contact) {
                    ConveyorHandler.applyMagnetSupression(entity, (IConveyorTile)this.getTile());
                } else {
                    BlockPos nextPos = this.getTile().func_174877_v().func_177972_a(this.getFacing());
                    if (!(Utils.getExistingTileEntity(this.getTile().func_145831_w(), nextPos) instanceof IConveyorTile)) {
                        ConveyorHandler.revertMagnetSupression(entity, (IConveyorTile)this.getTile());
                    }
                }
                if (entity instanceof ItemEntity && entity.field_70173_aa > 1) {
                    ItemEntity item = (ItemEntity)entity;
                    if (!contact) {
                        if (item.field_70292_b > item.lifespan - 1200 && !outputBlocked) {
                            item.field_70292_b = item.lifespan - 1200;
                        }
                    } else {
                        this.handleInsertion(item, conveyorDirection, distX, distZ);
                    }
                }
            }
        }

        default public boolean isBlocked() {
            return false;
        }

        default public boolean isOutputBlocked() {
            IConveyorBelt outputBelt = this.getOutputConveyor();
            return outputBelt != null && outputBelt.isBlocked();
        }

        default public void onItemDeployed(ItemEntity entity) {
            ConveyorHandler.applyMagnetSupression((Entity)entity, (IConveyorTile)this.getTile());
        }

        default public void handleInsertion(ItemEntity entity, ConveyorDirection conDir, double distX, double distZ) {
            if (this.getTile().func_145831_w().field_72995_K) {
                return;
            }
            BlockPos invPos = this.getOutputInventory();
            World world = this.getTile().func_145831_w();
            boolean contact = this.getFacing().func_176740_k() == Direction.Axis.Z ? distZ < 0.7 : distX < 0.7;
            TileEntity inventoryTile = Utils.getExistingTileEntity(world, invPos);
            if (!contact || inventoryTile instanceof IConveyorTile) {
                return;
            }
            LazyOptional<IItemHandler> cap = CapabilityUtils.findItemHandlerAtPos(world, invPos, this.getFacing().func_176734_d(), true);
            cap.ifPresent(itemHandler -> {
                ItemStack stack = entity.func_92059_d();
                ItemStack temp = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack.func_77946_l(), (boolean)true);
                if (temp.func_190926_b() || temp.func_190916_E() < stack.func_190916_E()) {
                    temp = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false);
                    if (temp.func_190926_b()) {
                        entity.func_70106_y();
                    } else if (temp.func_190916_E() < stack.func_190916_E()) {
                        entity.func_92058_a(temp);
                    }
                }
            });
        }

        default public BlockPos getOutputInventory() {
            ConveyorDirection conDir = this.getConveyorDirection();
            return this.getTile().func_174877_v().func_177972_a(this.getFacing()).func_177982_a(0, conDir == ConveyorDirection.UP ? 1 : (conDir == ConveyorDirection.DOWN ? -1 : 0), 0);
        }

        default public List<BlockPos> getNextConveyorCandidates() {
            ConveyorDirection conDir = this.getConveyorDirection();
            BlockPos basePos = this.getOutputInventory();
            BlockPos alternative = conDir == ConveyorDirection.DOWN ? basePos.func_177984_a() : basePos.func_177977_b();
            return ImmutableList.of((Object)basePos, (Object)alternative);
        }

        @Nullable
        default public IConveyorBelt getOutputConveyor() {
            for (BlockPos pos : this.getNextConveyorCandidates()) {
                TileEntity outputTile = SafeChunkUtils.getSafeTE((IWorld)this.getTile().func_145831_w(), pos);
                if (!(outputTile instanceof IConveyorTile)) continue;
                return ((IConveyorTile)outputTile).getConveyorSubtype();
            }
            return null;
        }

        default public boolean isTicking() {
            return false;
        }

        default public void onUpdate() {
        }

        default public VoxelShape getSelectionShape() {
            return this.getConveyorDirection() == ConveyorDirection.HORIZONTAL ? conveyorBounds : highConveyorBounds;
        }

        default public VoxelShape getCollisionShape() {
            return conveyorBounds;
        }

        public CompoundNBT writeConveyorNBT();

        public void readConveyorNBT(CompoundNBT var1);

        @OnlyIn(value=Dist.CLIENT)
        default public TransformationMatrix modifyBaseRotationMatrix(TransformationMatrix matrix) {
            return matrix;
        }

        @OnlyIn(value=Dist.CLIENT)
        public ResourceLocation getActiveTexture();

        @OnlyIn(value=Dist.CLIENT)
        public ResourceLocation getInactiveTexture();

        @OnlyIn(value=Dist.CLIENT)
        default public ResourceLocation getColouredStripesTexture() {
            return textureConveyorColour;
        }

        @OnlyIn(value=Dist.CLIENT)
        default public List<BakedQuad> modifyQuads(List<BakedQuad> baseModel) {
            return baseModel;
        }
    }
}

