/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.tool;

import java.util.HashMap;
import java.util.Optional;
import net.minecraft.block.AbstractFurnaceBlock;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.state.Property;
import net.minecraft.tileentity.FurnaceTileEntity;
import net.minecraft.tileentity.TileEntity;

public class ExternalHeaterHandler {
    public static int defaultFurnaceEnergyCost;
    public static int defaultFurnaceSpeedupCost;
    public static HashMap<Class<? extends TileEntity>, HeatableAdapter> adapterMap;

    public static void registerHeatableAdapter(Class<? extends TileEntity> c, HeatableAdapter adapter) {
        adapterMap.put(c, adapter);
    }

    public static HeatableAdapter getHeatableAdapter(Class<? extends TileEntity> c) {
        HeatableAdapter adapter = adapterMap.get(c);
        if (adapter == null && c != TileEntity.class && c.getSuperclass() != TileEntity.class) {
            adapter = ExternalHeaterHandler.getHeatableAdapter(c.getSuperclass());
            adapterMap.put(c, adapter);
        }
        return adapter;
    }

    static {
        adapterMap = new HashMap();
    }

    public static class DefaultFurnaceAdapter
    extends HeatableAdapter<FurnaceTileEntity> {
        boolean canCook(FurnaceTileEntity tileEntity) {
            ItemStack input = tileEntity.func_70301_a(0);
            if (input.func_190926_b()) {
                return false;
            }
            IRecipeType type = tileEntity.field_214014_c;
            Optional output = tileEntity.func_145831_w().func_199532_z().func_215371_a(type, (IInventory)tileEntity, tileEntity.func_145831_w());
            if (!output.isPresent()) {
                return false;
            }
            ItemStack existingOutput = tileEntity.func_70301_a(2);
            if (existingOutput.func_190926_b()) {
                return true;
            }
            ItemStack outStack = ((AbstractCookingRecipe)output.get()).func_77571_b();
            if (!existingOutput.func_77969_a(outStack)) {
                return false;
            }
            int stackSize = existingOutput.func_190916_E() + outStack.func_190916_E();
            return stackSize <= tileEntity.func_70297_j_() && stackSize <= outStack.func_77976_d();
        }

        @Override
        public int doHeatTick(FurnaceTileEntity tileEntity, int energyAvailable, boolean redstone) {
            int energyConsumed = 0;
            boolean canCook = this.canCook(tileEntity);
            if (canCook || redstone) {
                int energyToUse;
                BlockState tileState = tileEntity.func_145831_w().func_180495_p(tileEntity.func_174877_v());
                boolean burning = (Boolean)tileState.func_177229_b((Property)AbstractFurnaceBlock.field_220091_b);
                int burnTime = tileEntity.field_214013_b.func_221476_a(0);
                if (burnTime < 200) {
                    int heatEnergyRatio;
                    int heatAttempt = 4;
                    int energyToUse2 = Math.min(energyAvailable, (heatAttempt = Math.min(heatAttempt, 200 - burnTime)) * (heatEnergyRatio = Math.max(1, defaultFurnaceEnergyCost)));
                    int heat = energyToUse2 / heatEnergyRatio;
                    if (heat > 0) {
                        tileEntity.field_214013_b.func_221477_a(0, burnTime + heat);
                        energyConsumed += heat * heatEnergyRatio;
                        if (!burning) {
                            this.updateFurnace((TileEntity)tileEntity, tileEntity.field_214013_b.func_221476_a(0) > 0);
                        }
                    }
                }
                if (canCook && tileEntity.field_214013_b.func_221476_a(0) >= 200 && tileEntity.field_214013_b.func_221476_a(2) < 199 && energyAvailable - energyConsumed > (energyToUse = defaultFurnaceSpeedupCost)) {
                    energyConsumed += energyToUse;
                    tileEntity.field_214013_b.func_221477_a(2, tileEntity.field_214013_b.func_221476_a(2) + 1);
                }
            }
            return energyConsumed;
        }

        public void updateFurnace(TileEntity tileEntity, boolean active) {
            BlockState oldState = tileEntity.func_145831_w().func_180495_p(tileEntity.func_174877_v());
            tileEntity.func_145831_w().func_175656_a(tileEntity.func_174877_v(), (BlockState)oldState.func_206870_a((Property)AbstractFurnaceBlock.field_220091_b, (Comparable)Boolean.valueOf(active)));
        }
    }

    public static abstract class HeatableAdapter<E extends TileEntity> {
        public abstract int doHeatTick(E var1, int var2, boolean var3);
    }

    public static interface IExternalHeatable {
        public int doHeatTick(int var1, boolean var2);
    }
}

