/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.utils;

import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;

public class IngredientUtils {
    public static boolean stacksMatchIngredientList(List<Ingredient> list, NonNullList<ItemStack> stacks) {
        return IngredientUtils.stacksMatchList(list, stacks, i -> 1, Ingredient::test);
    }

    public static boolean stacksMatchIngredientWithSizeList(List<IngredientWithSize> list, NonNullList<ItemStack> stacks) {
        return IngredientUtils.stacksMatchList(list, stacks, IngredientWithSize::getCount, IngredientWithSize::testIgnoringSize);
    }

    public static Ingredient createIngredientFromList(List<ItemStack> list) {
        return Ingredient.func_193369_a((ItemStack[])list.toArray(new ItemStack[0]));
    }

    private static <T> boolean stacksMatchList(List<T> list, NonNullList<ItemStack> stacks, Function<T, Integer> size, BiPredicate<T, ItemStack> matchesIgnoringSize) {
        ArrayList<ItemStack> queryList = new ArrayList<ItemStack>(stacks.size());
        for (ItemStack s : stacks) {
            if (s.func_190926_b()) continue;
            queryList.add(s.func_77946_l());
        }
        for (T ingr : list) {
            if (ingr == null) continue;
            int amount = size.apply(ingr);
            Iterator it = queryList.iterator();
            while (it.hasNext()) {
                ItemStack query = (ItemStack)it.next();
                if (query.func_190926_b()) continue;
                if (matchesIgnoringSize.test(ingr, query)) {
                    if (query.func_190916_E() > amount) {
                        query.func_190918_g(amount);
                        amount = 0;
                    } else {
                        amount -= query.func_190916_E();
                        query.func_190920_e(0);
                    }
                }
                if (query.func_190916_E() <= 0) {
                    it.remove();
                }
                if (amount > 0) continue;
                break;
            }
            if (amount <= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean hasPlayerIngredient(PlayerEntity player, IngredientWithSize ingredient) {
        ItemStack itemstack;
        int amount = ingredient.getCount();
        for (Hand hand : Hand.values()) {
            itemstack = player.func_184586_b(hand);
            if (!ingredient.test(itemstack) || (amount -= itemstack.func_190916_E()) > 0) continue;
            return true;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            itemstack = player.field_71071_by.func_70301_a(i);
            if (!ingredient.test(itemstack) || (amount -= itemstack.func_190916_E()) > 0) continue;
            return true;
        }
        return amount <= 0;
    }

    public static void consumePlayerIngredient(PlayerEntity player, IngredientWithSize ingredient) {
        ItemStack itemstack;
        int amount = ingredient.getCount();
        for (Hand hand : Hand.values()) {
            itemstack = player.func_184586_b(hand);
            if (!ingredient.testIgnoringSize(itemstack)) continue;
            int taken = Math.min(amount, itemstack.func_190916_E());
            amount -= taken;
            itemstack.func_190918_g(taken);
            if (itemstack.func_190916_E() <= 0) {
                player.func_184611_a(hand, ItemStack.field_190927_a);
            }
            if (amount > 0) continue;
            return;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            itemstack = player.field_71071_by.func_70301_a(i);
            if (!ingredient.testIgnoringSize(itemstack)) continue;
            int taken = Math.min(amount, itemstack.func_190916_E());
            amount -= taken;
            itemstack.func_190918_g(taken);
            if (itemstack.func_190916_E() <= 0) {
                player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
            }
            if (amount > 0) continue;
            return;
        }
    }
}

