/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireLogger;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.client.utils.CombinedModelData;
import blusunrize.immersiveengineering.client.utils.SinglePropertyModelData;
import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.IModelData;

public abstract class ImmersiveConnectableTileEntity
extends IEBaseTileEntity
implements IImmersiveConnectable {
    protected GlobalWireNetwork globalNet;
    private final Int2ObjectMap<LocalWireNetwork> cachedLocalNets = new Int2ObjectArrayMap();

    public ImmersiveConnectableTileEntity(TileEntityType<? extends ImmersiveConnectableTileEntity> type) {
        super(type);
    }

    @Override
    public boolean canConnect() {
        return true;
    }

    @Override
    public BlockPos getConnectionMaster(WireType cableType, TargetingInfo target) {
        return this.func_174877_v();
    }

    @Override
    public void connectCable(WireType cableType, ConnectionPoint target, IImmersiveConnectable other, ConnectionPoint otherTarget) {
    }

    @Override
    public void removeCable(Connection connection, ConnectionPoint attachedPoint) {
        this.func_70296_d();
        if (this.field_145850_b != null) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    @Override
    public void func_226984_a_(World worldIn, BlockPos pos) {
        super.func_226984_a_(worldIn, pos);
        this.globalNet = GlobalWireNetwork.getNetwork(worldIn);
    }

    @Override
    public boolean func_145842_c(int id, int arg) {
        if (id == -1 || id == 255) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            return true;
        }
        if (id == 254) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            return true;
        }
        return super.func_145842_c(id, arg);
    }

    @Override
    @Nullable
    public ConnectionPoint getTargetedPoint(TargetingInfo info, Vector3i offset) {
        return new ConnectionPoint(this.field_174879_c, 0);
    }

    @Override
    public void readCustomNBT(@Nonnull CompoundNBT nbt, boolean descPacket) {
    }

    @Override
    public void writeCustomNBT(@Nonnull CompoundNBT nbt, boolean descPacket) {
    }

    public IEProperties.ConnectionModelData genConnBlockstate() {
        HashSet<Connection> ret = new HashSet<Connection>();
        for (ConnectionPoint cp : this.getConnectionPoints()) {
            LocalWireNetwork local = this.globalNet.getLocalNet(cp);
            Collection<Connection> conns = local.getConnections(cp);
            if (conns == null) {
                WireLogger.logger.warn("Aborting and returning empty data: null connections at {}", (Object)cp);
                return new IEProperties.ConnectionModelData((Set<Connection>)ImmutableSet.of(), this.field_174879_c);
            }
            for (Connection c : conns) {
                IImmersiveConnectable otherConnector;
                ConnectionPoint other = c.getOtherEnd(cp);
                if (c.isInternal() || (otherConnector = this.globalNet.getLocalNet(other).getConnector(other)) == null || otherConnector.isProxy()) continue;
                c.generateCatenaryData(this.field_145850_b);
                ret.add(c);
            }
        }
        return new IEProperties.ConnectionModelData(ret, this.field_174879_c);
    }

    @Override
    @Nonnull
    public IModelData getModelData() {
        return new CombinedModelData(new SinglePropertyModelData<IEProperties.ConnectionModelData>(this.genConnBlockstate(), IEProperties.Model.CONNECTIONS), super.getModelData());
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.globalNet.onConnectorUnload(this.field_174879_c, this);
    }

    public void onLoad() {
        super.onLoad();
        ApiUtils.addFutureServerTask(this.field_145850_b, () -> this.globalNet.onConnectorLoad((IImmersiveConnectable)this, this.field_145850_b), true);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.globalNet.removeConnector(this);
    }

    @Override
    public Collection<ConnectionPoint> getConnectionPoints() {
        return ImmutableList.of((Object)new ConnectionPoint(this.field_174879_c, 0));
    }

    protected LocalWireNetwork getLocalNet(int cpIndex) {
        LocalWireNetwork ret = (LocalWireNetwork)this.cachedLocalNets.get(cpIndex);
        ConnectionPoint cp = new ConnectionPoint(this.func_174877_v(), cpIndex);
        if (ret == null || !ret.isValid(cp)) {
            ret = this.globalNet.getLocalNet(cp);
            this.cachedLocalNets.put(cpIndex, (Object)ret);
        }
        return ret;
    }

    @Override
    public BlockPos getPosition() {
        return this.field_174879_c;
    }
}

