/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires.localhandlers;

import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.localhandlers.ILocalHandlerConstructor;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public abstract class LocalNetworkHandler {
    private static final Map<ResourceLocation, ILocalHandlerConstructor> TYPES = new HashMap<ResourceLocation, ILocalHandlerConstructor>();
    protected LocalWireNetwork localNet;
    protected final GlobalWireNetwork globalNet;

    public static void register(ResourceLocation loc, ILocalHandlerConstructor constructor) {
        TYPES.put(loc, constructor);
    }

    public static LocalNetworkHandler createHandler(ResourceLocation type, LocalWireNetwork local, GlobalWireNetwork global) {
        try {
            return TYPES.get(type).create(local, global);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected LocalNetworkHandler(LocalWireNetwork net, GlobalWireNetwork global) {
        this.localNet = net;
        this.globalNet = global;
    }

    public void setLocalNet(LocalWireNetwork net) {
        this.localNet = net;
    }

    public abstract LocalNetworkHandler merge(LocalNetworkHandler var1);

    public abstract void onConnectorLoaded(ConnectionPoint var1, IImmersiveConnectable var2);

    public abstract void onConnectorUnloaded(BlockPos var1, IImmersiveConnectable var2);

    public abstract void onConnectorRemoved(BlockPos var1, IImmersiveConnectable var2);

    public abstract void onConnectionAdded(Connection var1);

    public abstract void onConnectionRemoved(Connection var1);
}

