/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires.proxy;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.WireType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class IICProxy
implements IImmersiveConnectable {
    private final World world;
    private final BlockPos pos;
    private final List<Connection> internalConns;
    private final List<ConnectionPoint> points;

    public IICProxy(World world, BlockPos pos, Collection<Connection> internal, Collection<ConnectionPoint> points) {
        this.world = world;
        this.pos = pos;
        this.internalConns = new ArrayList<Connection>(internal);
        this.points = new ArrayList<ConnectionPoint>(points);
    }

    @Override
    public Iterable<? extends Connection> getInternalConnections() {
        return this.internalConns;
    }

    @Override
    public void removeCable(Connection connection, ConnectionPoint attachedPoint) {
        TileEntity te = this.world.func_175625_s(this.pos);
        if (!(te instanceof IImmersiveConnectable)) {
            return;
        }
        ((IImmersiveConnectable)te).removeCable(connection, attachedPoint);
    }

    @Override
    public boolean canConnect() {
        return false;
    }

    @Override
    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vector3i offset) {
        return false;
    }

    @Override
    public void connectCable(WireType cableType, ConnectionPoint target, IImmersiveConnectable other, ConnectionPoint otherTarget) {
    }

    @Override
    @Nullable
    public ConnectionPoint getTargetedPoint(TargetingInfo info, Vector3i offset) {
        return null;
    }

    @Override
    public Vector3d getConnectionOffset(@Nonnull Connection con, ConnectionPoint here) {
        return null;
    }

    @Override
    public Collection<ConnectionPoint> getConnectionPoints() {
        return this.points;
    }

    public static IICProxy readFromNBT(World world, CompoundNBT nbt) {
        ListNBT internalNBT = nbt.func_150295_c("internal", 10);
        ArrayList<Connection> internal = new ArrayList<Connection>(internalNBT.size());
        for (INBT c : internalNBT) {
            internal.add(new Connection((CompoundNBT)c));
        }
        ListNBT pointNBT = nbt.func_150295_c("points", 10);
        ArrayList<ConnectionPoint> points = new ArrayList<ConnectionPoint>();
        for (INBT c : pointNBT) {
            points.add(new ConnectionPoint((CompoundNBT)c));
        }
        return new IICProxy(world, NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("pos")), internal, points);
    }

    public CompoundNBT writeToNBT() {
        CompoundNBT ret = new CompoundNBT();
        ret.func_218657_a("pos", (INBT)NBTUtil.func_186859_a((BlockPos)this.pos));
        ListNBT points = new ListNBT();
        for (ConnectionPoint cp : this.points) {
            points.add((Object)cp.createTag());
        }
        ret.func_218657_a("points", (INBT)points);
        ListNBT internal = new ListNBT();
        for (Connection conn : this.internalConns) {
            internal.add((Object)conn.toNBT());
        }
        ret.func_218657_a("internal", (INBT)internal);
        return ret;
    }

    @Override
    public BlockPos getConnectionMaster(WireType cableType, TargetingInfo target) {
        return this.pos;
    }

    @Override
    public boolean isProxy() {
        return true;
    }

    @Override
    public BlockPos getPosition() {
        return this.pos;
    }
}

