/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.ClientTileScreen;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonBoolean;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonState;
import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.ConnectorRedstoneTileEntity;
import blusunrize.immersiveengineering.common.network.MessageTileSync;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class RedstoneConnectorScreen
extends ClientTileScreen<ConnectorRedstoneTileEntity> {
    private GuiButtonState<IEEnums.IOSideConfig> buttonInOut;
    private GuiButtonBoolean[] colorButtons;

    public RedstoneConnectorScreen(ConnectorRedstoneTileEntity tileEntity, ITextComponent title) {
        super(tileEntity, title);
        this.xSize = 100;
        this.ySize = 120;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        ClientUtils.mc().field_195559_v.func_197967_a(true);
        this.field_230710_m_.clear();
        this.buttonInOut = new GuiButtonState<IEEnums.IOSideConfig>(this.guiLeft + 41, this.guiTop + 20, 18, 18, StringTextComponent.field_240750_d_, new IEEnums.IOSideConfig[]{IEEnums.IOSideConfig.INPUT, IEEnums.IOSideConfig.OUTPUT}, ((ConnectorRedstoneTileEntity)this.tileEntity).ioMode.ordinal() - 1, "immersiveengineering:textures/gui/redstone_configuration.png", 176, 0, 1, btn -> this.sendConfig("ioMode", ((IEEnums.IOSideConfig)((Object)((Object)btn.getNextState()))).ordinal()));
        this.func_230480_a_((Widget)this.buttonInOut);
        this.colorButtons = new GuiButtonBoolean[16];
        for (int i = 0; i < this.colorButtons.length; ++i) {
            DyeColor color = DyeColor.func_196056_a((int)i);
            this.colorButtons[i] = RedstoneConnectorScreen.buildColorButton(this.colorButtons, this.guiLeft + 22 + i % 4 * 14, this.guiTop + 44 + i / 4 * 14, ((ConnectorRedstoneTileEntity)this.tileEntity).redstoneChannel.ordinal() == i, color, btn -> this.sendConfig("redstoneChannel", color.func_196059_a()));
            this.func_230480_a_((Widget)this.colorButtons[i]);
        }
    }

    public void sendConfig(String key, int value) {
        CompoundNBT message = new CompoundNBT();
        message.func_74768_a(key, value);
        ImmersiveEngineering.packetHandler.sendToServer((Object)new MessageTileSync((IEBaseTileEntity)this.tileEntity, message));
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(MatrixStack transform, int mouseX, int mouseY, float partialTick) {
    }

    @Override
    protected void drawGuiContainerForegroundLayer(MatrixStack transform, int mouseX, int mouseY, float partialTick) {
        ArrayList<Object> tooltip = new ArrayList<Object>();
        if (this.buttonInOut.func_230449_g_()) {
            tooltip.add(new TranslationTextComponent("gui.immersiveengineering.config.redstone_iomode"));
            tooltip.add(ClientUtils.applyFormat(this.buttonInOut.getState().getTextComponent(), TextFormatting.GRAY));
        }
        for (int i = 0; i < this.colorButtons.length; ++i) {
            if (!this.colorButtons[i].func_230449_g_()) continue;
            tooltip.add(new TranslationTextComponent("gui.immersiveengineering.config.redstone_color"));
            tooltip.add(ClientUtils.applyFormat((ITextComponent)new TranslationTextComponent("color.minecraft." + DyeColor.func_196056_a((int)i).func_176762_d()), TextFormatting.GRAY));
        }
        if (!tooltip.isEmpty()) {
            GuiUtils.drawHoveringText((MatrixStack)transform, tooltip, (int)mouseX, (int)mouseY, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)-1, (FontRenderer)this.field_230712_o_);
        }
    }

    public static GuiButtonBoolean buildColorButton(GuiButtonBoolean[] buttons, int posX, int posY, boolean active, final DyeColor color, Consumer<GuiButtonBoolean> onClick) {
        return new GuiButtonBoolean(posX, posY, 12, 12, "", active, "immersiveengineering:textures/gui/redstone_configuration.png", 194, 0, 1, btn -> {
            if (((Boolean)btn.getNextState()).booleanValue()) {
                onClick.accept((GuiButtonBoolean)btn);
            }
            for (int j = 0; j < buttons.length; ++j) {
                if (j == color.ordinal()) continue;
                buttons[j].setStateByInt(0);
            }
        }){

            protected boolean func_230987_a_(int button) {
                return button == 0 && (Boolean)this.getState() == false;
            }

            @Override
            public void func_230430_a_(MatrixStack transform, int mouseX, int mouseY, float partialTicks) {
                super.func_230430_a_(transform, mouseX, mouseY, partialTicks);
                if (this.field_230694_p_) {
                    int col = color.field_193351_w;
                    if (!((Boolean)this.getState()).booleanValue()) {
                        col = ClientUtils.getDarkenedTextColour(col);
                    }
                    col = 0xFF000000 | col;
                    this.func_238468_a_(transform, this.field_230690_l_ + 3, this.field_230691_m_ + 3, this.field_230690_l_ + 9, this.field_230691_m_ + 9, col, col);
                }
            }
        };
    }
}

