/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.split;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.IModelOffsetProvider;
import blusunrize.immersiveengineering.client.models.CompositeBakedModel;
import blusunrize.immersiveengineering.client.models.split.PolygonUtils;
import blusunrize.immersiveengineering.client.utils.CombinedModelData;
import blusunrize.immersiveengineering.client.utils.SinglePropertyModelData;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.modelsplitter.ClumpedModel;
import malte0811.modelsplitter.SplitModel;
import malte0811.modelsplitter.math.ModelSplitterVec3i;
import malte0811.modelsplitter.model.OBJModel;
import malte0811.modelsplitter.model.Polygon;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.util.Lazy;

public class BakedBasicSplitModel
extends CompositeBakedModel<IBakedModel> {
    private final Lazy<Map<Vector3i, List<BakedQuad>>> splitModels = Lazy.concurrentOf(() -> {
        List quads = base.getQuads(null, null, Utils.RAND, (IModelData)EmptyModelData.INSTANCE);
        return BakedBasicSplitModel.split(quads, parts, transform);
    });

    public BakedBasicSplitModel(IBakedModel base, Set<Vector3i> parts, IModelTransform transform) {
        super(base);
    }

    @Override
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        BlockPos offset = (BlockPos)extraData.getData(IEProperties.Model.SUBMODEL_OFFSET);
        if (offset != null) {
            return (List)((Map)this.splitModels.get()).getOrDefault(offset, ImmutableList.of());
        }
        return this.base.getQuads(state, side, rand, extraData);
    }

    @Override
    @Nonnull
    public IModelData getModelData(@Nonnull IBlockDisplayReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IModelOffsetProvider) {
            return new CombinedModelData(new SinglePropertyModelData<BlockPos>(((IModelOffsetProvider)te).getModelOffset(state), IEProperties.Model.SUBMODEL_OFFSET), tileData);
        }
        return tileData;
    }

    public static Map<Vector3i, List<BakedQuad>> split(List<BakedQuad> in, Set<Vector3i> parts, IModelTransform transform) {
        List polys = in.stream().map(PolygonUtils::toPolygon).collect(Collectors.toList());
        SplitModel splitData = new SplitModel(new OBJModel(polys));
        Set<ModelSplitterVec3i> partsBMS = parts.stream().map(v -> new ModelSplitterVec3i(v.func_177958_n(), v.func_177956_o(), v.func_177952_p())).collect(Collectors.toSet());
        ClumpedModel clumpedModel = new ClumpedModel(splitData, partsBMS);
        HashMap<Vector3i, List<BakedQuad>> map = new HashMap<Vector3i, List<BakedQuad>>();
        for (Map.Entry e : clumpedModel.getClumpedParts().entrySet()) {
            ArrayList<BakedQuad> subModelFaces = new ArrayList<BakedQuad>(e.getValue().getFaces().size());
            for (Polygon<TextureAtlasSprite> polygon : e.getValue().getFaces()) {
                subModelFaces.add(PolygonUtils.toBakedQuad(polygon, transform, DefaultVertexFormats.field_176600_a));
            }
            Vector3i mcKey = new Vector3i(e.getKey().getX(), e.getKey().getY(), e.getKey().getZ());
            map.put(mcKey, subModelFaces);
        }
        return map;
    }
}

