/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.DirectionalBlockPos;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.ImmersiveConnectableTileEntity;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.redstone.CapabilityRedstoneNetwork;
import blusunrize.immersiveengineering.api.wires.redstone.IRedstoneConnector;
import blusunrize.immersiveengineering.api.wires.redstone.RedstoneNetworkHandler;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.MiscConnectorBlock;
import blusunrize.immersiveengineering.common.blocks.metal.EnergyConnectorTileEntity;
import blusunrize.immersiveengineering.common.util.CapabilityReference;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.EnumProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public class ConnectorBundledTileEntity
extends ImmersiveConnectableTileEntity
implements ITickableTileEntity,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IBlockBounds,
IRedstoneConnector {
    private CapabilityReference<CapabilityRedstoneNetwork.RedstoneBundleConnection> attached = CapabilityReference.forTileEntity(this, () -> new DirectionalBlockPos(this.field_174879_c.func_177972_a(this.getFacing()), this.getFacing().func_176734_d()), CapabilityRedstoneNetwork.REDSTONE_BUNDLE_CONNECTION);

    public ConnectorBundledTileEntity() {
        this((TileEntityType<? extends ConnectorBundledTileEntity>)((TileEntityType)IETileTypes.CONNECTOR_BUNDLED.get()));
    }

    public ConnectorBundledTileEntity(TileEntityType<? extends ConnectorBundledTileEntity> type) {
        super((TileEntityType<? extends ImmersiveConnectableTileEntity>)type);
    }

    public void func_73660_a() {
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K && this.attached.isPresent() && this.attached.get().pollDirty()) {
            this.globalNet.getLocalNet(this.field_174879_c).getHandler(RedstoneNetworkHandler.ID, RedstoneNetworkHandler.class).updateValues();
        }
    }

    @Override
    public void onChange(ConnectionPoint cp, RedstoneNetworkHandler handler) {
        if (!this.field_145850_b.field_72995_K && this.attached.isPresent()) {
            this.attached.get().onChange(cp, handler, this.getFacing().func_176734_d());
        }
    }

    @Override
    public void updateInput(byte[] signals, ConnectionPoint cp) {
        if (this.attached.isPresent()) {
            this.attached.get().updateInput(signals, cp, this.getFacing().func_176734_d());
        }
    }

    @Override
    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vector3i offset) {
        return "REDSTONE".equals(cableType.getCategory());
    }

    @Override
    public EnumProperty<Direction> getFacingProperty() {
        return MiscConnectorBlock.DEFAULT_FACING_PROP;
    }

    @Override
    public IEBlockInterfaces.IDirectionalTile.PlacementLimitation getFacingLimitation() {
        return IEBlockInterfaces.IDirectionalTile.PlacementLimitation.SIDE_CLICKED;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return true;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vector3d hit, LivingEntity entity) {
        return false;
    }

    @Override
    public boolean canRotate(Direction axis) {
        return false;
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
    }

    @Override
    public Vector3d getConnectionOffset(@Nonnull Connection con, ConnectionPoint here) {
        Direction side = this.getFacing().func_176734_d();
        double conRadius = con.type.getRenderDiameter() / 2.0;
        return new Vector3d(0.5 - conRadius * (double)side.func_82601_c(), 0.5 - conRadius * (double)side.func_96559_d(), 0.5 - conRadius * (double)side.func_82599_e());
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable ISelectionContext ctx) {
        float length = 0.625f;
        float wMin = 0.3125f;
        return EnergyConnectorTileEntity.getConnectorBounds(this.getFacing(), wMin, length);
    }

    @Override
    public Collection<ResourceLocation> getRequestedHandlers() {
        return ImmutableList.of((Object)RedstoneNetworkHandler.ID);
    }
}

