/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.ImmersiveConnectableTileEntity;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.redstone.IRedstoneConnector;
import blusunrize.immersiveengineering.api.wires.redstone.RedstoneNetworkHandler;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.MiscConnectorBlock;
import blusunrize.immersiveengineering.common.blocks.metal.EnergyConnectorTileEntity;
import blusunrize.immersiveengineering.common.util.SafeChunkUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.EnumProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ConnectorRedstoneTileEntity
extends ImmersiveConnectableTileEntity
implements ITickableTileEntity,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IRedstoneOutput,
IEBlockInterfaces.IScrewdriverInteraction,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IBlockOverlayText,
IOBJModelCallback<BlockState>,
IRedstoneConnector {
    public IEEnums.IOSideConfig ioMode = IEEnums.IOSideConfig.INPUT;
    public DyeColor redstoneChannel = DyeColor.WHITE;
    public boolean rsDirty = false;
    private int output;

    public ConnectorRedstoneTileEntity() {
        this((TileEntityType<? extends ConnectorRedstoneTileEntity>)((TileEntityType)IETileTypes.CONNECTOR_REDSTONE.get()));
    }

    public ConnectorRedstoneTileEntity(TileEntityType<? extends ConnectorRedstoneTileEntity> type) {
        super((TileEntityType<? extends ImmersiveConnectableTileEntity>)type);
    }

    public void func_73660_a() {
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K && this.rsDirty) {
            this.globalNet.getLocalNet(this.field_174879_c).getHandler(RedstoneNetworkHandler.ID, RedstoneNetworkHandler.class).updateValues();
        }
    }

    @Override
    public int getStrongRSOutput(@Nonnull Direction side) {
        if (!this.isRSOutput() || side != this.getFacing().func_176734_d()) {
            return 0;
        }
        return this.output;
    }

    @Override
    public int getWeakRSOutput(@Nonnull Direction side) {
        if (!this.isRSOutput()) {
            return 0;
        }
        return this.output;
    }

    @Override
    public boolean canConnectRedstone(@Nonnull Direction side) {
        return true;
    }

    @Override
    public void onChange(ConnectionPoint cp, RedstoneNetworkHandler handler) {
        if (!this.field_145850_b.field_72995_K && SafeChunkUtils.isChunkSafe((IWorld)this.field_145850_b, this.field_174879_c)) {
            this.output = handler.getValue(this.redstoneChannel.func_196059_a());
            if (!this.func_145837_r() && this.isRSOutput()) {
                this.func_70296_d();
                BlockState stateHere = this.field_145850_b.func_180495_p(this.field_174879_c);
                this.markContainingBlockForUpdate(stateHere);
                this.markBlockForUpdate(this.field_174879_c.func_177972_a(this.getFacing()), this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(this.getFacing())));
            }
        }
    }

    public boolean isRSInput() {
        return this.ioMode == IEEnums.IOSideConfig.INPUT;
    }

    @Override
    public void updateInput(byte[] signals, ConnectionPoint cp) {
        if (this.isRSInput()) {
            signals[this.redstoneChannel.func_196059_a()] = (byte)Math.max(this.getMaxRSInput(), signals[this.redstoneChannel.func_196059_a()]);
        }
        this.rsDirty = false;
    }

    public boolean isRSOutput() {
        return this.ioMode == IEEnums.IOSideConfig.OUTPUT;
    }

    @Override
    public ActionResultType screwdriverUseSide(Direction side, PlayerEntity player, Hand hand, Vector3d hitVec) {
        ImmersiveEngineering.proxy.openTileScreen(Lib.GUIID_RedstoneConnector, this);
        return ActionResultType.SUCCESS;
    }

    protected void updateAfterConfigure() {
        this.func_70296_d();
        this.globalNet.getLocalNet(this.field_174879_c).getHandler(RedstoneNetworkHandler.ID, RedstoneNetworkHandler.class).updateValues();
        this.markContainingBlockForUpdate(null);
        this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_195044_w().func_177230_c(), 254, 0);
    }

    @Override
    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vector3i offset) {
        return "REDSTONE".equals(cableType.getCategory());
    }

    @Override
    public EnumProperty<Direction> getFacingProperty() {
        return MiscConnectorBlock.DEFAULT_FACING_PROP;
    }

    @Override
    public IEBlockInterfaces.IDirectionalTile.PlacementLimitation getFacingLimitation() {
        return IEBlockInterfaces.IDirectionalTile.PlacementLimitation.SIDE_CLICKED;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return true;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vector3d hit, LivingEntity entity) {
        return false;
    }

    @Override
    public boolean canRotate(Direction axis) {
        return false;
    }

    @Override
    public void receiveMessageFromClient(CompoundNBT message) {
        if (message.func_74764_b("ioMode")) {
            this.ioMode = IEEnums.IOSideConfig.VALUES[message.func_74762_e("ioMode")];
        }
        if (message.func_74764_b("redstoneChannel")) {
            this.redstoneChannel = DyeColor.func_196056_a((int)message.func_74762_e("redstoneChannel"));
        }
        this.updateAfterConfigure();
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74768_a("ioMode", this.ioMode.ordinal());
        nbt.func_74768_a("redstoneChannel", this.redstoneChannel.func_196059_a());
        nbt.func_74768_a("output", this.output);
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.ioMode = IEEnums.IOSideConfig.VALUES[nbt.func_74762_e("ioMode")];
        this.redstoneChannel = DyeColor.func_196056_a((int)nbt.func_74762_e("redstoneChannel"));
        this.output = nbt.func_74762_e("output");
    }

    @Override
    public Vector3d getConnectionOffset(@Nonnull Connection con, ConnectionPoint here) {
        Direction side = this.getFacing().func_176734_d();
        double conRadius = con.type.getRenderDiameter() / 2.0;
        return new Vector3d(0.5 - conRadius * (double)side.func_82601_c(), 0.5 - conRadius * (double)side.func_96559_d(), 0.5 - conRadius * (double)side.func_82599_e());
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable ISelectionContext ctx) {
        float length = 0.625f;
        float wMin = 0.3125f;
        return EnergyConnectorTileEntity.getConnectorBounds(this.getFacing(), wMin, length);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRenderGroup(BlockState object, String group) {
        if ("io_out".equals(group)) {
            return this.ioMode == IEEnums.IOSideConfig.OUTPUT;
        }
        if ("io_in".equals(group)) {
            return this.ioMode == IEEnums.IOSideConfig.INPUT;
        }
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Vector4f getRenderColor(BlockState object, String group, Vector4f original) {
        if ("coloured".equals(group)) {
            float[] rgb = this.redstoneChannel.func_193349_f();
            return new Vector4f(rgb[0], rgb[1], rgb[2], 1.0f);
        }
        return original;
    }

    @Override
    public String getCacheKey(BlockState object) {
        return this.redstoneChannel + ";" + (Object)((Object)this.ioMode);
    }

    @Override
    public ITextComponent[] getOverlayText(PlayerEntity player, RayTraceResult mop, boolean hammer) {
        if (!Utils.isScrewdriver(player.func_184586_b(Hand.MAIN_HAND))) {
            return null;
        }
        return new ITextComponent[]{new TranslationTextComponent("desc.immersiveengineering.info.redstoneChannel", new Object[]{I18n.func_135052_a((String)("item.minecraft.firework_star." + this.redstoneChannel.func_176762_d()), (Object[])new Object[0])}), new TranslationTextComponent("desc.immersiveengineering.info.blockSide.io." + this.ioMode.func_176610_l())};
    }

    @Override
    public boolean useNixieFont(PlayerEntity player, RayTraceResult mop) {
        return false;
    }

    @Override
    public Collection<ResourceLocation> getRequestedHandlers() {
        return ImmutableList.of((Object)RedstoneNetworkHandler.ID);
    }

    @Override
    public void onNeighborBlockChange(BlockPos otherPos) {
        int oldRSIn = this.getMaxRSInput();
        super.onNeighborBlockChange(otherPos);
        if (this.isRSInput() && oldRSIn != this.getMaxRSInput()) {
            this.rsDirty = true;
        }
    }
}

