/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.energy.IRotationAcceptor;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.EnumProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class DynamoTileEntity
extends IEBaseTileEntity
implements EnergyHelper.IIEInternalFluxConnector,
IEBlockInterfaces.IStateBasedDirectional,
IRotationAcceptor {
    EnergyHelper.IEForgeEnergyWrapper wrapper = new EnergyHelper.IEForgeEnergyWrapper(this, null);

    public DynamoTileEntity() {
        super((TileEntityType<? extends TileEntity>)((TileEntityType)IETileTypes.DYNAMO.get()));
    }

    @Override
    public void inputRotation(double rotation, @Nonnull Direction side) {
        if (side != this.getFacing().func_176734_d()) {
            return;
        }
        int output = (int)((Double)IEServerConfig.MACHINES.dynamo_output.get() * rotation);
        for (Direction fd : Direction.field_199792_n) {
            BlockPos outputPos = this.func_174877_v().func_177972_a(fd);
            TileEntity te = Utils.getExistingTileEntity(this.field_145850_b, outputPos);
            output -= EnergyHelper.insertFlux((ICapabilityProvider)te, fd.func_176734_d(), output, false);
        }
    }

    @Override
    public EnumProperty<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public IEBlockInterfaces.IDirectionalTile.PlacementLimitation getFacingLimitation() {
        return IEBlockInterfaces.IDirectionalTile.PlacementLimitation.HORIZONTAL;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return true;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vector3d hit, LivingEntity entity) {
        return true;
    }

    @Override
    public boolean canRotate(Direction axis) {
        return true;
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
    }

    @Override
    @Nonnull
    public IEEnums.IOSideConfig getEnergySideConfig(@Nullable Direction facing) {
        return IEEnums.IOSideConfig.OUTPUT;
    }

    @Override
    public boolean canConnectEnergy(Direction from) {
        return true;
    }

    @Override
    public EnergyHelper.IEForgeEnergyWrapper getCapabilityWrapper(Direction facing) {
        return this.wrapper;
    }
}

