/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartTileEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public class LightningrodTileEntity
extends MultiblockPartTileEntity<LightningrodTileEntity>
implements EnergyHelper.IIEInternalFluxHandler,
IEBlockInterfaces.IBlockBounds {
    FluxStorage energyStorage;
    @Nullable
    private List<BlockPos> fenceNet;
    private int height;
    private EnergyHelper.IEForgeEnergyWrapper wrapper;

    public LightningrodTileEntity() {
        super(IEMultiblocks.LIGHTNING_ROD, (TileEntityType)IETileTypes.LIGHTNING_ROD.get(), false);
        this.energyStorage = new FluxStorage((Integer)IEServerConfig.MACHINES.lightning_output.get());
        this.fenceNet = null;
        this.wrapper = new EnergyHelper.IEForgeEnergyWrapper(this, null);
    }

    public void func_73660_a() {
        this.checkForNeedlessTicking();
        if (!this.field_145850_b.field_72995_K && this.formed && new BlockPos(1, 1, 1).equals((Object)this.posInMultiblock)) {
            if (this.energyStorage.getEnergyStored() > 0) {
                for (Direction f : Direction.field_176754_o) {
                    TileEntity tileEntity = Utils.getExistingTileEntity(this.field_145850_b, this.func_174877_v().func_177967_a(f, 2));
                    int output = EnergyHelper.insertFlux((ICapabilityProvider)tileEntity, f.func_176734_d(), this.energyStorage.getLimitExtract(), true);
                    output = this.energyStorage.extractEnergy(output, false);
                    EnergyHelper.insertFlux((ICapabilityProvider)tileEntity, f.func_176734_d(), output, false);
                }
            }
            if (this.field_145850_b.func_82737_E() % 256L == (long)((this.func_174877_v().func_177958_n() ^ this.func_174877_v().func_177952_p()) & 0xFF)) {
                this.fenceNet = null;
            }
            if (this.fenceNet == null) {
                this.fenceNet = this.getFenceNet();
            }
            if (this.fenceNet != null && this.fenceNet.size() > 0 && this.field_145850_b.func_82737_E() % 128L == (long)((this.func_174877_v().func_177958_n() ^ this.func_174877_v().func_177952_p()) & 0x7F) && (this.field_145850_b.func_72911_I() || this.field_145850_b.func_72896_J() && Utils.RAND.nextInt(10) == 0)) {
                int i = this.height + this.fenceNet.size();
                if (Utils.RAND.nextInt(4096 * this.field_145850_b.func_217301_I()) < i * (this.func_174877_v().func_177956_o() + i)) {
                    this.energyStorage.setEnergy((Integer)IEServerConfig.MACHINES.lightning_output.get());
                    BlockPos pos = this.fenceNet.get(Utils.RAND.nextInt(this.fenceNet.size()));
                    LightningBoltEntity lightningboltentity = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(this.field_145850_b);
                    lightningboltentity.func_233576_c_(Vector3d.func_237492_c_((Vector3i)pos));
                    lightningboltentity.func_233623_a_(true);
                    this.field_145850_b.func_217376_c((Entity)lightningboltentity);
                }
            }
        }
    }

    @Nullable
    private List<BlockPos> getFenceNet() {
        this.height = 0;
        boolean broken = false;
        BlockPos lastFence = null;
        for (int i = this.func_174877_v().func_177956_o() + 2; i < this.field_145850_b.func_217301_I() - 1; ++i) {
            BlockPos pos = new BlockPos(this.func_174877_v().func_177958_n(), i, this.func_174877_v().func_177952_p());
            if (!broken && this.isFence(pos)) {
                ++this.height;
                lastFence = pos;
                continue;
            }
            if (!this.field_145850_b.func_175623_d(pos)) {
                return null;
            }
            if (broken) continue;
            broken = true;
        }
        if (lastFence == null) {
            return null;
        }
        ArrayList<BlockPos> openList = new ArrayList<BlockPos>();
        ArrayList<BlockPos> closedList = new ArrayList<BlockPos>();
        openList.add(lastFence);
        while (!openList.isEmpty() && closedList.size() < 256) {
            BlockPos next = (BlockPos)openList.get(0);
            if (!closedList.contains(next) && this.isFence(next)) {
                closedList.add(next);
                openList.add(next.func_177972_a(Direction.WEST));
                openList.add(next.func_177972_a(Direction.EAST));
                openList.add(next.func_177972_a(Direction.NORTH));
                openList.add(next.func_177972_a(Direction.SOUTH));
                openList.add(next.func_177972_a(Direction.UP));
            }
            openList.remove(0);
        }
        return closedList;
    }

    private boolean isFence(BlockPos pos) {
        return Utils.isBlockAt(this.field_145850_b, pos, (Block)IEBlocks.MetalDecoration.steelFence);
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.energyStorage.readFromNBT(nbt);
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        this.energyStorage.writeToNBT(nbt);
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable ISelectionContext ctx) {
        if (new BlockPos(1, 2, 1).equals((Object)this.posInMultiblock)) {
            return VoxelShapes.func_197873_a((double)-0.125, (double)0.0, (double)-0.125, (double)1.125, (double)1.0, (double)1.125);
        }
        if (this.posInMultiblock.func_177958_n() == 1 && this.posInMultiblock.func_177952_p() == 1 || this.posInMultiblock.func_177956_o() < 2 && (this.posInMultiblock.func_177958_n() + this.posInMultiblock.func_177952_p()) % 2 == 1) {
            return VoxelShapes.func_197868_b();
        }
        if (this.posInMultiblock.func_177956_o() == 0) {
            return VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0);
        }
        float xMin = 0.0f;
        float xMax = 1.0f;
        float yMin = 0.0f;
        float yMax = 1.0f;
        float zMin = 0.0f;
        float zMax = 1.0f;
        if (this.posInMultiblock.func_177958_n() % 2 == 0 && this.posInMultiblock.func_177952_p() % 2 == 0) {
            Direction facing = this.getFacing();
            if (this.posInMultiblock.func_177956_o() < 2) {
                yMin = -0.5f;
                yMax = 1.25f;
                float f = (facing.func_176740_k() == Direction.Axis.X ? this.posInMultiblock.func_177952_p() < 2 ^ facing == Direction.EAST : this.posInMultiblock.func_177958_n() == 2 ^ facing == Direction.NORTH) ? 0.8125f : (xMin = 0.4375f);
                float f2 = (facing.func_176740_k() == Direction.Axis.X ? this.posInMultiblock.func_177952_p() == 2 ^ facing == Direction.EAST : this.posInMultiblock.func_177958_n() == 0 ^ facing == Direction.NORTH) ? 0.1875f : (xMax = 0.5625f);
                float f3 = (facing.func_176740_k() == Direction.Axis.X ? this.posInMultiblock.func_177958_n() == 2 ^ facing == Direction.EAST : this.posInMultiblock.func_177952_p() == 2 ^ facing == Direction.NORTH) ? 0.8125f : (zMin = 0.4375f);
                zMax = (facing.func_176740_k() == Direction.Axis.X ? this.posInMultiblock.func_177958_n() == 0 ^ facing == Direction.EAST : this.posInMultiblock.func_177952_p() < 2 ^ facing == Direction.NORTH) ? 0.1875f : 0.5625f;
            } else {
                yMin = 0.25f;
                yMax = 0.75f;
                float f = (facing.func_176740_k() == Direction.Axis.X ? this.posInMultiblock.func_177952_p() < 2 ^ facing == Direction.EAST : this.posInMultiblock.func_177958_n() == 2 ^ facing == Direction.NORTH) ? 1.0f : (xMin = 0.625f);
                float f4 = (facing.func_176740_k() == Direction.Axis.X ? this.posInMultiblock.func_177952_p() == 2 ^ facing == Direction.EAST : this.posInMultiblock.func_177958_n() == 0 ^ facing == Direction.NORTH) ? 0.0f : (xMax = 0.375f);
                float f5 = (facing.func_176740_k() == Direction.Axis.X ? this.posInMultiblock.func_177958_n() == 2 ^ facing == Direction.EAST : this.posInMultiblock.func_177952_p() == 2 ^ facing == Direction.NORTH) ? 1.0f : (zMin = 0.625f);
                zMax = (facing.func_176740_k() == Direction.Axis.X ? this.posInMultiblock.func_177958_n() == 0 ^ facing == Direction.EAST : this.posInMultiblock.func_177952_p() < 2 ^ facing == Direction.NORTH) ? 0.0f : 0.375f;
            }
        } else if (this.posInMultiblock.func_177956_o() >= 2) {
            yMin = 0.25f;
            yMax = 0.75f;
            xMin = this.offsetToMaster.func_177958_n() < 0 ? 0.375f : 0.0f;
            xMax = this.offsetToMaster.func_177958_n() > 0 ? 0.625f : 1.0f;
            zMin = this.offsetToMaster.func_177952_p() < 0 ? 0.375f : 0.0f;
            zMax = this.offsetToMaster.func_177952_p() > 0 ? 0.625f : 1.0f;
        }
        return VoxelShapes.func_197873_a((double)xMin, (double)yMin, (double)zMin, (double)xMax, (double)yMax, (double)zMax);
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(Direction side) {
        return new IFluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, Direction side, FluidStack resource) {
        return false;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, Direction side) {
        return false;
    }

    @Override
    @Nonnull
    public FluxStorage getFluxStorage() {
        LightningrodTileEntity master = (LightningrodTileEntity)this.master();
        if (master != null) {
            return master.energyStorage;
        }
        return this.energyStorage;
    }

    @Override
    @Nonnull
    public IEEnums.IOSideConfig getEnergySideConfig(@Nullable Direction facing) {
        return this.formed && this.isEnergyPos() ? IEEnums.IOSideConfig.OUTPUT : IEEnums.IOSideConfig.NONE;
    }

    @Override
    public EnergyHelper.IEForgeEnergyWrapper getCapabilityWrapper(Direction facing) {
        if (this.formed && this.isEnergyPos()) {
            return this.wrapper;
        }
        return null;
    }

    private boolean isEnergyPos() {
        return this.posInMultiblock.func_177956_o() == 1 && (this.posInMultiblock.func_177958_n() + this.posInMultiblock.func_177952_p()) % 2 == 1;
    }
}

