/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;

public class StructuralArmTileEntity
extends IEBaseTileEntity
implements IOBJModelCallback<BlockState>,
IEBlockInterfaces.IDirectionalTile,
IEBlockInterfaces.ICollisionBounds,
IEBlockInterfaces.ISelectionBounds,
IEBlockInterfaces.IBlockBounds {
    private int totalLength = 1;
    private int slopePosition = 0;
    private Direction facing = Direction.NORTH;
    private boolean onCeiling = false;
    private VoxelShape bounds = null;
    private static final Matrix4 SHRINK = new Matrix4();

    public StructuralArmTileEntity() {
        super((TileEntityType<? extends TileEntity>)((TileEntityType)IETileTypes.STRUCTURAL_ARM.get()));
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        int oldLength = this.totalLength;
        int oldPos = this.slopePosition;
        this.totalLength = nbt.func_74762_e("totalLength");
        this.slopePosition = nbt.func_74762_e("slopePosition");
        this.onCeiling = nbt.func_74767_n("onCeiling");
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K && (oldLength != this.totalLength || this.slopePosition != oldPos)) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            this.bounds = null;
        }
        this.facing = Direction.field_199792_n[nbt.func_74762_e("facing")];
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        nbt.func_74768_a("totalLength", this.totalLength);
        nbt.func_74768_a("slopePosition", this.slopePosition);
        nbt.func_74768_a("facing", this.facing.ordinal());
        nbt.func_74757_a("onCeiling", this.onCeiling);
    }

    @Override
    public void onNeighborBlockChange(BlockPos otherPos) {
        boolean atEnd;
        boolean positive;
        super.onNeighborBlockChange(otherPos);
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (otherPos.equals((Object)this.field_174879_c.func_177967_a(this.facing, 1))) {
            positive = true;
        } else if (otherPos.equals((Object)this.field_174879_c.func_177967_a(this.facing, -1))) {
            positive = false;
        } else {
            return;
        }
        StructuralArmTileEntity slope = null;
        TileEntity atOther = this.field_145850_b.func_175625_s(otherPos);
        if (atOther instanceof StructuralArmTileEntity) {
            StructuralArmTileEntity tmp = (StructuralArmTileEntity)atOther;
            BlockState stateHere = this.field_145850_b.func_180495_p(this.field_174879_c);
            BlockState stateThere = this.field_145850_b.func_180495_p(otherPos);
            if (tmp.facing == this.facing && stateHere.func_177230_c() == stateThere.func_177230_c() && tmp.onCeiling == this.onCeiling) {
                slope = (StructuralArmTileEntity)atOther;
            }
        }
        if ((atEnd = this.isAtEnd(positive)) == (slope == null)) {
            return;
        }
        if (slope == null) {
            int toEnd = this.blocksToEnd(positive);
            this.forEachSlopeBlockBeyond(positive, false, true, other -> {
                other.totalLength = toEnd - 1;
                if (positive) {
                    other.slopePosition -= this.slopePosition + 2;
                }
                other.bounds = null;
                this.updateNoNeighbours(other.field_174879_c);
            });
            this.forEachSlopeBlockBeyond(!positive, true, true, other -> {
                other.totalLength = this.totalLength - toEnd;
                if (!positive) {
                    other.slopePosition -= this.slopePosition;
                }
                other.bounds = null;
                this.updateNoNeighbours(other.field_174879_c);
            });
        } else {
            int oldLength = this.totalLength;
            if (!positive) {
                this.slopePosition += slope.totalLength;
            }
            this.totalLength += slope.totalLength;
            this.forEachSlopeBlockBeyond(positive, false, false, other -> {
                other.totalLength = this.totalLength;
                if (positive) {
                    other.slopePosition += oldLength;
                }
                other.bounds = null;
                this.updateNoNeighbours(other.field_174879_c);
            });
            this.forEachSlopeBlockBeyond(!positive, false, false, other -> {
                other.totalLength = this.totalLength;
                if (!positive) {
                    other.slopePosition += this.totalLength - oldLength;
                }
                other.bounds = null;
                this.updateNoNeighbours(other.field_174879_c);
            });
            this.bounds = null;
        }
        this.updateNoNeighbours(this.field_174879_c);
    }

    private boolean isAtEnd(boolean positive) {
        if (positive) {
            return this.slopePosition == this.totalLength - 1;
        }
        return this.slopePosition == 0;
    }

    private int blocksToEnd(boolean positive) {
        if (positive) {
            return this.totalLength - this.slopePosition - 1;
        }
        return this.slopePosition;
    }

    private void forEachSlopeBlockBeyond(boolean positive, boolean includeThis, boolean removing, Consumer<StructuralArmTileEntity> out) {
        if (positive) {
            for (int i = 1; i < this.totalLength - this.slopePosition; ++i) {
                this.acceptIfValid(i, removing, out);
            }
        } else {
            for (int i = -1; i >= -this.slopePosition; --i) {
                this.acceptIfValid(i, removing, out);
            }
        }
        if (includeThis) {
            out.accept(this);
        }
    }

    private void acceptIfValid(int offsetToHere, boolean removing, Consumer<StructuralArmTileEntity> out) {
        BlockPos posI = this.field_174879_c.func_177967_a(this.facing, offsetToHere);
        TileEntity teAtI = this.field_145850_b.func_175625_s(posI);
        if (teAtI instanceof StructuralArmTileEntity) {
            StructuralArmTileEntity slope = (StructuralArmTileEntity)teAtI;
            int offsetAtPos = this.slopePosition + offsetToHere;
            BlockState stateHere = this.field_145850_b.func_180495_p(this.field_174879_c);
            BlockState stateThere = this.field_145850_b.func_180495_p(posI);
            if ((!removing || slope.totalLength == this.totalLength && slope.slopePosition == offsetAtPos) && slope.onCeiling == this.onCeiling && stateHere.func_177230_c() == stateThere.func_177230_c() && slope.facing == this.facing) {
                out.accept(slope);
            }
        }
    }

    private void updateNoNeighbours(BlockPos pos) {
        BlockState state = this.field_145850_b.func_180495_p(pos);
        this.field_145850_b.func_184138_a(pos, state, state, 3);
    }

    @Override
    public Direction getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(Direction facing) {
        this.facing = facing;
        this.totalLength = 1;
        this.slopePosition = 0;
        this.bounds = null;
        if (this.field_145850_b != null) {
            this.field_145850_b.func_195593_d(this.field_174879_c, this.func_195044_w().func_177230_c());
        }
    }

    @Override
    public Direction getFacingForPlacement(LivingEntity placer, BlockPos pos, Direction side, float hitX, float hitY, float hitZ) {
        this.onCeiling = side == Direction.DOWN || side != Direction.UP && (double)hitY > 0.5;
        return IEBlockInterfaces.IDirectionalTile.super.getFacingForPlacement(placer, pos, side, hitX, hitY, hitZ);
    }

    @Override
    public IEBlockInterfaces.IDirectionalTile.PlacementLimitation getFacingLimitation() {
        return IEBlockInterfaces.IDirectionalTile.PlacementLimitation.HORIZONTAL;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vector3d hit, LivingEntity entity) {
        return side.func_176740_k() == Direction.Axis.Y;
    }

    @Override
    public boolean canRotate(Direction axis) {
        return axis.func_176740_k() == Direction.Axis.Y;
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable ISelectionContext ctx) {
        if (this.bounds == null) {
            double lowerH = ((double)this.slopePosition + 0.5) / (double)this.totalLength;
            double upperH = ((double)this.slopePosition + 1.0) / (double)this.totalLength;
            ImmutableList basic = !this.onCeiling ? ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, lowerH, 1.0), (Object)new AxisAlignedBB(0.0, lowerH, 0.0, 1.0, upperH, 0.5)) : ImmutableList.of((Object)new AxisAlignedBB(0.0, 1.0 - lowerH, 0.0, 1.0, 1.0, 1.0), (Object)new AxisAlignedBB(0.0, 1.0 - upperH, 0.0, 1.0, 1.0 - lowerH, 0.5));
            this.bounds = VoxelShapes.func_197880_a();
            for (AxisAlignedBB aabb : basic) {
                AxisAlignedBB transformed = Utils.transformAABB(aabb, this.facing);
                VoxelShape subShape = VoxelShapes.func_197881_a((AxisAlignedBB)transformed);
                this.bounds = VoxelShapes.func_197882_b((VoxelShape)this.bounds, (VoxelShape)subShape, (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
            this.bounds = this.bounds.func_197753_c();
        }
        return this.bounds;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<BakedQuad> modifyQuads(BlockState object, List<BakedQuad> quads) {
        float lowerHeight = (float)this.slopePosition / (float)this.totalLength;
        float upperHeight = ((float)this.slopePosition + 1.0f) / (float)this.totalLength;
        double lowerV = 16.0f * lowerHeight;
        double upperV = 16.0f * upperHeight;
        TextureAtlasSprite tas = quads.get(0).func_187508_a();
        VertexFormat format = DefaultVertexFormats.field_176600_a;
        quads = new ArrayList<BakedQuad>();
        Matrix4 mat = new Matrix4(this.facing);
        float y03 = this.onCeiling ? 1.0f : upperHeight;
        float y12 = this.onCeiling ? 1.0f : lowerHeight;
        float y47 = this.onCeiling ? 1.0f - upperHeight : 0.0f;
        float y56 = this.onCeiling ? 1.0f - lowerHeight : 0.0f;
        Vector3d[] vertices = new Vector3d[]{new Vector3d(0.0, (double)y03, 0.0), new Vector3d(0.0, (double)y12, 1.0), new Vector3d(1.0, (double)y12, 1.0), new Vector3d(1.0, (double)y03, 0.0), new Vector3d(0.0, (double)y47, 0.0), new Vector3d(0.0, (double)y56, 1.0), new Vector3d(1.0, (double)y56, 1.0), new Vector3d(1.0, (double)y47, 0.0)};
        for (int i = 0; i < vertices.length; ++i) {
            vertices[i] = mat.apply(vertices[i]);
        }
        this.addCulledQuad(quads, format, Arrays.copyOf(vertices, 4), Direction.UP, tas, new double[]{0.0, 0.0, 16.0, 16.0}, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
        this.addCulledQuad(quads, format, this.getArrayByIndices(vertices, 7, 6, 5, 4), Direction.DOWN, tas, new double[]{0.0, 0.0, 16.0, 16.0}, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
        this.addSides(quads, vertices, tas, lowerV, upperV, false);
        this.addSides(quads, vertices, tas, lowerV, upperV, true);
        if (this.isAtEnd(true)) {
            this.addCulledQuad(quads, format, this.getArrayByIndices(vertices, 0, 3, 7, 4), Direction.NORTH, tas, new double[]{0.0, 0.0, 16.0, 16.0}, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
        }
        return quads;
    }

    private void addCulledQuad(List<BakedQuad> quads, VertexFormat format, Vector3d[] vertices, Direction side, TextureAtlasSprite tas, double[] uvs, float[] alpha) {
        side = Utils.rotateFacingTowardsDir(side, this.facing);
        quads.add(ClientUtils.createBakedQuad(format, vertices, side, tas, uvs, alpha, false));
        for (int i = 0; i < vertices.length; ++i) {
            vertices[i] = SHRINK.apply(vertices[i]);
        }
        quads.add(ClientUtils.createBakedQuad(format, vertices, side.func_176734_d(), tas, uvs, alpha, true));
    }

    private void addSides(List<BakedQuad> quads, Vector3d[] vertices, TextureAtlasSprite tas, double lowerV, double upperV, boolean invert) {
        if (invert) {
            for (int i = 0; i < vertices.length; ++i) {
                vertices[i] = SHRINK.apply(vertices[i]);
            }
        }
        quads.add(this.createSide(DefaultVertexFormats.field_176600_a, this.getArrayByIndices(vertices, 5, 1, 0, 4), Direction.WEST, tas, lowerV, upperV, invert));
        quads.add(this.createSide(DefaultVertexFormats.field_176600_a, this.getArrayByIndices(vertices, 7, 3, 2, 6), Direction.EAST, tas, upperV, lowerV, invert));
    }

    @OnlyIn(value=Dist.CLIENT)
    private BakedQuad createSide(VertexFormat format, Vector3d[] vertices, Direction facing, TextureAtlasSprite sprite, double leftV, double rightV, boolean invert) {
        facing = Utils.rotateFacingTowardsDir(facing, this.facing);
        if (invert) {
            double tmp = leftV;
            leftV = rightV;
            rightV = tmp;
        }
        if (invert) {
            facing = facing.func_176734_d();
        }
        float[] colour = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        BakedQuadBuilder builder = new BakedQuadBuilder(sprite);
        builder.setQuadOrientation(facing);
        Vector3d faceNormal = Vector3d.func_237491_b_((Vector3i)facing.func_176730_m());
        int vertexId = invert ? 3 : 0;
        double v = this.onCeiling ? 16.0 - leftV : 0.0;
        ClientUtils.putVertexData(format, builder, vertices[vertexId], faceNormal, vertexId > 1 ? 16.0 : 0.0, v, sprite, colour, 1.0f);
        vertexId = invert ? 2 : 1;
        v = this.onCeiling ? 16.0 : leftV;
        ClientUtils.putVertexData(format, builder, vertices[vertexId], faceNormal, vertexId > 1 ? 16.0 : 0.0, v, sprite, colour, 1.0f);
        vertexId = invert ? 1 : 2;
        v = this.onCeiling ? 16.0 : rightV;
        ClientUtils.putVertexData(format, builder, vertices[vertexId], faceNormal, vertexId > 1 ? 16.0 : 0.0, v, sprite, colour, 1.0f);
        vertexId = invert ? 0 : 3;
        v = this.onCeiling ? 16.0 - rightV : 0.0;
        ClientUtils.putVertexData(format, builder, vertices[vertexId], faceNormal, vertexId > 1 ? 16.0 : 0.0, v, sprite, colour, 1.0f);
        return builder.build();
    }

    private Vector3d[] getArrayByIndices(Vector3d[] in, int ... indices) {
        Vector3d[] ret = new Vector3d[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            ret[i] = in[indices[i]];
        }
        return ret;
    }

    @Override
    public String getCacheKey(BlockState object) {
        return this.totalLength + "," + this.slopePosition + "," + this.facing.name() + "," + (this.onCeiling ? "1" : "0");
    }

    static {
        SHRINK.translate(0.5, 0.5, 0.5);
        SHRINK.scale(0.999, 0.999, 0.999);
        SHRINK.translate(-0.5, -0.5, -0.5);
    }
}

