/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.IModelOffsetProvider;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.api.tool.IElectricEquipment;
import blusunrize.immersiveengineering.api.tool.ITeslaEntity;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.network.MessageTileSync;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.DirectionUtils;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.IEPotions;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;

public class TeslaCoilTileEntity
extends IEBaseTileEntity
implements ITickableTileEntity,
EnergyHelper.IIEInternalFluxHandler,
IEBlockInterfaces.IHasDummyBlocks,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IScrewdriverInteraction,
IModelOffsetProvider {
    public FluxStorage energyStorage = new FluxStorage(48000);
    public boolean redstoneControlInverted = false;
    public boolean lowPower = false;
    private Vector3d soundPos = null;
    @OnlyIn(value=Dist.CLIENT)
    public static ArrayListMultimap<BlockPos, LightningAnimation> effectMap;
    private static final IElectricEquipment.ElectricSource TC_FIELD;
    AxisAlignedBB renderBB;
    EnergyHelper.IEForgeEnergyWrapper[] wrappers = EnergyHelper.IEForgeEnergyWrapper.getDefaultWrapperArray(this);

    public TeslaCoilTileEntity() {
        super((TileEntityType<? extends TileEntity>)((TileEntityType)IETileTypes.TESLACOIL.get()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_73660_a() {
        this.checkForNeedlessTicking();
        if (this.isDummy()) {
            return;
        }
        TeslaCoilTileEntity teslaCoilTileEntity = this;
        synchronized (teslaCoilTileEntity) {
            if (this.field_145850_b.field_72995_K && this.soundPos != null) {
                this.field_145850_b.func_184134_a(this.soundPos.field_72450_a, this.soundPos.field_72448_b, this.soundPos.field_72449_c, IESounds.tesla, SoundCategory.BLOCKS, 2.5f, 0.5f + Utils.RAND.nextFloat(), true);
                this.soundPos = null;
            }
        }
        if (this.field_145850_b.field_72995_K && effectMap.containsKey((Object)this.field_174879_c)) {
            effectMap.get((Object)this.field_174879_c).removeIf(LightningAnimation::tick);
        }
        int timeKey = this.func_174877_v().func_177958_n() ^ this.func_174877_v().func_177952_p();
        int energyDrain = (Integer)IEServerConfig.MACHINES.teslacoil_consumption.get();
        if (this.lowPower) {
            energyDrain /= 2;
        }
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 32L == (long)(timeKey & 0x1F) && this.canRun(energyDrain)) {
            this.energyStorage.extractEnergy(energyDrain, false);
            double radius = 6.0;
            if (this.lowPower) {
                radius /= 2.0;
            }
            AxisAlignedBB aabbSmall = new AxisAlignedBB((double)this.func_174877_v().func_177958_n() + 0.5 - radius, (double)this.func_174877_v().func_177956_o() + 0.5 - radius, (double)this.func_174877_v().func_177952_p() + 0.5 - radius, (double)this.func_174877_v().func_177958_n() + 0.5 + radius, (double)this.func_174877_v().func_177956_o() + 0.5 + radius, (double)this.func_174877_v().func_177952_p() + 0.5 + radius);
            AxisAlignedBB aabb = aabbSmall.func_186662_g(radius / 2.0);
            List targetsAll = this.field_145850_b.func_217357_a(Entity.class, aabb);
            List targets = targetsAll.stream().filter(e -> e instanceof LivingEntity && aabbSmall.func_72326_a(e.func_174813_aQ())).collect(Collectors.toList());
            LivingEntity target = null;
            if (!targets.isEmpty()) {
                IEDamageSources.ElectricDamageSource dmgsrc = IEDamageSources.causeTeslaDamage(((Double)IEServerConfig.MACHINES.teslacoil_damage.get()).floatValue(), this.lowPower);
                int randomTarget = Utils.RAND.nextInt(targets.size());
                target = (LivingEntity)targets.get(randomTarget);
                if (target != null && !this.field_145850_b.field_72995_K) {
                    energyDrain = (Integer)IEServerConfig.MACHINES.teslacoil_consumption_active.get();
                    if (this.lowPower) {
                        energyDrain /= 2;
                    }
                    if (this.energyStorage.extractEnergy(energyDrain, true) == energyDrain) {
                        this.energyStorage.extractEnergy(energyDrain, false);
                        if (dmgsrc.apply((Entity)target)) {
                            int prevFire = target.field_190534_ay;
                            target.field_190534_ay = 1;
                            target.func_195064_c(new EffectInstance(IEPotions.stunned, 128));
                            target.field_190534_ay = prevFire;
                        }
                        this.sendRenderPacket((Entity)target);
                    }
                }
            }
            for (Entity e2 : targetsAll) {
                if (e2 == target) continue;
                if (e2 instanceof ITeslaEntity) {
                    ((ITeslaEntity)e2).onHit(this, this.lowPower);
                    continue;
                }
                if (!(e2 instanceof LivingEntity)) continue;
                IElectricEquipment.applyToEntity((LivingEntity)e2, null, TC_FIELD);
            }
            if (targets.isEmpty() && this.field_145850_b.func_82737_E() % 128L == (long)(timeKey & 0x7F)) {
                double tV = (Utils.RAND.nextDouble() - 0.5) * 8.0;
                double tH = (Utils.RAND.nextDouble() - 0.5) * 8.0;
                if (this.lowPower) {
                    tV /= 2.0;
                    tH /= 2.0;
                }
                BlockPos targetBlock = this.func_174877_v().func_177963_a(this.getFacing().func_176740_k() == Direction.Axis.X ? 0.0 : (tH += tH < 0.0 ? -2.0 : 2.0), this.getFacing().func_176740_k() == Direction.Axis.Y ? 0.0 : (tV += tV < 0.0 ? -2.0 : 2.0), this.getFacing().func_176740_k() == Direction.Axis.Y ? tV : (this.getFacing().func_176740_k() == Direction.Axis.X ? tH : 0.0));
                double tL = 0.0;
                boolean targetFound = false;
                if (!this.field_145850_b.func_175623_d(targetBlock)) {
                    BlockState state = this.field_145850_b.func_180495_p(targetBlock);
                    AxisAlignedBB blockBounds = state.func_196954_c((IBlockReader)this.field_145850_b, targetBlock).func_197752_a();
                    tL = this.getFacing() == Direction.UP ? (double)(targetBlock.func_177956_o() - this.func_174877_v().func_177956_o()) + blockBounds.field_72337_e : (this.getFacing() == Direction.DOWN ? (double)(targetBlock.func_177956_o() - this.func_174877_v().func_177956_o()) + blockBounds.field_72338_b : (this.getFacing() == Direction.NORTH ? (double)(targetBlock.func_177952_p() - this.func_174877_v().func_177952_p()) + blockBounds.field_72339_c : (this.getFacing() == Direction.SOUTH ? (double)(targetBlock.func_177952_p() - this.func_174877_v().func_177952_p()) + blockBounds.field_72334_f : (this.getFacing() == Direction.WEST ? (double)(targetBlock.func_177958_n() - this.func_174877_v().func_177958_n()) + blockBounds.field_72340_a : (double)(targetBlock.func_177958_n() - this.func_174877_v().func_177958_n()) + blockBounds.field_72336_d))));
                    targetFound = true;
                } else {
                    boolean positiveFirst = Utils.RAND.nextBoolean();
                    for (int i = 0; i < 2; ++i) {
                        for (int ll = 0; ll <= 6; ++ll) {
                            Direction tempF;
                            BlockState state;
                            VoxelShape shape;
                            BlockPos targetBlock2 = targetBlock.func_177967_a(positiveFirst ? this.getFacing() : this.getFacing().func_176734_d(), ll);
                            if (this.field_145850_b.func_175623_d(targetBlock2) || (shape = (state = this.field_145850_b.func_180495_p(targetBlock2)).func_196954_c((IBlockReader)this.field_145850_b, targetBlock2)).func_197766_b()) continue;
                            AxisAlignedBB blockBounds = shape.func_197752_a();
                            tL = this.getFacing().func_176740_k() == Direction.Axis.Y ? (double)(targetBlock2.func_177956_o() - this.func_174877_v().func_177956_o()) : (this.getFacing().func_176740_k() == Direction.Axis.Z ? (double)(targetBlock2.func_177952_p() - this.func_174877_v().func_177952_p()) : (double)(targetBlock2.func_177952_p() - this.func_174877_v().func_177952_p()));
                            Direction direction = tempF = positiveFirst ? this.getFacing() : this.getFacing().func_176734_d();
                            tL = tempF == Direction.UP ? (tL += blockBounds.field_72337_e) : (tempF == Direction.DOWN ? (tL += blockBounds.field_72338_b) : (tempF == Direction.NORTH ? (tL += blockBounds.field_72339_c) : (tempF == Direction.SOUTH ? (tL += blockBounds.field_72334_f) : (tempF == Direction.WEST ? (tL += blockBounds.field_72340_a) : (tL += blockBounds.field_72336_d)))));
                            targetFound = true;
                            break;
                        }
                        if (targetFound) break;
                        positiveFirst = !positiveFirst;
                    }
                }
                if (targetFound) {
                    this.sendFreePacket(tL, tH, tV);
                }
            }
            this.func_70296_d();
        }
    }

    protected void sendRenderPacket(Entity target) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a("targetEntity", target.func_145782_y());
        ImmersiveEngineering.packetHandler.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.field_145850_b.func_175726_f(this.field_174879_c)), (Object)new MessageTileSync(this, tag));
    }

    protected void sendFreePacket(double tL, double tH, double tV) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74780_a("tL", tL);
        tag.func_74780_a("tV", tV);
        tag.func_74780_a("tH", tH);
        ImmersiveEngineering.packetHandler.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.field_145850_b.func_175726_f(this.field_174879_c)), (Object)new MessageTileSync(this, tag));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveMessageFromServer(CompoundNBT message) {
        if (message.func_150297_b("targetEntity", 3)) {
            Entity target = this.field_145850_b.func_73045_a(message.func_74762_e("targetEntity"));
            if (target instanceof LivingEntity) {
                double dx = target.func_226277_ct_() - (double)this.func_174877_v().func_177958_n();
                double dy = target.func_226278_cu_() - (double)this.func_174877_v().func_177956_o();
                double dz = target.func_226281_cx_() - (double)this.func_174877_v().func_177952_p();
                Direction f = null;
                f = this.getFacing().func_176740_k() == Direction.Axis.Y ? (Math.abs(dz) > Math.abs(dx) ? (dz < 0.0 ? Direction.NORTH : Direction.SOUTH) : (dx < 0.0 ? Direction.WEST : Direction.EAST)) : (this.getFacing().func_176740_k() == Direction.Axis.Z ? (Math.abs(dy) > Math.abs(dx) ? (dy < 0.0 ? Direction.DOWN : Direction.UP) : (dx < 0.0 ? Direction.WEST : Direction.EAST)) : (Math.abs(dy) > Math.abs(dz) ? (dy < 0.0 ? Direction.DOWN : Direction.UP) : (dz < 0.0 ? Direction.NORTH : Direction.SOUTH)));
                double verticalOffset = 1.0 + Utils.RAND.nextDouble() * 0.25;
                Vector3d coilPos = Vector3d.func_237489_a_((Vector3i)this.func_174877_v());
                coilPos = coilPos.func_72441_c((double)this.getFacing().func_82601_c() * verticalOffset, (double)this.getFacing().func_96559_d() * verticalOffset, (double)this.getFacing().func_82599_e() * verticalOffset);
                if (f != null) {
                    coilPos = coilPos.func_72441_c((double)f.func_82601_c() * 0.375, (double)f.func_96559_d() * 0.375, (double)f.func_82599_e() * 0.375);
                    f = DirectionUtils.rotateAround(f, this.getFacing().func_176740_k());
                    double dShift = (Utils.RAND.nextDouble() - 0.5) * 0.75;
                    coilPos = coilPos.func_72441_c((double)f.func_82601_c() * dShift, (double)f.func_96559_d() * dShift, (double)f.func_82599_e() * dShift);
                }
                this.addAnimation(new LightningAnimation(coilPos, (LivingEntity)target));
                TeslaCoilTileEntity teslaCoilTileEntity = this;
                synchronized (teslaCoilTileEntity) {
                    this.soundPos = coilPos;
                }
            }
        } else if (message.func_150297_b("tL", 6)) {
            this.initFreeStreamer(message.func_74769_h("tL"), message.func_74769_h("tV"), message.func_74769_h("tH"));
        }
    }

    public void initFreeStreamer(double tL, double tV, double tH) {
        double ty;
        double tx = this.getFacing().func_176740_k() == Direction.Axis.X ? tL : tH;
        double d = ty = this.getFacing().func_176740_k() == Direction.Axis.Y ? tL : tV;
        double tz = this.getFacing().func_176740_k() == Direction.Axis.Y ? tV : (this.getFacing().func_176740_k() == Direction.Axis.X ? tH : tL);
        Direction f = null;
        f = this.getFacing().func_176740_k() == Direction.Axis.Y ? (Math.abs(tz) > Math.abs(tx) ? (tz < 0.0 ? Direction.NORTH : Direction.SOUTH) : (tx < 0.0 ? Direction.WEST : Direction.EAST)) : (this.getFacing().func_176740_k() == Direction.Axis.Z ? (Math.abs(ty) > Math.abs(tx) ? (ty < 0.0 ? Direction.DOWN : Direction.UP) : (tx < 0.0 ? Direction.WEST : Direction.EAST)) : (Math.abs(ty) > Math.abs(tz) ? (ty < 0.0 ? Direction.DOWN : Direction.UP) : (tz < 0.0 ? Direction.NORTH : Direction.SOUTH)));
        double verticalOffset = 1.0 + Utils.RAND.nextDouble() * 0.25;
        Vector3d coilPos = Vector3d.func_237489_a_((Vector3i)this.func_174877_v());
        coilPos = coilPos.func_72441_c((double)this.getFacing().func_82601_c() * verticalOffset, (double)this.getFacing().func_96559_d() * verticalOffset, (double)this.getFacing().func_82599_e() * verticalOffset);
        coilPos = coilPos.func_72441_c((double)f.func_82601_c() * 0.375, (double)f.func_96559_d() * 0.375, (double)f.func_82599_e() * 0.375);
        f = DirectionUtils.rotateAround(f, this.getFacing().func_176740_k());
        double dShift = (Utils.RAND.nextDouble() - 0.5) * 0.75;
        coilPos = coilPos.func_72441_c((double)f.func_82601_c() * dShift, (double)f.func_96559_d() * dShift, (double)f.func_82599_e() * dShift);
        this.addAnimation(new LightningAnimation(coilPos, Vector3d.func_237491_b_((Vector3i)this.func_174877_v()).func_72441_c(tx, ty, tz)));
        this.field_145850_b.func_184134_a((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), IESounds.tesla, SoundCategory.BLOCKS, 2.5f, 0.5f + Utils.RAND.nextFloat(), true);
    }

    private void addAnimation(LightningAnimation ani) {
        Minecraft.func_71410_x().func_213165_a(() -> effectMap.put((Object)this.func_174877_v(), (Object)ani));
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        this.redstoneControlInverted = nbt.func_74767_n("redstoneInverted");
        this.lowPower = nbt.func_74767_n("lowPower");
        this.energyStorage.readFromNBT(nbt);
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        nbt.func_74757_a("redstoneInverted", this.redstoneControlInverted);
        nbt.func_74757_a("lowPower", this.lowPower);
        this.energyStorage.writeToNBT(nbt);
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable ISelectionContext ctx) {
        if (!this.isDummy()) {
            return VoxelShapes.func_197868_b();
        }
        switch (this.getFacing()) {
            case DOWN: {
                return VoxelShapes.func_197873_a((double)0.125, (double)0.125, (double)0.125, (double)0.875, (double)1.0, (double)0.875);
            }
            case UP: {
                return VoxelShapes.func_197873_a((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.875, (double)0.875);
            }
            case NORTH: {
                return VoxelShapes.func_197873_a((double)0.125, (double)0.125, (double)0.125, (double)0.875, (double)0.875, (double)1.0);
            }
            case SOUTH: {
                return VoxelShapes.func_197873_a((double)0.125, (double)0.125, (double)0.0, (double)0.875, (double)0.875, (double)0.875);
            }
            case WEST: {
                return VoxelShapes.func_197873_a((double)0.125, (double)0.125, (double)0.125, (double)1.0, (double)0.875, (double)0.875);
            }
            case EAST: {
                return VoxelShapes.func_197873_a((double)0.0, (double)0.125, (double)0.125, (double)0.875, (double)0.875, (double)0.875);
            }
        }
        return VoxelShapes.func_197868_b();
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderBB == null) {
            this.renderBB = new AxisAlignedBB(this.func_174877_v().func_177982_a(-8, -8, -8), this.func_174877_v().func_177982_a(8, 8, 8));
        }
        return this.renderBB;
    }

    @Override
    public ActionResultType screwdriverUseSide(Direction side, PlayerEntity player, Hand hand, Vector3d hitVec) {
        if (this.isDummy()) {
            TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177967_a(this.getFacing(), -1));
            if (te instanceof TeslaCoilTileEntity) {
                return ((TeslaCoilTileEntity)te).screwdriverUseSide(side, player, hand, hitVec);
            }
            return ActionResultType.PASS;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (player.func_225608_bj_()) {
                int energyDrain = (Integer)IEServerConfig.MACHINES.teslacoil_consumption.get();
                if (this.lowPower) {
                    energyDrain /= 2;
                }
                if (this.canRun(energyDrain)) {
                    player.func_70097_a(IEDamageSources.causeTeslaPrimaryDamage(), Float.MAX_VALUE);
                } else {
                    this.lowPower = !this.lowPower;
                    ChatUtils.sendServerNoSpamMessages(player, new ITextComponent[]{new TranslationTextComponent("chat.immersiveengineering.info.tesla." + (this.lowPower ? "lowPower" : "highPower"))});
                    this.func_70296_d();
                }
            } else {
                this.redstoneControlInverted = !this.redstoneControlInverted;
                ChatUtils.sendServerNoSpamMessages(player, new ITextComponent[]{new TranslationTextComponent("chat.immersiveengineering.info.rsControl." + (this.redstoneControlInverted ? "invertedOn" : "invertedOff"))});
                this.func_70296_d();
                this.markContainingBlockForUpdate(null);
            }
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public EnumProperty<Direction> getFacingProperty() {
        return IEProperties.FACING_ALL;
    }

    @Override
    public IEBlockInterfaces.IDirectionalTile.PlacementLimitation getFacingLimitation() {
        return IEBlockInterfaces.IDirectionalTile.PlacementLimitation.SIDE_CLICKED;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vector3d hit, LivingEntity entity) {
        return false;
    }

    @Override
    public boolean canRotate(Direction axis) {
        return false;
    }

    @Override
    @Nullable
    public IEBlockInterfaces.IGeneralMultiblock master() {
        if (!this.isDummy()) {
            return this;
        }
        BlockPos masterPos = this.func_174877_v().func_177977_b();
        TileEntity te = Utils.getExistingTileEntity(this.field_145850_b, masterPos);
        return this.getClass().isInstance(te) ? (IEBlockInterfaces.IGeneralMultiblock)te : null;
    }

    @Override
    public void placeDummies(BlockItemUseContext ctx, BlockState state) {
        this.field_145850_b.func_175656_a(this.field_174879_c.func_177972_a(this.getFacing()), (BlockState)state.func_206870_a((Property)IEProperties.MULTIBLOCKSLAVE, (Comparable)Boolean.valueOf(true)));
        ((TeslaCoilTileEntity)this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.getFacing()))).setFacing(this.getFacing());
    }

    @Override
    public void breakDummies(BlockPos pos, BlockState state) {
        boolean dummy = this.isDummy();
        for (int i = 0; i <= 1; ++i) {
            if (!(this.field_145850_b.func_175625_s(this.func_174877_v().func_177967_a(this.getFacing(), dummy ? -1 : 0).func_177967_a(this.getFacing(), i)) instanceof TeslaCoilTileEntity)) continue;
            this.field_145850_b.func_217377_a(this.func_174877_v().func_177967_a(this.getFacing(), dummy ? -1 : 0).func_177967_a(this.getFacing(), i), false);
        }
    }

    @Override
    @Nonnull
    public FluxStorage getFluxStorage() {
        TileEntity te;
        if (this.isDummy() && (te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177967_a(this.getFacing(), -1))) instanceof TeslaCoilTileEntity) {
            return ((TeslaCoilTileEntity)te).getFluxStorage();
        }
        return this.energyStorage;
    }

    @Override
    @Nonnull
    public IEEnums.IOSideConfig getEnergySideConfig(Direction facing) {
        return !this.isDummy() ? IEEnums.IOSideConfig.INPUT : IEEnums.IOSideConfig.NONE;
    }

    @Override
    public EnergyHelper.IEForgeEnergyWrapper getCapabilityWrapper(Direction facing) {
        if (!this.isDummy()) {
            return this.wrappers[facing == null ? 0 : facing.ordinal()];
        }
        return null;
    }

    public boolean canRun(int energyDrain) {
        return this.isRSPowered() ^ this.redstoneControlInverted && this.energyStorage.getEnergyStored() >= energyDrain;
    }

    @Override
    public BlockPos getModelOffset(BlockState state) {
        if (this.isDummy()) {
            return new BlockPos(0, 0, -1);
        }
        return BlockPos.field_177992_a;
    }

    static {
        TC_FIELD = new IElectricEquipment.ElectricSource(-1.0f);
    }

    public static class LightningAnimation {
        public Vector3d startPos;
        public LivingEntity targetEntity;
        public Vector3d targetPos;
        private int lifeTimer = 20;
        private final int ANIMATION_MAX = 4;
        private int animationTimer = 4;
        public List<Vector3d> subPoints = new ArrayList<Vector3d>();
        private Vector3d prevTarget;

        public LightningAnimation(Vector3d startPos, LivingEntity targetEntity) {
            this.startPos = startPos;
            this.targetEntity = targetEntity;
        }

        public LightningAnimation(Vector3d startPos, Vector3d targetPos) {
            this.startPos = startPos;
            this.targetPos = targetPos;
        }

        public boolean shoudlRecalculateLightning() {
            Vector3d end;
            if (this.subPoints.isEmpty() || this.animationTimer == 0) {
                return true;
            }
            boolean b = false;
            Vector3d vector3d = end = this.targetEntity != null ? this.targetEntity.func_213303_ch() : this.targetPos;
            if (this.prevTarget != null) {
                b = this.prevTarget.func_72438_d(end) > 1.0;
            }
            this.prevTarget = end;
            return b;
        }

        public void createLightning(Random rand) {
            this.subPoints.clear();
            Vector3d end = this.targetEntity != null ? this.targetEntity.func_213303_ch() : this.targetPos;
            Vector3d dist = end.func_178788_d(this.startPos);
            double points = 12.0;
            int i = 0;
            while ((double)i < points) {
                Vector3d sub = this.startPos.func_72441_c(dist.field_72450_a / points * (double)i, dist.field_72448_b / points * (double)i, dist.field_72449_c / points * (double)i);
                double fixPointDist = ((double)i - points / 2.0) / (points / 2.0);
                double mod = 1.0 - 0.75 * Math.abs(fixPointDist);
                double offX = (rand.nextDouble() - 0.5) * mod;
                double offY = (rand.nextDouble() - 0.5) * mod;
                double offZ = (rand.nextDouble() - 0.5) * mod;
                if (fixPointDist < 0.0) {
                    offY += 0.75 * mod * (0.75 + fixPointDist);
                    offX = sub.field_72450_a - this.startPos.field_72450_a < 0.0 ? -Math.abs(offX) : Math.abs(offX);
                    offZ = sub.field_72449_c - this.startPos.field_72449_c < 0.0 ? -Math.abs(offZ) : Math.abs(offZ);
                } else {
                    offY = Math.min(end.field_72448_b + 1.0 * (1.0 - fixPointDist) * -Math.signum(dist.field_72448_b), offY);
                    offX = Math.abs(offX) * (end.field_72450_a - sub.field_72450_a);
                    offZ = Math.abs(offZ) * (end.field_72449_c - sub.field_72449_c);
                }
                this.subPoints.add(sub.func_72441_c(offX, offY, offZ));
                ++i;
            }
            this.animationTimer = 4 + Utils.RAND.nextInt(5) - 2;
        }

        public boolean tick() {
            --this.animationTimer;
            --this.lifeTimer;
            return this.lifeTimer <= 0;
        }
    }
}

