/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.metal.TurretTileEntity;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.entities.RevolvershotEntity;
import blusunrize.immersiveengineering.common.items.BulletItem;
import blusunrize.immersiveengineering.common.network.MessageTileSync;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TurretGunTileEntity
extends TurretTileEntity {
    public int cycleRender;
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    public boolean expelCasings = false;
    private LazyOptional<IItemHandler> itemHandler = this.registerConstantCap(new IEInventoryHandler(2, (IIEInventory)this, 0, new boolean[]{true, false}, new boolean[]{false, true}));

    public TurretGunTileEntity() {
        super((TileEntityType<? extends TurretTileEntity>)((TileEntityType)IETileTypes.TURRET_GUN.get()));
    }

    @Override
    protected double getRange() {
        return 16.0;
    }

    @Override
    protected boolean canActivate() {
        return this.energyStorage.getEnergyStored() >= (Integer)IEServerConfig.MACHINES.turret_gun_consumption.get() && !((ItemStack)this.inventory.get(0)).func_190926_b();
    }

    @Override
    protected int getChargeupTicks() {
        return 5;
    }

    @Override
    protected int getActiveTicks() {
        return 5;
    }

    @Override
    protected boolean loopActivation() {
        return false;
    }

    @Override
    protected void activate() {
        BulletHandler.IBullet bullet;
        int energy = (Integer)IEServerConfig.MACHINES.turret_gun_consumption.get();
        ItemStack bulletStack = (ItemStack)this.inventory.get(0);
        if (!bulletStack.func_190926_b() && this.energyStorage.extractEnergy(energy, true) == energy && (bullet = ((BulletItem)bulletStack.func_77973_b()).getType()) != null && bullet.isValidForTurret()) {
            ItemStack casing = bullet.getCasing(bulletStack);
            if (this.expelCasings || casing.func_190926_b() || ((ItemStack)this.inventory.get(1)).func_190926_b() || ItemStack.func_179545_c((ItemStack)casing, (ItemStack)((ItemStack)this.inventory.get(1))) && ((ItemStack)this.inventory.get(1)).func_190916_E() + casing.func_190916_E() <= ((ItemStack)this.inventory.get(1)).func_77976_d()) {
                SoundEvent sound;
                this.energyStorage.extractEnergy(energy, false);
                this.sendRenderPacket();
                Vector3d vec = this.getGunToTargetVec(this.target).func_72432_b();
                int count = bullet.getProjectileCount(null);
                if (count == 1) {
                    RevolvershotEntity entBullet = this.getBulletEntity(this.field_145850_b, vec, bullet);
                    this.field_145850_b.func_217376_c(bullet.getProjectile(null, bulletStack, (Entity)entBullet, false));
                } else {
                    for (int i = 0; i < count; ++i) {
                        Vector3d vecDir = vec.func_72441_c(Utils.RAND.nextGaussian() * 0.1, Utils.RAND.nextGaussian() * 0.1, Utils.RAND.nextGaussian() * 0.1);
                        RevolvershotEntity entBullet = this.getBulletEntity(this.field_145850_b, vecDir, bullet);
                        this.field_145850_b.func_217376_c(bullet.getProjectile(null, bulletStack, (Entity)entBullet, false));
                    }
                }
                bulletStack.func_190918_g(1);
                if (bulletStack.func_190916_E() <= 0) {
                    this.inventory.set(0, (Object)ItemStack.field_190927_a);
                }
                if (!casing.func_190926_b()) {
                    if (this.expelCasings) {
                        double cX = (double)this.func_174877_v().func_177958_n() + 0.5;
                        double cY = (double)this.func_174877_v().func_177956_o() + 1.375;
                        double cZ = (double)this.func_174877_v().func_177952_p() + 0.5;
                        Vector3d vCasing = vec.func_178785_b(-1.57f);
                        this.field_145850_b.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, cX + vCasing.field_72450_a, cY + vCasing.field_72448_b, cZ + vCasing.field_72449_c, 0.0, 0.0, 0.0);
                        ItemEntity entCasing = new ItemEntity(this.field_145850_b, cX + vCasing.field_72450_a, cY + vCasing.field_72448_b, cZ + vCasing.field_72449_c, casing.func_77946_l());
                        entCasing.func_213293_j(0.0, -0.01, 0.0);
                        this.field_145850_b.func_217376_c((Entity)entCasing);
                    } else if (((ItemStack)this.inventory.get(1)).func_190926_b()) {
                        this.inventory.set(1, (Object)casing.func_77946_l());
                    } else {
                        ((ItemStack)this.inventory.get(1)).func_190917_f(casing.func_190916_E());
                    }
                }
                if ((sound = bullet.getSound()) == null) {
                    sound = IESounds.revolverFire;
                }
                this.field_145850_b.func_184133_a(null, this.func_174877_v(), sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    protected void sendRenderPacket() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74757_a("cycle", true);
        ImmersiveEngineering.packetHandler.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.getWorldNonnull().func_175726_f(this.field_174879_c)), (Object)new MessageTileSync(this, tag));
    }

    RevolvershotEntity getBulletEntity(World world, Vector3d vecDir, BulletHandler.IBullet type) {
        Vector3d gunPos = this.getGunPosition();
        RevolvershotEntity bullet = new RevolvershotEntity(world, gunPos.field_72450_a + vecDir.field_72450_a, gunPos.field_72448_b + vecDir.field_72448_b, gunPos.field_72449_c + vecDir.field_72449_c, 0.0, 0.0, 0.0, type);
        bullet.func_213317_d(vecDir);
        return bullet;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K && !this.isDummy() && this.cycleRender > 0) {
            --this.cycleRender;
        }
        super.func_73660_a();
    }

    @Override
    public void receiveMessageFromServer(CompoundNBT message) {
        if (message.func_74764_b("cycle")) {
            this.cycleRender = 5;
        }
    }

    @Override
    public void receiveMessageFromClient(CompoundNBT message) {
        super.receiveMessageFromClient(message);
        if (message.func_150297_b("expelCasings", 1)) {
            this.expelCasings = message.func_74767_n("expelCasings");
        }
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.expelCasings = nbt.func_74767_n("expelCasings");
        if (!descPacket) {
            this.inventory = Utils.readInventory(nbt.func_150295_c("inventory", 10), 2);
        }
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74757_a("expelCasings", this.expelCasings);
        if (!descPacket) {
            nbt.func_218657_a("inventory", (INBT)Utils.writeInventory(this.inventory));
        }
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (!(this.isDummy() || capability != CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || facing != null && facing != Direction.DOWN && facing != this.getFacing().func_176734_d())) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }
}

