/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal.conveyors;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.api.utils.EntityCollisionTracker;
import blusunrize.immersiveengineering.api.utils.shapes.CachedVoxelShapes;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.blocks.metal.ConveyorBeltTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.MetalScaffoldingType;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Triple;

public class BasicConveyor
implements ConveyorHandler.IConveyorBelt {
    public static final ResourceLocation NAME = new ResourceLocation("immersiveengineering", "basic");
    public Block cover = Blocks.field_150350_a;
    ConveyorHandler.ConveyorDirection direction = ConveyorHandler.ConveyorDirection.HORIZONTAL;
    @Nullable
    DyeColor dyeColour = null;
    private final TileEntity tile;
    protected final EntityCollisionTracker collisionTracker = new EntityCollisionTracker(10);
    public static ResourceLocation texture_on = new ResourceLocation("immersiveengineering:block/conveyor/conveyor");
    public static ResourceLocation texture_off = new ResourceLocation("immersiveengineering:block/conveyor/off");
    static final VoxelShape topBox = VoxelShapes.func_197873_a((double)0.0, (double)0.75, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    private static final CachedVoxelShapes<Triple<Boolean, Boolean, Direction>> SHAPES = new CachedVoxelShapes<Triple>(BasicConveyor::getBoxes);
    public static ArrayList<Predicate<Block>> validCoveyorCovers = new ArrayList();

    public BasicConveyor(TileEntity tile) {
        this.tile = tile;
    }

    @Override
    public TileEntity getTile() {
        return this.tile;
    }

    @Override
    public ConveyorHandler.ConveyorDirection getConveyorDirection() {
        return this.direction;
    }

    @Override
    public boolean changeConveyorDirection() {
        if (!this.tile.func_145831_w().field_72995_K) {
            this.direction = this.direction == ConveyorHandler.ConveyorDirection.HORIZONTAL ? ConveyorHandler.ConveyorDirection.UP : (this.direction == ConveyorHandler.ConveyorDirection.UP ? ConveyorHandler.ConveyorDirection.DOWN : ConveyorHandler.ConveyorDirection.HORIZONTAL);
        }
        return true;
    }

    @Override
    public boolean setConveyorDirection(ConveyorHandler.ConveyorDirection dir) {
        this.direction = dir;
        return true;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    protected boolean allowCovers() {
        return false;
    }

    public static Block getDefaultCover() {
        return IEBlocks.MetalDecoration.steelScaffolding.get((Object)MetalScaffoldingType.STANDARD);
    }

    @Override
    public void onEntityCollision(@Nonnull Entity entity) {
        this.collisionTracker.onEntityCollided(entity);
        ConveyorHandler.IConveyorBelt.super.onEntityCollision(entity);
        if (this.allowCovers() && entity instanceof ItemEntity) {
            ((ItemEntity)entity).func_174867_a(10);
        }
    }

    @Override
    public boolean isBlocked() {
        return this.collisionTracker.getCollidedInRange(this.getTile().func_145831_w().func_82737_E()) > 2;
    }

    @Override
    public void onItemDeployed(ItemEntity entity) {
        ConveyorHandler.IConveyorBelt.super.onItemDeployed(entity);
        if (this.allowCovers()) {
            entity.func_174867_a(10);
        }
    }

    @Override
    public boolean playerInteraction(PlayerEntity player, Hand hand, ItemStack heldItem, float hitX, float hitY, float hitZ, Direction side) {
        if (this.allowCovers()) {
            return this.handleCoverInteraction(player, hand, heldItem);
        }
        return false;
    }

    @Override
    public CompoundNBT writeConveyorNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("direction", this.direction.ordinal());
        if (this.dyeColour != null) {
            nbt.func_74768_a("dyeColour", this.dyeColour.func_196059_a());
        }
        if (this.allowCovers() && this.cover != Blocks.field_150350_a) {
            nbt.func_74778_a("cover", ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)this.cover).toString());
        }
        return nbt;
    }

    @Override
    public void readConveyorNBT(CompoundNBT nbt) {
        this.direction = ConveyorHandler.ConveyorDirection.values()[nbt.func_74762_e("direction")];
        this.dyeColour = nbt.func_150297_b("dyeColour", 3) ? DyeColor.func_196056_a((int)nbt.func_74762_e("dyeColour")) : null;
        if (this.allowCovers()) {
            this.cover = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.func_74779_i("cover")));
        }
    }

    @Override
    public ResourceLocation getActiveTexture() {
        return texture_on;
    }

    @Override
    public ResourceLocation getInactiveTexture() {
        return texture_off;
    }

    @Override
    public boolean canBeDyed() {
        return true;
    }

    @Override
    public boolean setDyeColour(DyeColor colour) {
        if (colour == this.dyeColour) {
            return false;
        }
        this.dyeColour = colour;
        return true;
    }

    @Override
    public DyeColor getDyeColour() {
        return this.dyeColour;
    }

    @Override
    public String getModelCacheKey() {
        String key = ConveyorHandler.IConveyorBelt.super.getModelCacheKey();
        if (this.allowCovers() && this.cover != Blocks.field_150350_a) {
            key = key + "s" + this.cover.getRegistryName();
        }
        return key;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<BakedQuad> modifyQuads(List<BakedQuad> baseModel) {
        if (this.allowCovers()) {
            this.addCoverToQuads(baseModel);
        }
        return baseModel;
    }

    @Override
    public VoxelShape getCollisionShape() {
        VoxelShape ret = ConveyorHandler.IConveyorBelt.super.getCollisionShape();
        if (this.allowCovers()) {
            VoxelShape other;
            if (this.getConveyorDirection() == ConveyorHandler.ConveyorDirection.HORIZONTAL) {
                other = topBox;
            } else {
                boolean up = this.getConveyorDirection() == ConveyorHandler.ConveyorDirection.UP;
                other = SHAPES.get((Triple<Boolean, Boolean, Direction>)Triple.of((Object)up, (Object)true, (Object)this.getFacing()));
            }
            ret = VoxelShapes.func_197878_a((VoxelShape)ret, (VoxelShape)other, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        return ret;
    }

    @Override
    public VoxelShape getSelectionShape() {
        if (this.allowCovers()) {
            if (this.getConveyorDirection() == ConveyorHandler.ConveyorDirection.HORIZONTAL) {
                return VoxelShapes.func_197868_b();
            }
            boolean up = this.getConveyorDirection() == ConveyorHandler.ConveyorDirection.UP;
            return SHAPES.get((Triple<Boolean, Boolean, Direction>)Triple.of((Object)up, (Object)false, (Object)this.getFacing()));
        }
        return ConveyorHandler.IConveyorBelt.super.getSelectionShape();
    }

    private static List<AxisAlignedBB> getBoxes(Triple<Boolean, Boolean, Direction> key) {
        boolean up = (Boolean)key.getLeft();
        boolean collision = (Boolean)key.getMiddle();
        Direction facing = (Direction)key.getRight();
        return Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(facing == Direction.WEST && !up || facing == Direction.EAST && up ? 0.5 : 0.0, collision ? 1.75 : 0.5, facing == Direction.NORTH && !up || facing == Direction.SOUTH && up ? 0.5 : 0.0, facing == Direction.WEST && up || facing == Direction.EAST && !up ? 0.5 : 1.0, 2.0, facing == Direction.NORTH && up || facing == Direction.SOUTH && !up ? 0.5 : 1.0), new AxisAlignedBB(facing == Direction.WEST && up || facing == Direction.EAST && !up ? 0.5 : 0.0, collision ? 1.25 : 0.0, facing == Direction.NORTH && up || facing == Direction.SOUTH && !up ? 0.5 : 0.0, facing == Direction.WEST && !up || facing == Direction.EAST && up ? 0.5 : 1.0, 1.5, facing == Direction.NORTH && !up || facing == Direction.SOUTH && up ? 0.5 : 1.0)});
    }

    protected void addCoverToQuads(List<BakedQuad> baseModel) {
        Block b = this.cover != Blocks.field_150350_a ? this.cover : BasicConveyor.getDefaultCover();
        BlockState state = b.func_176223_P();
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(state);
        if (model != null) {
            Direction facing = this.getFacing();
            ConveyorHandler.ConveyorDirection conDir = this.getConveyorDirection();
            TextureAtlasSprite sprite = model.getParticleTexture((IModelData)EmptyModelData.INSTANCE);
            HashMap<Direction, TextureAtlasSprite> sprites = new HashMap<Direction, TextureAtlasSprite>();
            for (Direction f2 : Direction.field_199792_n) {
                for (BakedQuad q : model.func_200117_a(state, f2, Utils.RAND)) {
                    if (q == null || q.func_187508_a() == null) continue;
                    sprites.put(f2, q.func_187508_a());
                }
            }
            for (BakedQuad q : model.func_200117_a(state, null, Utils.RAND)) {
                if (q == null || q.func_187508_a() == null || q.func_178210_d() == null) continue;
                sprites.put(q.func_178210_d(), q.func_187508_a());
            }
            Function<Direction, TextureAtlasSprite> getSprite = f -> sprites.containsKey(f) ? (TextureAtlasSprite)sprites.get(f) : sprite;
            Function<Direction, TextureAtlasSprite> getSpriteHorizontal = f -> f.func_176740_k() == Direction.Axis.Y ? null : (sprites.containsKey(f) ? (TextureAtlasSprite)sprites.get(f) : sprite);
            float[] colour = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            Matrix4 matrix = new Matrix4(facing);
            Function<Vector3d[], Vector3d[]> vertexTransformer = conDir == ConveyorHandler.ConveyorDirection.HORIZONTAL ? vertices -> vertices : vertices -> {
                Vector3d[] ret = new Vector3d[((Vector3d[])vertices).length];
                for (int i = 0; i < ret.length; ++i) {
                    ret[i] = new Vector3d(vertices[i].field_72450_a, vertices[i].field_72448_b + (double)(vertices[i].field_72449_c == (double)(conDir != ConveyorHandler.ConveyorDirection.UP ? 1 : 0) ? 1 : 0), vertices[i].field_72449_c);
                }
                return ret;
            };
            baseModel.addAll(ClientUtils.createBakedBox(new Vector3d(0.0, 0.75, 0.0), new Vector3d(1.0, 1.0, 1.0), matrix, facing, vertexTransformer, getSprite, colour));
            if (this.getTile() == null || this.renderWall(this.getFacing(), 0)) {
                baseModel.addAll(ClientUtils.createBakedBox(new Vector3d(0.0, 0.1875, 0.0), new Vector3d(0.0625, 0.75, 1.0), matrix, facing, vertexTransformer, getSpriteHorizontal, colour));
            } else {
                baseModel.addAll(ClientUtils.createBakedBox(new Vector3d(0.0, 0.1875, 0.0), new Vector3d(0.0625, 0.75, 0.0625), matrix, facing, getSpriteHorizontal, colour));
                baseModel.addAll(ClientUtils.createBakedBox(new Vector3d(0.0, 0.1875, 0.9375), new Vector3d(0.0625, 0.75, 1.0), matrix, facing, getSpriteHorizontal, colour));
            }
            if (this.getTile() == null || this.renderWall(this.getFacing(), 1)) {
                baseModel.addAll(ClientUtils.createBakedBox(new Vector3d(0.9375, 0.1875, 0.0), new Vector3d(1.0, 0.75, 1.0), matrix, facing, vertexTransformer, getSpriteHorizontal, colour));
            } else {
                baseModel.addAll(ClientUtils.createBakedBox(new Vector3d(0.9375, 0.1875, 0.0), new Vector3d(1.0, 0.75, 0.0625), matrix, facing, getSpriteHorizontal, colour));
                baseModel.addAll(ClientUtils.createBakedBox(new Vector3d(0.9375, 0.1875, 0.9375), new Vector3d(1.0, 0.75, 1.0), matrix, facing, getSpriteHorizontal, colour));
            }
        }
    }

    public void dropCover(PlayerEntity player) {
        ItemEntity entityitem;
        if (this.tile != null && !this.tile.func_145831_w().field_72995_K && this.cover != Blocks.field_150350_a && this.tile.func_145831_w().func_82736_K().func_223586_b(GameRules.field_223603_f) && (entityitem = player.func_71019_a(new ItemStack((IItemProvider)this.cover), false)) != null) {
            entityitem.func_174868_q();
        }
    }

    protected boolean handleCoverInteraction(PlayerEntity player, Hand hand, ItemStack heldItem) {
        Block heldBlock;
        if (heldItem.func_190926_b() && player.func_225608_bj_() && this.cover != Blocks.field_150350_a) {
            this.dropCover(player);
            this.cover = Blocks.field_150350_a;
            return true;
        }
        if (!heldItem.func_190926_b() && !player.func_225608_bj_() && (heldBlock = Block.func_149634_a((Item)heldItem.func_77973_b())) != Blocks.field_150350_a) {
            for (Predicate<Block> func : validCoveyorCovers) {
                if (!func.test(heldBlock) || heldBlock == this.cover) continue;
                this.dropCover(player);
                this.cover = heldBlock;
                heldItem.func_190918_g(1);
                if (heldItem.func_190916_E() <= 0) {
                    player.func_184611_a(hand, heldItem);
                }
                return true;
            }
        }
        return false;
    }

    protected final boolean isPowered() {
        TileEntity te = this.getTile();
        if (te instanceof ConveyorBeltTileEntity) {
            return ((ConveyorBeltTileEntity)te).isRSPowered();
        }
        return te.func_145831_w().func_175687_A(te.func_174877_v()) > 0;
    }

    static {
        validCoveyorCovers.add(arg_0 -> IETags.scaffoldingAlu.func_230235_a_(arg_0));
        validCoveyorCovers.add(arg_0 -> IETags.scaffoldingSteel.func_230235_a_(arg_0));
        validCoveyorCovers.add(input -> input == IEBlocks.WoodenDecoration.treatedScaffolding);
        validCoveyorCovers.add(arg_0 -> ((Tags.IOptionalNamedTag)Tags.Blocks.GLASS).func_230235_a_(arg_0));
    }
}

