/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal.conveyors;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.client.utils.SinglePropertyModelData;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.BasicConveyor;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RedstoneConveyor
extends BasicConveyor {
    public static final ResourceLocation NAME = new ResourceLocation("immersiveengineering", "redstone");
    @OnlyIn(value=Dist.CLIENT)
    public static DynamicModel<Direction> MODEL_PANEL;
    public static ResourceLocation texture_panel;
    private boolean panelRight = true;
    private static final Map<Direction, VoxelShape> WALL_SHAPES;

    public RedstoneConveyor(TileEntity tile) {
        super(tile);
    }

    @Override
    public boolean changeConveyorDirection() {
        return false;
    }

    @Override
    public boolean setConveyorDirection(ConveyorHandler.ConveyorDirection dir) {
        return false;
    }

    @Override
    public boolean isActive() {
        return !this.isPowered();
    }

    @Override
    public boolean playerInteraction(PlayerEntity player, Hand hand, ItemStack heldItem, float hitX, float hitY, float hitZ, Direction side) {
        if (super.playerInteraction(player, hand, heldItem, hitX, hitY, hitZ, side)) {
            return true;
        }
        if (Utils.isHammer(heldItem) && player.func_225608_bj_()) {
            this.panelRight = !this.panelRight;
            return true;
        }
        return false;
    }

    @Override
    public CompoundNBT writeConveyorNBT() {
        CompoundNBT nbt = super.writeConveyorNBT();
        nbt.func_74757_a("panelRight", this.panelRight);
        return nbt;
    }

    @Override
    public void readConveyorNBT(CompoundNBT nbt) {
        super.readConveyorNBT(nbt);
        this.panelRight = nbt.func_74767_n("panelRight");
    }

    @Override
    public VoxelShape getSelectionShape() {
        VoxelShape ret = conveyorBounds;
        VoxelShape extensionShape = WALL_SHAPES.get(this.panelRight ? this.getFacing() : this.getFacing().func_176734_d());
        if (extensionShape != null) {
            ret = VoxelShapes.func_197882_b((VoxelShape)ret, (VoxelShape)extensionShape, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        return ret;
    }

    @Override
    public String getModelCacheKey() {
        String key = super.getModelCacheKey();
        key = key + "p" + this.panelRight;
        return key;
    }

    @Override
    public boolean renderWall(Direction facing, int wall) {
        if (this.panelRight && wall == 1 || !this.panelRight && wall == 0) {
            return true;
        }
        return super.renderWall(facing, wall);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<BakedQuad> modifyQuads(List<BakedQuad> baseModel) {
        IBakedModel model = MODEL_PANEL.get(this.panelRight ? this.getFacing() : this.getFacing().func_176734_d());
        if (model != null) {
            String[] stringArray;
            if (this.getTile() != null && !this.isActive()) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "panel";
                stringArray = stringArray2;
                stringArray2[1] = "lamp";
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "panel";
            }
            String[] parts = stringArray;
            IEProperties.IEObjState objState = new IEProperties.IEObjState(IEProperties.VisibilityList.show(parts));
            BlockState state = ConveyorHandler.getBlock(NAME).func_176223_P();
            baseModel.addAll(model.getQuads(state, null, Utils.RAND, new SinglePropertyModelData<IEProperties.IEObjState>(objState, IEProperties.Model.IE_OBJ_STATE)));
        }
        return baseModel;
    }

    static {
        texture_panel = new ResourceLocation("immersiveengineering:block/conveyor/redstone");
        WALL_SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.func_208617_a((double)13.0, (double)2.0, (double)5.0, (double)16.0, (double)16.0, (double)14.5), (Object)Direction.SOUTH, (Object)Block.func_208617_a((double)0.0, (double)2.0, (double)1.5, (double)3.0, (double)16.0, (double)11.0), (Object)Direction.WEST, (Object)Block.func_208617_a((double)5.0, (double)2.0, (double)0.0, (double)14.5, (double)16.0, (double)3.0), (Object)Direction.EAST, (Object)Block.func_208617_a((double)1.5, (double)2.0, (double)13.0, (double)11.0, (double)16.0, (double)16.0)));
    }
}

