/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.util.IELogger;
import java.lang.reflect.Field;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionBrewing;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.tags.FluidTags;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.IRegistryDelegate;

public class PotionHelper {
    public static FluidStack getFluidStackForType(Potion type, int amount) {
        if (type == Potions.field_185230_b || type == null) {
            return new FluidStack((Fluid)Fluids.field_204546_a, amount);
        }
        FluidStack stack = new FluidStack(IEContent.fluidPotion, amount);
        stack.getOrCreateTag().func_74778_a("Potion", type.getRegistryName().toString());
        return stack;
    }

    public static FluidTagInput getFluidTagForType(Potion type, int amount) {
        if (type == Potions.field_185230_b || type == null) {
            return new FluidTagInput(FluidTags.field_206959_a.func_230234_a_(), amount);
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("Potion", type.getRegistryName().toString());
        return new FluidTagInput(IETags.fluidPotion.func_230234_a_(), amount, nbt);
    }

    public static void applyToAllPotionRecipes(PotionRecipeProcessor out) {
        try {
            String mixPredicateName = "net.minecraft.potion.PotionBrewing$MixPredicate";
            Class<?> mixPredicateClass = Class.forName(mixPredicateName);
            Field f_input = ObfuscationReflectionHelper.findField(mixPredicateClass, (String)"field_185198_a");
            Field f_reagent = ObfuscationReflectionHelper.findField(mixPredicateClass, (String)"field_185199_b");
            Field f_output = ObfuscationReflectionHelper.findField(mixPredicateClass, (String)"field_185200_c");
            f_input.setAccessible(true);
            f_reagent.setAccessible(true);
            f_output.setAccessible(true);
            for (Object mixPredicate : PotionBrewing.field_185213_a) {
                Ingredient reagent = (Ingredient)f_reagent.get(mixPredicate);
                IRegistryDelegate input = (IRegistryDelegate)f_input.get(mixPredicate);
                IRegistryDelegate output = (IRegistryDelegate)f_output.get(mixPredicate);
                out.apply((Potion)output.get(), (Potion)input.get(), new IngredientWithSize(reagent));
            }
        }
        catch (Exception e) {
            IELogger.error("Error when trying to figure out vanilla potion recipes", e);
        }
        for (IBrewingRecipe recipe : BrewingRecipeRegistry.getRecipes()) {
            if (!(recipe instanceof BrewingRecipe)) continue;
            IngredientWithSize ingredient = new IngredientWithSize(((BrewingRecipe)recipe).getIngredient());
            Ingredient input = ((BrewingRecipe)recipe).getInput();
            ItemStack output = ((BrewingRecipe)recipe).getOutput();
            if (output.func_77973_b() != Items.field_151068_bn) continue;
            out.apply(PotionUtils.func_185191_c((ItemStack)output), PotionUtils.func_185191_c((ItemStack)input.func_193365_a()[0]), ingredient);
        }
    }

    public static interface PotionRecipeProcessor {
        public void apply(Potion var1, Potion var2, IngredientWithSize var3);
    }
}

