/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.items.IEItems;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class PowerpackRecipe
implements ICraftingRecipe {
    private final ResourceLocation id;

    public PowerpackRecipe(ResourceLocation id) {
        this.id = id;
    }

    public boolean matches(CraftingInventory inv, @Nonnull World world) {
        ItemStack powerpack = ItemStack.field_190927_a;
        ItemStack armor = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stackInSlot = inv.func_70301_a(i);
            if (stackInSlot.func_190926_b()) continue;
            if (powerpack.func_190926_b() && IEItems.Misc.powerpack.equals(stackInSlot.func_77973_b())) {
                powerpack = stackInSlot;
                continue;
            }
            if (armor.func_190926_b() && this.isValidArmor(stackInSlot)) {
                armor = stackInSlot;
                continue;
            }
            return false;
        }
        if (!(powerpack.func_190926_b() || armor.func_190926_b() || ItemNBTHelper.hasKey(armor, "IE:Powerpack"))) {
            return true;
        }
        return !armor.func_190926_b() && ItemNBTHelper.hasKey(armor, "IE:Powerpack") && powerpack.func_190926_b();
    }

    @Nonnull
    public ItemStack getCraftingResult(CraftingInventory inv) {
        ItemStack powerpack = ItemStack.field_190927_a;
        ItemStack armor = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stackInSlot = inv.func_70301_a(i);
            if (stackInSlot.func_190926_b()) continue;
            if (powerpack.func_190926_b() && IEItems.Misc.powerpack.equals(stackInSlot.func_77973_b())) {
                powerpack = stackInSlot;
                continue;
            }
            if (!armor.func_190926_b() || !this.isValidArmor(stackInSlot)) continue;
            armor = stackInSlot;
        }
        if (!(powerpack.func_190926_b() || armor.func_190926_b() || ItemNBTHelper.hasKey(armor, "IE:Powerpack"))) {
            ItemStack output = armor.func_77946_l();
            ItemNBTHelper.setItemStack(output, "IE:Powerpack", powerpack.func_77946_l());
            return output;
        }
        if (!armor.func_190926_b() && ItemNBTHelper.hasKey(armor, "IE:Powerpack")) {
            ItemStack output = armor.func_77946_l();
            ItemNBTHelper.remove(output, "IE:Powerpack");
            return output;
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 2 && height >= 2;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return new ItemStack((IItemProvider)IEItems.Misc.powerpack, 1);
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList remaining = super.func_179532_b((IInventory)inv);
        for (int i = 0; i < remaining.size(); ++i) {
            ItemStack stackInSlot = inv.func_70301_a(i);
            if (stackInSlot.func_190926_b() || !ItemNBTHelper.hasKey(stackInSlot, "IE:Powerpack")) continue;
            remaining.set(i, (Object)ItemNBTHelper.getItemStack(stackInSlot, "IE:Powerpack"));
        }
        return remaining;
    }

    private boolean isValidArmor(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof ArmorItem) || ((ArmorItem)stack.func_77973_b()).func_185083_B_() != EquipmentSlotType.CHEST) {
            return false;
        }
        if (stack.func_77973_b() == IEItems.Misc.powerpack) {
            return false;
        }
        String regName = stack.func_77973_b().getRegistryName().toString();
        for (String s : (List)IEServerConfig.TOOLS.powerpack_whitelist.get()) {
            if (!regName.equals(s)) continue;
            return true;
        }
        for (String s : (List)IEServerConfig.TOOLS.powerpack_blacklist.get()) {
            if (!regName.equals(s)) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)RecipeSerializers.POWERPACK_SERIALIZER.get();
    }

    public NonNullList<Ingredient> func_192400_c() {
        return NonNullList.func_191197_a((int)1, (Object)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{IEItems.Misc.powerpack}));
    }
}

