/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.data;

import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.common.blocks.EnumMetals;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.BasicConveyor;
import blusunrize.immersiveengineering.common.items.BulletItem;
import blusunrize.immersiveengineering.common.items.IEItems;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.advancements.MultiblockTrigger;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.ImpossibleTrigger;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.PlacedBlockTrigger;
import net.minecraft.block.Block;
import net.minecraft.command.FunctionObject;
import net.minecraft.data.AdvancementProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class Advancements
extends AdvancementProvider {
    private final Path OUTPUT;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public Advancements(DataGenerator gen) {
        super(gen);
        this.OUTPUT = gen.func_200391_b();
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        HashSet set = Sets.newHashSet();
        Consumer<Advancement> consumer = p_204017_3_ -> {
            if (!set.add(p_204017_3_.func_192067_g())) {
                throw new IllegalStateException("Duplicate advancement " + p_204017_3_.func_192067_g());
            }
            Path path1 = Advancements.getPath(this.OUTPUT, p_204017_3_);
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)p_204017_3_.func_192075_a().func_200273_b(), (Path)path1);
            }
            catch (IOException ioexception) {
                IELogger.error("Couldn't save advancement {}", path1, ioexception);
            }
        };
        new IEAdvancements().accept(consumer);
    }

    private static Path getPath(Path pathIn, Advancement advancementIn) {
        return pathIn.resolve("data/" + advancementIn.func_192067_g().func_110624_b() + "/advancements/" + advancementIn.func_192067_g().func_110623_a() + ".json");
    }

    protected static Advancement.Builder advancement(Advancement parent, IItemProvider display, String name, FrameType frame, boolean showToast, boolean announceToChat, boolean hidden) {
        return Advancement.Builder.func_200278_a().func_203905_a(parent).func_203902_a(display, (ITextComponent)new TranslationTextComponent("advancement.immersiveengineering." + name), (ITextComponent)new TranslationTextComponent("advancement.immersiveengineering." + name + ".desc"), null, frame, showToast, announceToChat, hidden);
    }

    protected static Advancement.Builder advancement(Advancement parent, ItemStack display, String name, FrameType frame, boolean showToast, boolean announceToChat, boolean hidden) {
        return Advancement.Builder.func_200278_a().func_203905_a(parent).func_215092_a(display, (ITextComponent)new TranslationTextComponent("advancement.immersiveengineering." + name), (ITextComponent)new TranslationTextComponent("advancement.immersiveengineering." + name + ".desc"), null, frame, showToast, announceToChat, hidden);
    }

    protected static AdvancementRewards reward(ResourceLocation loot) {
        return new AdvancementRewards(0, new ResourceLocation[]{loot}, new ResourceLocation[0], FunctionObject.CacheableFunction.field_193519_a);
    }

    public static class IEAdvancements
    implements Consumer<Consumer<Advancement>> {
        @Override
        public void accept(Consumer<Advancement> consumer) {
            Advancement rtfm = Advancement.Builder.func_200278_a().func_203902_a((IItemProvider)IEItems.Tools.manual, (ITextComponent)new TranslationTextComponent("advancement.immersiveengineering.root"), (ITextComponent)new TranslationTextComponent("advancement.immersiveengineering.root.desc"), new ResourceLocation("immersiveengineering:textures/block/wooden_decoration/treated_wood.png"), FrameType.TASK, true, true, false).func_200275_a("manual", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{IEItems.Tools.manual})).func_203904_a(consumer, "immersiveengineering:main/root");
            Advancement hammer = Advancements.advancement(rtfm, (IItemProvider)IEItems.Tools.hammer, "craft_hammer", FrameType.TASK, true, true, false).func_200275_a("hammer", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{IEItems.Tools.hammer})).func_203904_a(consumer, "immersiveengineering:main/craft_hammer");
            Advancement wire = Advancements.advancement(rtfm, (IItemProvider)IEItems.Misc.wireCoils.get(WireType.COPPER), "connect_wire", FrameType.TASK, true, true, false).func_200275_a("code_trigger", (ICriterionInstance)new ImpossibleTrigger.Instance()).func_203904_a(consumer, "immersiveengineering:main/connect_wire");
            Advancement blastfurnace = Advancements.advancement(hammer, (IItemProvider)IEBlocks.Multiblocks.blastFurnace, "mb_blastfurnace", FrameType.GOAL, true, true, false).func_200275_a("blastfurnace", (ICriterionInstance)MultiblockTrigger.create(new ResourceLocation("immersiveengineering", "multiblocks/blast_furnace"), ItemPredicate.Builder.func_200309_a().func_200308_a((IItemProvider)IEItems.Tools.hammer).func_200310_b())).func_203904_a(consumer, "immersiveengineering:main/mb_blastfurnace");
            Advancement steel = Advancements.advancement(blastfurnace, (IItemProvider)IEItems.Metals.ingots.get((Object)EnumMetals.STEEL), "make_steel", FrameType.TASK, true, true, false).func_200275_a("steel", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)IEItems.Metals.ingots.get((Object)EnumMetals.STEEL)})).func_203904_a(consumer, "immersiveengineering:main/make_steel");
            Advancement.Builder b_conveyor = Advancements.advancement(rtfm, (IItemProvider)IEBlocks.MetalDevices.CONVEYORS.get(BasicConveyor.NAME), "place_conveyor", FrameType.TASK, true, true, false).func_200270_a(IRequirementsStrategy.field_223215_b_);
            for (Map.Entry<ResourceLocation, Block> entry : IEBlocks.MetalDevices.CONVEYORS.entrySet()) {
                b_conveyor.func_200275_a(entry.getKey().func_110623_a(), (ICriterionInstance)PlacedBlockTrigger.Instance.func_203934_a((Block)entry.getValue()));
            }
            Advancement conveyor = b_conveyor.func_203904_a(consumer, "immersiveengineering:main/place_conveyor");
            Advancement windmill = Advancements.advancement(rtfm, (IItemProvider)IEBlocks.WoodenDevices.windmill, "place_windmill", FrameType.TASK, true, true, false).func_200275_a("windmill", (ICriterionInstance)PlacedBlockTrigger.Instance.func_203934_a((Block)IEBlocks.WoodenDevices.windmill)).func_203904_a(consumer, "immersiveengineering:main/place_windmill");
            Advancement heater = Advancements.advancement(wire, (IItemProvider)IEBlocks.MetalDevices.furnaceHeater, "craft_heater", FrameType.TASK, true, true, false).func_200275_a("heater", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{IEBlocks.MetalDevices.furnaceHeater})).func_203904_a(consumer, "immersiveengineering:main/craft_heater");
            Advancement pump = Advancements.advancement(wire, (IItemProvider)IEBlocks.MetalDevices.fluidPump, "craft_pump", FrameType.TASK, true, true, false).func_200275_a("pump", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{IEBlocks.MetalDevices.fluidPump})).func_203904_a(consumer, "immersiveengineering:main/craft_pump");
            Advancement floodlight = Advancements.advancement(wire, (IItemProvider)IEBlocks.MetalDevices.floodlight, "place_floodlight", FrameType.TASK, true, true, false).func_200275_a("floodlight", (ICriterionInstance)PlacedBlockTrigger.Instance.func_203934_a((Block)IEBlocks.MetalDevices.floodlight)).func_203904_a(consumer, "immersiveengineering:main/place_floodlight");
            Advancement workbench = Advancements.advancement(rtfm, (IItemProvider)IEBlocks.WoodenDevices.workbench, "craft_workbench", FrameType.TASK, true, true, false).func_200275_a("workbench", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{IEBlocks.WoodenDevices.workbench})).func_203904_a(consumer, "immersiveengineering:main/craft_workbench");
            Advancement revolver = Advancements.advancement(workbench, (IItemProvider)IEItems.Weapons.revolver, "craft_revolver", FrameType.TASK, true, true, false).func_200275_a("revolver", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{IEItems.Weapons.revolver})).func_203904_a(consumer, "immersiveengineering:main/craft_revolver");
            ItemStack upgradedRevolver = new ItemStack((IItemProvider)IEItems.Weapons.revolver);
            CompoundNBT upgrades = new CompoundNBT();
            upgrades.func_74768_a("bullets", 6);
            upgrades.func_74757_a("electro", true);
            ItemNBTHelper.setTagCompound(upgradedRevolver, "upgrades", upgrades);
            Advancement upgrade_revolver = Advancements.advancement(revolver, upgradedRevolver, "upgrade_revolver", FrameType.CHALLENGE, true, true, false).func_200275_a("code_trigger", (ICriterionInstance)new ImpossibleTrigger.Instance()).func_200274_a(Advancements.reward(new ResourceLocation("immersiveengineering", "advancements/shader_rare"))).func_203904_a(consumer, "immersiveengineering:main/upgrade_revolver");
            Advancement wolfpack = Advancements.advancement(revolver, (IItemProvider)BulletHandler.getBulletItem(BulletItem.WOLFPACK), "craft_wolfpack", FrameType.TASK, true, true, true).func_200275_a("wolfpack", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{BulletHandler.getBulletItem(BulletItem.WOLFPACK)})).func_203904_a(consumer, "immersiveengineering:main/craft_wolfpack");
            Advancement drill = Advancements.advancement(workbench, (IItemProvider)IEItems.Tools.drill, "craft_drill", FrameType.TASK, true, true, false).func_200275_a("drill", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{IEItems.Tools.drill})).func_203904_a(consumer, "immersiveengineering:main/craft_drill");
            ItemStack upgradedDrill = new ItemStack((IItemProvider)IEItems.Tools.drill);
            upgrades = new CompoundNBT();
            upgrades.func_74768_a("damage", 3);
            upgrades.func_74757_a("waterproof", true);
            upgrades.func_74757_a("oiled", true);
            upgrades.func_74776_a("speed", 6.0f);
            ItemNBTHelper.setTagCompound(upgradedDrill, "upgrades", upgrades);
            ItemNBTHelper.setItemStack(upgradedDrill, "head", new ItemStack((IItemProvider)IEItems.Tools.drillheadSteel));
            Advancement upgradeDrill = Advancements.advancement(drill, upgradedDrill, "upgrade_drill", FrameType.CHALLENGE, true, true, false).func_200275_a("code_trigger", (ICriterionInstance)new ImpossibleTrigger.Instance()).func_200274_a(Advancements.reward(new ResourceLocation("immersiveengineering", "advancements/shader_rare"))).func_203904_a(consumer, "immersiveengineering:main/upgrade_drill");
            Advancement buzzsaw = Advancements.advancement(workbench, (IItemProvider)IEItems.Tools.buzzsaw, "craft_buzzsaw", FrameType.TASK, true, true, false).func_200275_a("buzzsaw", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{IEItems.Tools.buzzsaw})).func_203904_a(consumer, "immersiveengineering:main/craft_buzzsaw");
            ItemStack upgradedBuzzsaw = new ItemStack((IItemProvider)IEItems.Tools.buzzsaw);
            upgrades = new CompoundNBT();
            upgrades.func_74757_a("oiled", true);
            upgrades.func_74757_a("spareblades", true);
            ItemNBTHelper.setTagCompound(upgradedBuzzsaw, "upgrades", upgrades);
            ItemNBTHelper.setItemStack(upgradedBuzzsaw, "sawblade", new ItemStack((IItemProvider)IEItems.Tools.sawblade));
            ItemNBTHelper.setItemStack(upgradedBuzzsaw, "sawblade_spare1", new ItemStack((IItemProvider)IEItems.Tools.sawblade));
            ItemNBTHelper.setItemStack(upgradedBuzzsaw, "sawblade_spare2", new ItemStack((IItemProvider)IEItems.Tools.sawblade));
            Advancement upgradeBuzzsaw = Advancements.advancement(buzzsaw, upgradedBuzzsaw, "upgrade_buzzsaw", FrameType.CHALLENGE, true, true, false).func_200275_a("code_trigger", (ICriterionInstance)new ImpossibleTrigger.Instance()).func_200274_a(Advancements.reward(new ResourceLocation("immersiveengineering", "advancements/shader_rare"))).func_203904_a(consumer, "immersiveengineering:main/upgrade_buzzsaw");
            Advancement skyhook = Advancements.advancement(workbench, (IItemProvider)IEItems.Misc.skyhook, "craft_skyhook", FrameType.TASK, true, true, false).func_200275_a("skyhook", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{IEItems.Misc.skyhook})).func_203904_a(consumer, "immersiveengineering:main/craft_skyhook");
            Advancement chemthrower = Advancements.advancement(workbench, (IItemProvider)IEItems.Weapons.chemthrower, "craft_chemthrower", FrameType.TASK, true, true, false).func_200275_a("chemthrower", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{IEItems.Weapons.chemthrower})).func_203904_a(consumer, "immersiveengineering:main/craft_chemthrower");
            Advancement railgun = Advancements.advancement(workbench, (IItemProvider)IEItems.Weapons.railgun, "craft_railgun", FrameType.TASK, true, true, false).func_200275_a("railgun", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{IEItems.Weapons.railgun})).func_203904_a(consumer, "immersiveengineering:main/craft_railgun");
            ItemStack upgradedRailgun = new ItemStack((IItemProvider)IEItems.Weapons.railgun);
            upgrades = new CompoundNBT();
            upgrades.func_74757_a("scope", true);
            upgrades.func_74776_a("speed", 1.0f);
            ItemNBTHelper.setTagCompound(upgradedRailgun, "upgrades", upgrades);
            Advancement upgradeRailgun = Advancements.advancement(railgun, upgradedRailgun, "upgrade_railgun", FrameType.CHALLENGE, true, true, false).func_200275_a("code_trigger", (ICriterionInstance)new ImpossibleTrigger.Instance()).func_200274_a(Advancements.reward(new ResourceLocation("immersiveengineering", "advancements/shader_rare"))).func_203904_a(consumer, "immersiveengineering:main/upgrade_railgun");
            Advancement improvedblastfurnace = Advancements.advancement(steel, (IItemProvider)IEBlocks.Multiblocks.blastFurnaceAdv, "mb_improvedblastfurnace", FrameType.TASK, true, true, false).func_200275_a("improvedblastfurnace", (ICriterionInstance)MultiblockTrigger.create(new ResourceLocation("immersiveengineering", "multiblocks/improved_blast_furnace"), ItemPredicate.Builder.func_200309_a().func_200308_a((IItemProvider)IEItems.Tools.hammer).func_200310_b())).func_203904_a(consumer, "immersiveengineering:main/mb_improvedblastfurnace");
            Advancement metalpress = Advancements.advancement(steel, (IItemProvider)IEBlocks.Multiblocks.metalPress, "mb_metalpress", FrameType.TASK, true, true, false).func_200275_a("metalpress", (ICriterionInstance)MultiblockTrigger.create(new ResourceLocation("immersiveengineering", "multiblocks/metal_press"), ItemPredicate.Builder.func_200309_a().func_200308_a((IItemProvider)IEItems.Tools.hammer).func_200310_b())).func_203904_a(consumer, "immersiveengineering:main/mb_metalpress");
            Advancement silo = Advancements.advancement(steel, (IItemProvider)IEBlocks.Multiblocks.silo, "mb_silo", FrameType.TASK, true, true, false).func_200275_a("silo", (ICriterionInstance)MultiblockTrigger.create(new ResourceLocation("immersiveengineering", "multiblocks/silo"), ItemPredicate.Builder.func_200309_a().func_200308_a((IItemProvider)IEItems.Tools.hammer).func_200310_b())).func_203904_a(consumer, "immersiveengineering:main/mb_silo");
            Advancement crusher = Advancements.advancement(steel, (IItemProvider)IEBlocks.Multiblocks.crusher, "mb_crusher", FrameType.GOAL, true, true, false).func_200275_a("crusher", (ICriterionInstance)MultiblockTrigger.create(new ResourceLocation("immersiveengineering", "multiblocks/crusher"), ItemPredicate.Builder.func_200309_a().func_200308_a((IItemProvider)IEItems.Tools.hammer).func_200310_b())).func_203904_a(consumer, "immersiveengineering:main/mb_crusher");
            Advancement dieselgen = Advancements.advancement(steel, (IItemProvider)IEBlocks.Multiblocks.dieselGenerator, "mb_dieselgen", FrameType.GOAL, true, true, false).func_200275_a("dieselgenerator", (ICriterionInstance)MultiblockTrigger.create(new ResourceLocation("immersiveengineering", "multiblocks/diesel_generator"), ItemPredicate.Builder.func_200309_a().func_200308_a((IItemProvider)IEItems.Tools.hammer).func_200310_b())).func_203904_a(consumer, "immersiveengineering:main/mb_dieselgen");
            Advancement excavator = Advancements.advancement(steel, (IItemProvider)IEBlocks.Multiblocks.excavator, "mb_excavator", FrameType.CHALLENGE, true, true, false).func_200275_a("excavator", (ICriterionInstance)MultiblockTrigger.create(new ResourceLocation("immersiveengineering", "multiblocks/excavator"), ItemPredicate.Builder.func_200309_a().func_200308_a((IItemProvider)IEItems.Tools.hammer).func_200310_b())).func_203904_a(consumer, "immersiveengineering:main/mb_excavator");
            Advancement arcfurnace = Advancements.advancement(steel, (IItemProvider)IEBlocks.Multiblocks.arcFurnace, "mb_arcfurnace", FrameType.CHALLENGE, true, true, false).func_200275_a("arcfurnace", (ICriterionInstance)MultiblockTrigger.create(new ResourceLocation("immersiveengineering", "multiblocks/arcfurnace"), ItemPredicate.Builder.func_200309_a().func_200308_a((IItemProvider)IEItems.Tools.hammer).func_200310_b())).func_203904_a(consumer, "immersiveengineering:main/mb_arcfurnace");
            Advancement birthdayparty = Advancements.advancement(revolver, (IItemProvider)IEItems.Misc.iconBirthday, "secret_birthdayparty", FrameType.CHALLENGE, true, true, true).func_200275_a("code_trigger", (ICriterionInstance)new ImpossibleTrigger.Instance()).func_200274_a(Advancements.reward(new ResourceLocation("immersiveengineering", "advancements/shader_masterwork"))).func_203904_a(consumer, "immersiveengineering:main/secret_birthdayparty");
            Advancement luckofthedraw = Advancements.advancement(rtfm, (IItemProvider)IEItems.Misc.iconLucky, "secret_luckofthedraw", FrameType.CHALLENGE, true, true, true).func_200275_a("code_trigger", (ICriterionInstance)new ImpossibleTrigger.Instance()).func_200274_a(Advancements.reward(new ResourceLocation("immersiveengineering", "advancements/shader_masterwork"))).func_203904_a(consumer, "immersiveengineering:main/secret_luckofthedraw");
            Advancement drillbreak = Advancements.advancement(drill, (IItemProvider)IEItems.Misc.iconDrillbreak, "secret_drillbreak", FrameType.CHALLENGE, true, true, true).func_200275_a("code_trigger", (ICriterionInstance)new ImpossibleTrigger.Instance()).func_200274_a(Advancements.reward(new ResourceLocation("immersiveengineering", "advancements/shader_masterwork"))).func_203904_a(consumer, "immersiveengineering:main/secret_drillbreak");
            Advancement ravenholm = Advancements.advancement(railgun, (IItemProvider)IEItems.Misc.iconRavenholm, "secret_ravenholm", FrameType.CHALLENGE, true, true, true).func_200275_a("code_trigger", (ICriterionInstance)new ImpossibleTrigger.Instance()).func_200274_a(Advancements.reward(new ResourceLocation("immersiveengineering", "advancements/shader_masterwork"))).func_203904_a(consumer, "immersiveengineering:main/secret_ravenholm");
        }
    }
}

