/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.data.models;

import blusunrize.immersiveengineering.common.data.models.TransformationMap;
import com.google.common.base.Preconditions;
import com.google.common.io.CharStreams;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.IResource;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public class LoadedModelBuilder
extends ModelBuilder<LoadedModelBuilder> {
    private ResourceLocation loader;
    private final JsonObject additional = new JsonObject();
    private final TransformationMap transforms = new TransformationMap();

    protected LoadedModelBuilder(ResourceLocation outputLocation, ExistingFileHelper existingFileHelper) {
        super(outputLocation, existingFileHelper);
    }

    public LoadedModelBuilder loader(ResourceLocation loader) {
        this.loader = loader;
        return this;
    }

    public LoadedModelBuilder additional(String name, ResourceLocation value) {
        return this.additional(name, value.toString());
    }

    public LoadedModelBuilder additional(String name, List<String> value) {
        JsonArray arr = new JsonArray();
        for (String s : value) {
            arr.add(s);
        }
        this.additional.add(name, (JsonElement)arr);
        return this;
    }

    public LoadedModelBuilder additional(String name, boolean value) {
        this.additional.addProperty(name, Boolean.valueOf(value));
        return this;
    }

    public LoadedModelBuilder additional(String name, String value) {
        this.additional.addProperty(name, value);
        return this;
    }

    public LoadedModelBuilder additional(String name, JsonElement value) {
        this.additional.add(name, value);
        return this;
    }

    public JsonObject toJson() {
        JsonObject transformJson;
        JsonObject ret = super.toJson();
        if (this.loader != null) {
            ret.addProperty("loader", this.loader.toString());
            for (Map.Entry entry : this.additional.entrySet()) {
                Preconditions.checkState((!ret.has((String)entry.getKey()) ? 1 : 0) != 0);
                ret.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
        }
        if (!(transformJson = this.transforms.toJson()).entrySet().isEmpty()) {
            ret.add("transform", (JsonElement)transformJson);
        }
        return ret;
    }

    public ModelBuilder.TransformsBuilder transforms() {
        throw new UnsupportedOperationException("Use transforms(ResourceLocation) or transformationMap()");
    }

    public LoadedModelBuilder transforms(ResourceLocation source) {
        try {
            IResource transformFile = this.existingFileHelper.getResource(source, ResourcePackType.CLIENT_RESOURCES, ".json", "transformations");
            String jsonString = CharStreams.toString((Readable)new InputStreamReader(transformFile.func_199027_b()));
            this.transforms.addFromJson(jsonString);
            return this;
        }
        catch (IOException e) {
            throw new RuntimeException("While loading transforms from " + source, e);
        }
    }

    public TransformationMap transformationMap() {
        return this.transforms;
    }
}

