/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.data.models;

import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import net.minecraft.client.renderer.model.ItemTransformVec3f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.common.model.TransformationHelper;

public class TransformationMap {
    private static Field nameFromPerspective;
    private final Map<ModelBuilder.Perspective, TransformationMatrix> transforms = new TreeMap<ModelBuilder.Perspective, TransformationMatrix>();

    public TransformationMap setTransformations(ModelBuilder.Perspective t, Matrix4 mat) {
        this.transforms.put(t, new TransformationMatrix(mat.toMatrix4f()));
        return this;
    }

    private static String getName(ModelBuilder.Perspective p) {
        try {
            return (String)nameFromPerspective.get(p);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void addFromJson(String json) {
        Gson GSON = new GsonBuilder().registerTypeAdapter(TransformationMatrix.class, (Object)new TransformationHelper.Deserializer()).registerTypeAdapter(ItemTransformVec3f.class, (Object)new ItemTransformVec3f.Deserializer()).create();
        JsonObject obj = new JsonParser().parse(json).getAsJsonObject();
        HashMap<ModelBuilder.Perspective, TransformationMatrix> transforms = new HashMap<ModelBuilder.Perspective, TransformationMatrix>();
        Optional<String> type = Optional.ofNullable(obj.remove("type")).map(JsonElement::getAsString);
        boolean vanilla = type.map("vanilla"::equals).orElse(false);
        for (ModelBuilder.Perspective perspective : ModelBuilder.Perspective.values()) {
            TransformationMatrix transform;
            String key = TransformationMap.getName(perspective);
            JsonObject forType = obj.getAsJsonObject(key);
            obj.remove(key);
            if (forType == null) {
                key = this.alternateName(perspective);
                forType = obj.getAsJsonObject(key);
                obj.remove(key);
            }
            if (forType != null) {
                if (vanilla) {
                    ItemTransformVec3f vanillaTransform = (ItemTransformVec3f)GSON.fromJson((JsonElement)forType, ItemTransformVec3f.class);
                    transform = TransformationHelper.toTransformation((ItemTransformVec3f)vanillaTransform);
                } else {
                    transform = this.readMatrix(forType, GSON);
                    if (type.map("no_corner_offset"::equals).orElse(false).booleanValue()) {
                        transform = transform.blockCornerToCenter();
                    }
                }
            } else {
                transform = TransformationMatrix.func_227983_a_();
            }
            transforms.put(perspective, transform);
        }
        TransformationMatrix baseTransform = obj.size() > 0 ? this.readMatrix(obj, GSON) : TransformationMatrix.func_227983_a_();
        for (Map.Entry e : transforms.entrySet()) {
            TransformationMatrix transform = ((TransformationMatrix)e.getValue()).compose(baseTransform);
            this.transforms.put((ModelBuilder.Perspective)e.getKey(), transform);
        }
    }

    private TransformationMatrix readMatrix(JsonObject json, Gson GSON) {
        if (!json.has("origin")) {
            json.addProperty("origin", "center");
        }
        return (TransformationMatrix)GSON.fromJson((JsonElement)json, TransformationMatrix.class);
    }

    private String alternateName(ModelBuilder.Perspective type) {
        return type.vanillaType.name().toLowerCase();
    }

    public JsonObject toJson() {
        JsonObject ret = new JsonObject();
        for (Map.Entry<ModelBuilder.Perspective, TransformationMatrix> entry : this.transforms.entrySet()) {
            this.add(ret, entry.getKey(), entry.getValue());
        }
        return ret;
    }

    private void add(JsonObject main, ModelBuilder.Perspective type, TransformationMatrix trsr) {
        JsonObject result = new JsonObject();
        result.add("translation", (JsonElement)TransformationMap.toJson(trsr.getTranslation()));
        result.add("rotation", (JsonElement)TransformationMap.toJson(trsr.func_227989_d_()));
        result.add("scale", (JsonElement)TransformationMap.toJson(trsr.getScale()));
        result.add("post-rotation", (JsonElement)TransformationMap.toJson(trsr.getRightRot()));
        result.addProperty("origin", "corner");
        main.add(TransformationMap.getName(type), (JsonElement)result);
    }

    private static JsonArray toJson(Quaternion v) {
        JsonArray ret = new JsonArray();
        ret.add((Number)Float.valueOf(v.func_195889_a()));
        ret.add((Number)Float.valueOf(v.func_195891_b()));
        ret.add((Number)Float.valueOf(v.func_195893_c()));
        ret.add((Number)Float.valueOf(v.func_195894_d()));
        return ret;
    }

    private static JsonArray toJson(Vector3f v) {
        JsonArray ret = new JsonArray();
        ret.add((Number)Float.valueOf(v.func_195899_a()));
        ret.add((Number)Float.valueOf(v.func_195900_b()));
        ret.add((Number)Float.valueOf(v.func_195902_c()));
        return ret;
    }

    private static Vector3f fromJson(JsonElement ele) {
        JsonArray arr = ele.getAsJsonArray();
        return new Vector3f(arr.get(0).getAsFloat(), arr.get(1).getAsFloat(), arr.get(2).getAsFloat());
    }

    static {
        try {
            nameFromPerspective = ModelBuilder.Perspective.class.getDeclaredField("name");
            nameFromPerspective.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

