/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.data.resources;

import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.common.data.DataGenUtils;
import blusunrize.immersiveengineering.common.data.Recipes;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;

public class SecondaryOutput {
    private final IngredientWithSize item;
    private final float chance;
    private ICondition[] conditions;

    public SecondaryOutput(IngredientWithSize item, float chance) {
        this.item = item;
        this.chance = chance;
        this.conditions = new ICondition[0];
    }

    public SecondaryOutput(ITag.INamedTag<Item> tag, float chance) {
        this(new IngredientWithSize((ITag<Item>)tag), chance);
        this.conditions = new ICondition[]{Recipes.getTagCondition(tag)};
    }

    public SecondaryOutput(ResourceLocation tag, float chance) {
        this(DataGenUtils.createItemWrapper(tag), chance);
    }

    public IngredientWithSize getItem() {
        return this.item;
    }

    public float getChance() {
        return this.chance;
    }

    public SecondaryOutput setConditions(ICondition[] conditions) {
        this.conditions = conditions;
        return this;
    }

    public ICondition[] getConditions() {
        return this.conditions;
    }
}

