/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.gui.GuiHandler;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class IEMinecartEntity<T extends IEBaseTileEntity>
extends AbstractMinecartEntity
implements INamedContainerProvider {
    protected T containedTileEntity = (IEBaseTileEntity)this.getTileProvider().get();

    protected IEMinecartEntity(EntityType<?> type, World world, double x, double y, double z) {
        super(type, world, x, y, z);
    }

    protected IEMinecartEntity(EntityType<?> type, World world) {
        super(type, world);
    }

    protected abstract Supplier<T> getTileProvider();

    public T getContainedTileEntity() {
        return this.containedTileEntity;
    }

    public abstract void writeTileToItem(ItemStack var1);

    public abstract void readTileFromItem(LivingEntity var1, ItemStack var2);

    public AbstractMinecartEntity.Type func_184264_v() {
        return AbstractMinecartEntity.Type.CHEST;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.func_70089_S() && this.containedTileEntity != null) {
            return ((IEBaseTileEntity)this.containedTileEntity).getCapability(capability, facing);
        }
        return super.getCapability(capability, facing);
    }

    public void func_94095_a(DamageSource source) {
        this.func_70106_y();
        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            ItemStack itemstack = this.getCartItem();
            this.writeTileToItem(itemstack);
            if (this.func_145818_k_()) {
                itemstack.func_200302_a(this.func_200201_e());
            }
            this.func_199701_a_(itemstack);
        }
    }

    protected abstract void invalidateCaps();

    public int getComparatorLevel() {
        if (this.containedTileEntity instanceof IEBlockInterfaces.IComparatorOverride) {
            return ((IEBlockInterfaces.IComparatorOverride)this.containedTileEntity).getComparatorInputOverride();
        }
        return super.getComparatorLevel();
    }

    public void remove(boolean keepData) {
        super.remove(keepData);
        if (!keepData) {
            this.invalidateCaps();
        }
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        ActionResultType superResult = super.func_184230_a(player, hand);
        if (superResult == ActionResultType.SUCCESS) {
            return superResult;
        }
        if (!this.field_70170_p.field_72995_K && this.containedTileEntity instanceof IEBlockInterfaces.IInteractionObjectIE) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, buffer -> buffer.writeInt(this.func_145782_y()));
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return GuiHandler.createContainer(playerInventory, this, id);
    }

    protected void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.containedTileEntity != null) {
            ((IEBaseTileEntity)this.containedTileEntity).writeCustomNBT(compound, false);
        }
    }

    protected void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.containedTileEntity = (IEBaseTileEntity)this.getTileProvider().get();
        ((IEBaseTileEntity)this.containedTileEntity).readCustomNBT(compound, false);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

