/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceFuel;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.crafting.ClocheFertilizer;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.shader.IShaderItem;
import blusunrize.immersiveengineering.api.tool.IConfigurableTool;
import blusunrize.immersiveengineering.api.tool.IUpgrade;
import blusunrize.immersiveengineering.api.tool.IUpgradeableTool;
import blusunrize.immersiveengineering.common.gui.AutoWorkbenchContainer;
import blusunrize.immersiveengineering.common.gui.BlueprintInventory;
import blusunrize.immersiveengineering.common.gui.MaintenanceKitContainer;
import blusunrize.immersiveengineering.common.gui.ModWorkbenchContainer;
import blusunrize.immersiveengineering.common.items.BulletItem;
import blusunrize.immersiveengineering.common.items.EngineersBlueprintItem;
import blusunrize.immersiveengineering.common.items.IEItems;
import blusunrize.immersiveengineering.common.util.inventory.IEItemStackHandler;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public abstract class IESlot
extends Slot {
    final Container container;

    public IESlot(Container container, IInventory inv, int id, int x, int y) {
        super(inv, id, x, y);
        this.container = container;
    }

    public boolean func_75214_a(ItemStack itemStack) {
        return true;
    }

    public static interface ICallbackContainer {
        public boolean canInsert(ItemStack var1, int var2, Slot var3);

        public boolean canTake(ItemStack var1, int var2, Slot var3);
    }

    public static class ContainerCallback
    extends SlotItemHandler {
        Container container;

        public ContainerCallback(Container container, IItemHandler inv, int id, int x, int y) {
            super(inv, id, x, y);
            this.container = container;
        }

        public boolean func_75214_a(ItemStack itemStack) {
            if (this.container instanceof ICallbackContainer) {
                return ((ICallbackContainer)this.container).canInsert(itemStack, this.field_75222_d, (Slot)this);
            }
            return true;
        }

        public boolean func_82869_a(PlayerEntity player) {
            if (this.container instanceof ICallbackContainer) {
                return ((ICallbackContainer)this.container).canTake(this.func_75211_c(), this.field_75222_d, (Slot)this);
            }
            return true;
        }
    }

    public static class Cloche
    extends IESlot {
        int type = 0;

        public Cloche(int type, Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
            this.type = type;
        }

        public int func_75219_a() {
            return this.type < 2 ? 1 : 64;
        }

        @Override
        public boolean func_75214_a(ItemStack itemStack) {
            if (itemStack.func_190926_b()) {
                return false;
            }
            if (this.type == 2) {
                return ClocheFertilizer.isValidFertilizer(itemStack);
            }
            return true;
        }
    }

    public static class ArcElectrode
    extends IESlot {
        public ArcElectrode(Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        public int func_75219_a() {
            return 1;
        }

        @Override
        public boolean func_75214_a(ItemStack itemStack) {
            return !itemStack.func_190926_b() && IEItems.Misc.graphiteElectrode.equals(itemStack.func_77973_b());
        }
    }

    public static class ArcAdditive
    extends IESlot {
        public ArcAdditive(Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        @Override
        public boolean func_75214_a(ItemStack itemStack) {
            return !itemStack.func_190926_b() && ArcFurnaceRecipe.isValidRecipeAdditive(itemStack);
        }
    }

    public static class ArcInput
    extends IESlot {
        public ArcInput(Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        @Override
        public boolean func_75214_a(ItemStack itemStack) {
            return !itemStack.func_190926_b() && ArcFurnaceRecipe.isValidRecipeInput(itemStack);
        }
    }

    public static class BlueprintOutput
    extends IESlot {
        private final IInventory inputInventory;
        public final BlueprintCraftingRecipe recipe;

        public BlueprintOutput(Container container, BlueprintInventory inv, IInventory inputInventory, int id, int x, int y, BlueprintCraftingRecipe recipe) {
            super(container, (IInventory)inv, id, x, y);
            this.inputInventory = inputInventory;
            this.recipe = recipe;
        }

        @Override
        public boolean func_75214_a(ItemStack itemStack) {
            return false;
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean func_111238_b() {
            return this.func_75216_d();
        }

        public ItemStack func_190901_a(PlayerEntity player, ItemStack stack) {
            ((BlueprintInventory)this.field_75224_c).reduceIputs(this.inputInventory, this.recipe, stack);
            return super.func_190901_a(player, stack);
        }
    }

    public static class BlueprintInput
    extends IESlot {
        private final BlueprintInventory outputInventory;

        public BlueprintInput(Container container, IInventory inv, BlueprintInventory outputInventory, int id, int x, int y) {
            super(container, inv, id, x, y);
            this.outputInventory = outputInventory;
        }

        public void func_75218_e() {
            this.outputInventory.updateOutputs(this.field_75224_c);
            super.func_75218_e();
        }
    }

    public static class ItemDisplay
    extends IESlot {
        public ItemDisplay(Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        @Override
        public boolean func_75214_a(ItemStack itemStack) {
            return false;
        }

        public boolean func_82869_a(PlayerEntity player) {
            return false;
        }
    }

    public static class Ghost
    extends IESlot {
        public Ghost(Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        public void func_75215_d(ItemStack itemStack) {
            super.func_75215_d(itemStack);
        }

        public boolean func_82869_a(PlayerEntity player) {
            return false;
        }

        public int func_75219_a() {
            return 1;
        }
    }

    public static class AutoBlueprint
    extends IESlot {
        public AutoBlueprint(Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        @Override
        public boolean func_75214_a(ItemStack itemStack) {
            return !itemStack.func_190926_b() && itemStack.func_77973_b() instanceof EngineersBlueprintItem;
        }

        public int func_75219_a() {
            return 1;
        }

        public void func_75218_e() {
            super.func_75218_e();
            if (this.container instanceof AutoWorkbenchContainer) {
                ImmersiveEngineering.proxy.reInitGui();
            }
        }
    }

    public static class Maintenance
    extends IESlot {
        public Maintenance(MaintenanceKitContainer container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        @Override
        public boolean func_75214_a(ItemStack itemStack) {
            if (itemStack.func_190926_b()) {
                return false;
            }
            if (itemStack.func_77973_b() instanceof IUpgradeableTool) {
                return ((IUpgradeableTool)itemStack.func_77973_b()).canModify(itemStack);
            }
            if (itemStack.func_77973_b() instanceof IConfigurableTool) {
                return ((IConfigurableTool)itemStack.func_77973_b()).canConfigure(itemStack);
            }
            return false;
        }

        public void func_75218_e() {
            super.func_75218_e();
            if (this.container instanceof MaintenanceKitContainer) {
                ((MaintenanceKitContainer)this.container).updateSlots();
            }
        }

        public boolean func_82869_a(PlayerEntity player) {
            return this.func_75211_c().func_190926_b() || !(this.func_75211_c().func_77973_b() instanceof IUpgradeableTool) || ((IUpgradeableTool)this.func_75211_c().func_77973_b()).canTakeFromWorkbench(this.func_75211_c());
        }

        public ItemStack func_190901_a(PlayerEntity player, ItemStack stack) {
            ItemStack result = super.func_190901_a(player, stack);
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof IUpgradeableTool) {
                ((IUpgradeableTool)stack.func_77973_b()).removeFromWorkbench(player, stack);
            }
            return result;
        }
    }

    public static class ModWorkbench
    extends IESlot {
        int size;

        public ModWorkbench(ModWorkbenchContainer container, IInventory inv, int id, int x, int y, int size) {
            super(container, inv, id, x, y);
            this.size = size;
        }

        @Override
        public boolean func_75214_a(ItemStack itemStack) {
            if (itemStack.func_190926_b()) {
                return false;
            }
            if (itemStack.func_77973_b() instanceof EngineersBlueprintItem) {
                return true;
            }
            if (itemStack.func_77973_b() instanceof IUpgradeableTool) {
                return ((IUpgradeableTool)itemStack.func_77973_b()).canModify(itemStack);
            }
            if (itemStack.func_77973_b() instanceof IConfigurableTool) {
                return ((IConfigurableTool)itemStack.func_77973_b()).canConfigure(itemStack);
            }
            return false;
        }

        public int func_75219_a() {
            return this.size;
        }

        public void func_75218_e() {
            super.func_75218_e();
            if (this.container instanceof ModWorkbenchContainer) {
                ((ModWorkbenchContainer)this.container).rebindSlots();
            }
        }

        public boolean func_82869_a(PlayerEntity player) {
            return this.func_75211_c().func_190926_b() || !(this.func_75211_c().func_77973_b() instanceof IUpgradeableTool) || ((IUpgradeableTool)this.func_75211_c().func_77973_b()).canTakeFromWorkbench(this.func_75211_c());
        }

        public ItemStack func_190901_a(PlayerEntity player, ItemStack stack) {
            ItemStack result = super.func_190901_a(player, stack);
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof IUpgradeableTool) {
                ((IUpgradeableTool)stack.func_77973_b()).removeFromWorkbench(player, stack);
            }
            stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(handler -> {
                if (handler instanceof IEItemStackHandler) {
                    ((IEItemStackHandler)((Object)handler)).setTile(null);
                }
            });
            return result;
        }
    }

    public static class Shader
    extends IESlot {
        ItemStack tool;

        public Shader(Container container, IInventory inv, int id, int x, int y, ItemStack tool) {
            super(container, inv, id, x, y);
            this.tool = tool;
            this.setBackground(PlayerContainer.field_226615_c_, new ResourceLocation("immersiveengineering", "item/shader_slot"));
        }

        @Override
        public boolean func_75214_a(ItemStack itemStack) {
            if (itemStack.func_190926_b() || !(itemStack.func_77973_b() instanceof IShaderItem) || this.tool.func_190926_b()) {
                return false;
            }
            return this.tool.getCapability(CapabilityShader.SHADER_CAPABILITY).map(wrapper -> ((IShaderItem)itemStack.func_77973_b()).getShaderCase(itemStack, this.tool, wrapper.getShaderType()) != null).orElse(false);
        }

        public int func_75219_a() {
            return 1;
        }
    }

    public static class Upgrades
    extends SlotItemHandler {
        final ItemStack upgradeableTool;
        final String type;
        final boolean preventDoubles;
        final Container container;
        final Supplier<World> getWorld;
        final Supplier<PlayerEntity> getPlayer;

        public Upgrades(Container container, IItemHandler inv, int id, int x, int y, String type, ItemStack upgradeableTool, boolean preventDoubles, Supplier<World> getWorld, Supplier<PlayerEntity> getPlayer) {
            super(inv, id, x, y);
            this.container = container;
            this.type = type;
            this.upgradeableTool = upgradeableTool;
            this.preventDoubles = preventDoubles;
            this.getWorld = getWorld;
            this.getPlayer = getPlayer;
        }

        public boolean func_75214_a(@Nonnull ItemStack itemStack) {
            if (this.preventDoubles) {
                for (Slot slot : this.container.field_75151_b) {
                    if (!(slot instanceof Upgrades) || !((Upgrades)slot).preventDoubles || !ItemStack.func_179545_c((ItemStack)slot.func_75211_c(), (ItemStack)itemStack)) continue;
                    return false;
                }
            }
            return !itemStack.func_190926_b() && itemStack.func_77973_b() instanceof IUpgrade && ((IUpgrade)itemStack.func_77973_b()).getUpgradeTypes(itemStack).contains(this.type) && ((IUpgrade)itemStack.func_77973_b()).canApplyUpgrades(this.upgradeableTool, itemStack);
        }

        public int func_75219_a() {
            return 64;
        }

        public ItemStack func_190901_a(PlayerEntity thePlayer, ItemStack stack) {
            stack = ((IUpgradeableTool)this.upgradeableTool.func_77973_b()).removeUpgrade(this.upgradeableTool, thePlayer, stack);
            stack = super.func_190901_a(thePlayer, stack);
            return stack;
        }

        public void func_75218_e() {
            super.func_75218_e();
            ((IUpgradeableTool)this.upgradeableTool.func_77973_b()).recalculateUpgrades(this.upgradeableTool, this.getWorld.get(), this.getPlayer.get());
            if (this.container instanceof ModWorkbenchContainer) {
                ((ModWorkbenchContainer)this.container).rebindSlots();
            } else if (this.container instanceof MaintenanceKitContainer) {
                ((MaintenanceKitContainer)this.container).updateSlots();
            }
        }
    }

    public static class WithPredicate
    extends SlotItemHandler {
        final Predicate<ItemStack> predicate;

        public WithPredicate(IItemHandler inv, int id, int x, int y, Predicate<ItemStack> predicate) {
            super(inv, id, x, y);
            this.predicate = predicate;
        }

        public boolean func_75214_a(ItemStack itemStack) {
            return !itemStack.func_190926_b() && this.predicate.test(itemStack);
        }

        public int func_75219_a() {
            return 1;
        }
    }

    public static class Bullet
    extends SlotItemHandler {
        int limit;

        public Bullet(IItemHandler inv, int id, int x, int y, int limit) {
            super(inv, id, x, y);
            this.limit = limit;
        }

        public boolean func_75214_a(ItemStack itemStack) {
            return !itemStack.func_190926_b() && itemStack.func_77973_b() instanceof BulletItem;
        }

        public int func_75219_a() {
            return this.limit;
        }

        public int func_178170_b(@Nonnull ItemStack stack) {
            return this.limit;
        }
    }

    public static class BlastFuel
    extends IESlot {
        public BlastFuel(Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        @Override
        public boolean func_75214_a(ItemStack itemStack) {
            return BlastFurnaceFuel.isValidBlastFuel(itemStack);
        }
    }

    public static class FluidContainer
    extends IESlot {
        int filter;

        public FluidContainer(Container container, IInventory inv, int id, int x, int y, int filter) {
            super(container, inv, id, x, y);
            this.filter = filter;
        }

        @Override
        public boolean func_75214_a(ItemStack itemStack) {
            LazyOptional handlerCap = FluidUtil.getFluidHandler((ItemStack)itemStack);
            return handlerCap.map(handler -> {
                if (handler.getTanks() <= 0) {
                    return false;
                }
                if (this.filter == 1) {
                    return handler.getFluidInTank(0).isEmpty();
                }
                if (this.filter == 2) {
                    return !handler.getFluidInTank(0).isEmpty();
                }
                return true;
            }).orElse(false);
        }
    }

    public static class IEFurnaceSFuelSlot
    extends IESlot {
        public IEFurnaceSFuelSlot(Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        @Override
        public boolean func_75214_a(ItemStack p_75214_1_) {
            return AbstractFurnaceTileEntity.func_213991_b((ItemStack)p_75214_1_) || IEFurnaceSFuelSlot.isBucket(p_75214_1_);
        }

        public int func_178170_b(ItemStack p_178170_1_) {
            return IEFurnaceSFuelSlot.isBucket(p_178170_1_) ? 1 : super.func_178170_b(p_178170_1_);
        }

        public static boolean isBucket(ItemStack p_178173_0_) {
            return p_178173_0_.func_77973_b() == Items.field_151133_ar;
        }
    }

    public static class Output
    extends IESlot {
        public Output(Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        @Override
        public boolean func_75214_a(ItemStack itemStack) {
            return false;
        }
    }
}

