/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.tool.IConfigurableTool;
import blusunrize.immersiveengineering.api.tool.ITool;
import blusunrize.immersiveengineering.client.models.ModelEarmuffs;
import blusunrize.immersiveengineering.client.utils.FontUtils;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EarmuffsItem
extends IEBaseItem
implements IDyeableArmorItem,
IConfigurableTool,
ITool,
IEItemInterfaces.IColouredItem {
    @OnlyIn(value=Dist.CLIENT)
    BipedModel armorModel;
    public static LinkedHashSet<String> affectedSoundCategories = Sets.newLinkedHashSet();

    public EarmuffsItem() {
        super("earmuffs");
    }

    public boolean canEquip(ItemStack stack, EquipmentSlotType armorType, Entity entity) {
        return armorType == EquipmentSlotType.HEAD;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        if ("overlay".equals(type)) {
            return "immersiveengineering:textures/models/earmuffs_overlay.png";
        }
        return "immersiveengineering:textures/models/earmuffs.png";
    }

    @OnlyIn(value=Dist.CLIENT)
    public BipedModel getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, BipedModel _default) {
        return ModelEarmuffs.getModel();
    }

    @Override
    public boolean hasCustomItemColours() {
        return true;
    }

    @Override
    public int getColourForIEItem(ItemStack stack, int renderPass) {
        if (renderPass == 1) {
            return 0xFFFFFF;
        }
        if (!ItemNBTHelper.hasKey(stack, "IE:EarmuffColour")) {
            return 4746388;
        }
        return ItemNBTHelper.getInt(stack, "IE:EarmuffColour");
    }

    public boolean func_200883_f_(ItemStack stack) {
        return true;
    }

    public int func_200886_f(ItemStack stack) {
        if (!ItemNBTHelper.hasKey(stack, "IE:EarmuffColour")) {
            return 4746388;
        }
        return ItemNBTHelper.getInt(stack, "IE:EarmuffColour");
    }

    public void func_200884_g(ItemStack stack) {
        if (ItemNBTHelper.hasKey(stack, "IE:EarmuffColour")) {
            ItemNBTHelper.remove(stack, "IE:EarmuffColour");
        }
    }

    public void func_200885_a(ItemStack stack, int color) {
        ItemNBTHelper.putInt(stack, "IE:EarmuffColour", color);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        int color = this.getColourForIEItem(stack, 0);
        TranslationTextComponent mainComponent = new TranslationTextComponent("desc.immersiveengineering.info.colour");
        list.add((ITextComponent)FontUtils.withAppendColoredColour((IFormattableTextComponent)mainComponent, color));
    }

    public static float getVolumeMod(ItemStack stack) {
        if (!ItemNBTHelper.hasKey(stack, "IE:Earmuffs:Volume")) {
            return 0.1f;
        }
        return ItemNBTHelper.getFloat(stack, "IE:Earmuffs:Volume");
    }

    @Override
    public boolean canConfigure(ItemStack stack) {
        return true;
    }

    @Override
    public IConfigurableTool.ToolConfig.ToolConfigBoolean[] getBooleanOptions(ItemStack stack) {
        IConfigurableTool.ToolConfig.ToolConfigBoolean[] array = new IConfigurableTool.ToolConfig.ToolConfigBoolean[affectedSoundCategories.size()];
        int i = -1;
        for (String cat : affectedSoundCategories) {
            int n = 60 + ++i / 4 * 55;
            array[i] = new IConfigurableTool.ToolConfig.ToolConfigBoolean(cat, n, 32 + 10 * (i % 4), !ItemNBTHelper.getBoolean(stack, "IE:Earmuffs:Cat_" + cat));
        }
        return array;
    }

    @Override
    public IConfigurableTool.ToolConfig.ToolConfigFloat[] getFloatOptions(ItemStack stack) {
        return new IConfigurableTool.ToolConfig.ToolConfigFloat[]{new IConfigurableTool.ToolConfig.ToolConfigFloat("reductionValue", 60, 20, 1.0f - EarmuffsItem.getVolumeMod(stack))};
    }

    @Override
    public String fomatConfigName(ItemStack stack, IConfigurableTool.ToolConfig config) {
        if (config instanceof IConfigurableTool.ToolConfig.ToolConfigFloat) {
            return I18n.func_135052_a((String)"gui.immersiveengineering.config.earmuffs.noisegate", (Object[])new Object[0]);
        }
        return I18n.func_135052_a((String)("gui.immersiveengineering.config.earmuffs.soundcategory." + config.name), (Object[])new Object[0]);
    }

    @Override
    public String fomatConfigDescription(ItemStack stack, IConfigurableTool.ToolConfig config) {
        return null;
    }

    @Override
    public void applyConfigOption(ItemStack stack, String key, Object value) {
        if (value instanceof Boolean) {
            ItemNBTHelper.putBoolean(stack, "IE:Earmuffs:Cat_" + key, (Boolean)value == false);
        } else if (value instanceof Float) {
            ItemNBTHelper.putFloat(stack, "IE:Earmuffs:Volume", 1.0f - ((Float)value).floatValue());
        }
    }

    @Override
    public boolean isTool(ItemStack item) {
        return true;
    }

    static {
        affectedSoundCategories.add("ambient");
        affectedSoundCategories.add("weather");
        affectedSoundCategories.add("record");
        affectedSoundCategories.add("block");
        affectedSoundCategories.add("neutral");
        affectedSoundCategories.add("hostile");
        affectedSoundCategories.add("player");
    }
}

