/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.inventory.IEItemStackHandler;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public abstract class InternalStorageItem
extends IEBaseItem {
    public InternalStorageItem(String name, Item.Properties props) {
        super(name, props);
    }

    public abstract int getSlotCount(ItemStack var1);

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (!stack.func_190926_b()) {
            return new IEItemStackHandler(stack);
        }
        return null;
    }

    public void setContainedItems(ItemStack stack, NonNullList<ItemStack> inventory) {
        LazyOptional lazyHandler = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        lazyHandler.ifPresent(handler -> {
            if (handler instanceof IItemHandlerModifiable) {
                if (inventory.size() != handler.getSlots()) {
                    throw new IllegalArgumentException("Parameter inventory has " + inventory.size() + " slots, capability inventory has " + handler.getSlots());
                }
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ((IItemHandlerModifiable)handler).setStackInSlot(i, (ItemStack)inventory.get(i));
                }
            } else {
                IELogger.warn("No valid inventory handler found for " + stack);
            }
        });
    }

    public NonNullList<ItemStack> getContainedItems(ItemStack stack) {
        LazyOptional lazyHandler = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        Optional ret = lazyHandler.map(handler -> {
            if (handler instanceof IEItemStackHandler) {
                return ((IEItemStackHandler)((Object)handler)).getContainedItems();
            }
            IELogger.warn("Inefficiently getting contained items. Why does " + stack + " have a non-IE IItemHandler?");
            NonNullList inv = NonNullList.func_191197_a((int)handler.getSlots(), (Object)ItemStack.field_190927_a);
            for (int i = 0; i < handler.getSlots(); ++i) {
                inv.set(i, (Object)handler.getStackInSlot(i));
            }
            return inv;
        });
        return ret.orElse(NonNullList.func_191196_a());
    }
}

