/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.CapabilitySkyhookData;
import blusunrize.immersiveengineering.api.tool.ITool;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.utils.WireUtils;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.UpgradeableToolItem;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.SkylineHelper;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class SkyhookItem
extends UpgradeableToolItem
implements ITool {
    private static final String LIMIT_SPEED = "limitSpeed";

    public SkyhookItem() {
        super("skyhook", new Item.Properties().func_200917_a(1), "SKYHOOK");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (SkyhookItem.shouldLimitSpeed(stack)) {
            list.add((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.flavour.skyhook.speedLimit"));
        } else {
            list.add((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.flavour.skyhook.noLimit"));
        }
        list.add((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.flavour.skyhook"));
    }

    public static boolean shouldLimitSpeed(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, LIMIT_SPEED);
    }

    public static void setLimitSpeed(ItemStack stack, boolean doLimit) {
        ItemNBTHelper.putBoolean(stack, LIMIT_SPEED, doLimit);
    }

    public static boolean toggleSpeedLimit(ItemStack stack) {
        CompoundNBT nbt;
        boolean wasActive = (nbt = stack.func_196082_o()).func_74767_n(LIMIT_SPEED);
        nbt.func_74757_a(LIMIT_SPEED, !wasActive);
        return !wasActive;
    }

    public void func_77663_a(ItemStack stack, World world, Entity ent, int slot, boolean inHand) {
        super.func_77663_a(stack, world, ent, slot, inHand);
        if (this.getUpgrades(stack).func_74767_n("fallBoost")) {
            float dmg = (float)Math.ceil(ent.field_70143_R / 5.0f);
            ItemNBTHelper.putFloat(stack, "fallDamageBoost", dmg);
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_184811_cZ().func_185141_a((Item)this)) {
            return new ActionResult(ActionResultType.PASS, (Object)stack);
        }
        if (player.func_225608_bj_()) {
            boolean limitSpeed = SkyhookItem.toggleSpeedLimit(stack);
            if (limitSpeed) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.immersiveengineering.info.skyhookLimited"), true);
            } else {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.immersiveengineering.info.skyhookUnlimited"), true);
            }
        } else {
            CapabilitySkyhookData.SkyhookUserData data = (CapabilitySkyhookData.SkyhookUserData)player.getCapability(CapabilitySkyhookData.SKYHOOK_USER_DATA, Direction.UP).orElseThrow(RuntimeException::new);
            if (data.hook != null && !world.field_72995_K) {
                data.dismount();
                IELogger.logger.info("Player left voluntarily");
            } else {
                data.startHolding();
                player.func_184598_c(hand);
            }
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        super.onUsingTick(stack, player, count);
        CapabilitySkyhookData.SkyhookUserData data = (CapabilitySkyhookData.SkyhookUserData)player.getCapability(CapabilitySkyhookData.SKYHOOK_USER_DATA, Direction.UP).orElseThrow(RuntimeException::new);
        if (data.getStatus() != CapabilitySkyhookData.SkyhookStatus.HOLDING_CONNECTING) {
            return;
        }
        World world = player.field_70170_p;
        Connection con = WireUtils.getConnectionMovedThrough(world, player);
        if (con != null) {
            SkylineHelper.spawnHook(player, con, player.func_184600_cs(), SkyhookItem.shouldLimitSpeed(stack));
        }
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity player, int timeLeft) {
        super.func_77615_a(stack, worldIn, player, timeLeft);
        if (!worldIn.field_72995_K) {
            player.getCapability(CapabilitySkyhookData.SKYHOOK_USER_DATA, Direction.UP).ifPresent(CapabilitySkyhookData.SkyhookUserData::release);
        }
    }

    public float getSkylineSpeed(ItemStack stack) {
        return 3.0f + this.getUpgrades(stack).func_74760_g("speed");
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    @Override
    public boolean canModify(ItemStack stack) {
        return true;
    }

    @Override
    public Slot[] getWorkbenchSlots(Container container, ItemStack stack, Supplier<World> getWorld, Supplier<PlayerEntity> getPlayer) {
        IItemHandler inv = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElseThrow(RuntimeException::new);
        return new Slot[]{new IESlot.Upgrades(container, inv, 0, 102, 42, "SKYHOOK", stack, true, getWorld, getPlayer), new IESlot.Upgrades(container, inv, 1, 102, 22, "SKYHOOK", stack, true, getWorld, getPlayer)};
    }

    @Override
    public int getSlotCount(ItemStack stack) {
        return 2;
    }

    @Override
    public boolean isTool(ItemStack item) {
        return true;
    }
}

