/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.tool.ITool;
import blusunrize.immersiveengineering.common.items.BulletItem;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.InternalStorageItem;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.ListUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;

public class SpeedloaderItem
extends InternalStorageItem
implements ITool,
IEItemInterfaces.IBulletContainer {
    public SpeedloaderItem() {
        super("speedloader", new Item.Properties().func_200917_a(1));
    }

    @Override
    public int getSlotCount(ItemStack stack) {
        return 8;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            this.openGui(player, hand == Hand.MAIN_HAND ? EquipmentSlotType.MAINHAND : EquipmentSlotType.OFFHAND);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public boolean isEmpty(ItemStack stack) {
        return stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).map(inv -> {
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack b = inv.getStackInSlot(i);
                if (b.func_190926_b() || !(b.func_77973_b() instanceof BulletItem)) continue;
                return false;
            }
            return true;
        }).orElse(true);
    }

    @Override
    public boolean isTool(ItemStack item) {
        return true;
    }

    @Override
    public int getBulletCount(ItemStack container) {
        return this.getSlotCount(container);
    }

    @Override
    public NonNullList<ItemStack> getBullets(ItemStack revolver, boolean remote) {
        if (!remote && this.isEmpty(revolver)) {
            remote = true;
        } else if (remote && !ItemNBTHelper.hasKey(revolver, "bullets")) {
            remote = false;
        }
        if (!remote) {
            return ListUtils.fromItems(this.getContainedItems(revolver).subList(0, this.getSlotCount(revolver)));
        }
        return Utils.readInventory(revolver.func_196082_o().func_150295_c("bullets", 10), this.getSlotCount(revolver));
    }

    @Nullable
    public CompoundNBT getShareTag(ItemStack stack) {
        CompoundNBT ret = super.getShareTag(stack);
        ret = ret == null ? new CompoundNBT() : ret.func_74737_b();
        CompoundNBT retConst = ret;
        stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(handler -> {
            NonNullList bullets = NonNullList.func_191197_a((int)this.getSlotCount(stack), (Object)ItemStack.field_190927_a);
            for (int i = 0; i < this.getSlotCount(stack); ++i) {
                bullets.set(i, (Object)handler.getStackInSlot(i));
            }
            retConst.func_218657_a("bullets", (INBT)Utils.writeInventory((Collection<ItemStack>)bullets));
        });
        return retConst;
    }
}

